/**********************************************************
   TEA - Tiny Encryption Algorithm
   Feistel cipher by David Wheeler & Roger M. Needham
   (extended version)
 **********************************************************/

#ifndef LIBDEFS_H
# define LIBDEFS_H
# include <libdefs.h>
#endif
#include <swap.h>

#define ROUNDS 32
#define DELTA 0x9e3779b9 /* sqr(5)-1 * 2^31 */

/**********************************************************
   Input values: 	k[4]	128-bit key
			v[2]    64-bit plaintext block
   Output values:	v[2]    64-bit ciphertext block 
 **********************************************************/

void _mcrypt_tean(word32 *k, word32 *v, long N) {
#ifdef WORDS_BIGENDIAN
  word32 y=v[0], z=v[1];
#else
  word32 y=byteswap(v[0]), z=byteswap(v[1]);
#endif  
  word32 limit,sum=0;

  if(N>0) { /* ENCRYPT */
    limit=DELTA*N;
#ifdef WORDS_BIGENDIAN
    while(sum!=limit) {
      y+=(z<<4 ^ z>>5) + z^sum + k[sum&3];
      sum+=DELTA;
      z+=(y<<4^y>>5) + y^sum + k[(sum>>11)&3];
    }
  } else { /* DECRYPT */
    sum=DELTA*(-N);
    while(sum) {
      z-= ( (y<<4 ^ y>>5) + y ) ^ ( sum + k[(sum>>11)&3]);
      sum-=DELTA;
      y-=( (z<<4 ^ z>>5) + z) ^ ( sum + k[sum&3]);
#else
    while(sum!=limit) {
      y+=(( z<<4 ^ z>>5) + z ) ^ ( sum + byteswap(k[sum&3]));
      sum+=DELTA;
      z+=(( y<<4 ^ y>>5 ) + y ) ^ ( sum + byteswap(k[(sum>>11)&3]));
    }
  } else { /* DECRYPT */
    sum=DELTA*(-N);
    while(sum) {
      z-=( ( y<<4 ^ y>>5 ) + y ) ^ ( sum + byteswap(k[(sum>>11)&3]) );
      sum-=DELTA;
      y-=(( z<<4 ^ z>>5) + z ) ^ ( sum + byteswap(k[sum&3]));
#endif
    }
  }
#ifdef WORDS_BIGENDIAN
  v[0]=y; v[1]=z;
#else
  v[0]=byteswap(y); v[1]=byteswap(z);
#endif  
}

void _mcrypt_cl_enc_block(word32 *k, word32 *v) {
 _mcrypt_tean(k,v,ROUNDS);
}

void _mcrypt_cl_dec_block(word32 *k, word32 *v) {
 _mcrypt_tean(k,v,-ROUNDS);
}
