#include "../lib/mcrypt.h"
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

/* Prints plaintext and ciphertext in hex for all the algorithms */

/* #define DEBUG */

 char test0[200][200];

int main() {

int td,i;
int j,x=0;
unsigned char *keyword, *password;
unsigned char *plaintext; 
unsigned char *ciphertext;
unsigned char cipher_tmp[200];
char *name;


printf("Checking whether the algorithm's encryption/decryption work normally\n");

/* Test vectors with key and plaintext == zero */
strcpy( test0[BLOWFISH448],  "13e3571e703e89d0");
strcpy( test0[BLOWFISH256],  "1578265d02dfc08e");
strcpy( test0[BLOWFISH128],  "5f9a37dd02861966");
strcpy( test0[BLOWFISH192],  "03adb72e53e8cd4c");
strcpy ( test0[DES], "98050d1fb7c26cfb");
strcpy ( test0[TripleDES], "bb71f92d7d7596e2");
strcpy ( test0[ThreeWAY], "90aa52beaecb2cff6366c704");
strcpy ( test0[GOST], "13a0c2c9759296c9");
strcpy ( test0[SAFER64], "c58912f31ffb1c1c");
strcpy ( test0[SAFER128], "1ac9b79f2b199edc");
strcpy ( test0[CAST128], "6095d3717ccb603d");
strcpy ( test0[TEAN], "f26fd4dbed9b5479");
strcpy ( test0[TWOFISH128], "766cfb543adda812236f533edcc9a45b");
strcpy ( test0[RC2], "043846dcc342834d");
strcpy ( test0[TWOFISH192], "26243ee2c7b5afc986b0a67f74d3c624");
strcpy ( test0[TWOFISH256], "33e2193713e78406e1b2d8c2acedd8be");
strcpy ( test0[RC6], "70b4c1ba64f82057326e3aaee8aab116");
strcpy ( test0[IDEA], "35dda56ca4324a6f");
strcpy ( test0[CAST256], "64fa746577a791330a930261c16ed8e3");
strcpy ( test0[SAFERPLUS], "7cbb1fde935b155f325e2d839360a82c");
strcpy ( test0[LOKI97], "508634bd71741885ae6f6d210b678e97");


  for (i=0;i<=150;i++) {

   if (is_ok_algorithm(i)!=0) continue;

   password = malloc( mcrypt_get_key_size(i));
   keyword = malloc( mcrypt_get_key_size(i));
   memset( password, '\2', mcrypt_get_key_size(i));
   memset( password, '\3', mcrypt_get_key_size(i)/2);
   memset( password, '\5', mcrypt_get_key_size(i)/4);
   gen_key_sha1( keyword, NULL, 0, mcrypt_get_key_size(i), password, mcrypt_get_key_size(i));
   
   bzero(cipher_tmp, sizeof(cipher_tmp));
   td = mcrypt_generic_init( ECB, i, keyword, mcrypt_get_key_size(i), NULL);

//   if (td<0) {continue;}

   name=get_algorithms_name(i);
   if (name==NULL) continue;
   printf ("Algorithm: %s... ",name);

   ciphertext=malloc( mcrypt_get_block_size(i));
   plaintext=malloc( mcrypt_get_block_size(i));
   bzero( plaintext, mcrypt_get_block_size(i));
   memcpy(ciphertext,plaintext, get_block_size(i));

#ifdef DEBUG
   printf ("plaintext:  ");
   for (j=0; j<mcrypt_get_block_size(i); j++) {
     printf("%.2x", ciphertext[j]);
   }
#endif   

#ifdef DEBUG
   printf ("\nkeyword:    ");
   for (j=0; j< mcrypt_get_key_size(i); j++) {
     printf("%.2x", keyword[j]);
   }   
#endif

   mcrypt_generic( td, ciphertext, mcrypt_get_block_size(i));

#ifdef DEBUG
   printf ("\nciphertext: ");
#endif
   for (j=0; j<mcrypt_get_block_size(i); j++) {
     sprintf( &((char*)cipher_tmp)[2*j], "%.2x", ciphertext[j]);
   }

#ifdef DEBUG
   printf("%s\n", cipher_tmp);   
#endif

   if (strcmp( (void*) cipher_tmp, (void*) test0[i])!=0) {
        printf ("failed compatibility\n");
        x=1;
        continue;
   }

#ifdef DEBUG
   printf("\n");
#endif

   mdecrypt_generic( td, ciphertext, mcrypt_get_block_size(i));
   if (memcmp(ciphertext, plaintext, mcrypt_get_block_size(i))!=0) {
        printf ("failed internally\n");
        x=1;
        continue;
   }
   printf ("ok\n");
   
   mcrypt_generic_end(td);

   free(name);
   free(keyword);
   free(ciphertext);
   free(plaintext);
   free(password);
  }

return x;

}

