/*
 * Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <mcrypt_internal.h>
#include <xmemory.h>

#if 0
extern int preloaded_symbols;
#endif

WIN32DLL_DEFINE
int mcrypt_module_close(MCRYPT td)
{

	lt_dlclose(td->algorithm_handle);
	lt_dlclose(td->mode_handle);
	lt_dlexit();

	td->algorithm_handle = NULL;
	td->mode_handle = NULL;

	td->m_encrypt = NULL;
	td->a_encrypt = NULL;
	td->a_decrypt = NULL;
	td->m_decrypt = NULL;

	free(td);
	
	return 0;
}

#ifndef USE_LTDL
WIN32DLL_DEFINE
void *mcrypt_dlopen_ext ( const char *filename) {
	void *ret;
	char full_path[1054];

	if (strlen(filename)>sizeof(full_path)) return NULL;

	strcpy(full_path, filename);
	ret = dlopen(full_path, RTLD_LAZY);

	if (ret==NULL) {
#ifndef WIN32
		strcat(full_path, ".so");
#else
		strcat(full_path, ".dll");
#endif
		ret = dlopen(full_path, RTLD_LAZY);
	}
	return ret;

}
#endif

WIN32DLL_DEFINE
void *mcrypt_dlopen ( const char* a_directory, const char *m_directory, const char *filename) {
	void* ret=NULL;

#ifdef USE_LTDL
	char paths[1526];
	
	memset( paths, 0, 1024);
	if (a_directory != NULL) {
		strncat( paths, a_directory, 512);
		strcat( paths, ":");
	}
	if (m_directory != NULL) {
		strncat( paths, m_directory, 512);
		strcat( paths, ":");
	}
	strncat( paths, LIBDIR, 512);

	lt_dlsetsearchpath(paths);

	ret = lt_dlopenext(filename);

	return ret;

#else
	char full_path[1050];

	if (a_directory!=NULL) {
		strncpy(full_path, a_directory, 512);
		strcat(full_path, "/");
		strncat( full_path, filename, 512);
		ret = mcrypt_dlopen_ext(full_path);
	}
	if (ret==NULL) {
		if (m_directory!=NULL) {
			strncpy(full_path, m_directory, 512);
			strcat(full_path, "/");
			strncat( full_path, filename, 510);
			ret = mcrypt_dlopen_ext(full_path);
		}
	}
	if (ret==NULL) {
		if (LIBDIR!=NULL) {
			strncpy(full_path, LIBDIR, 512);
			strcat(full_path, "/");
			strncat( full_path, filename, 510);
			ret = mcrypt_dlopen_ext(full_path);
		}
	}
	return ret;
#endif

}

WIN32DLL_DEFINE
MCRYPT mcrypt_module_open(char *algorithm,
			  char *a_directory, char *mode, char *m_directory)
{
	MCRYPT td;
	const char* err;
	
	td = calloc(1, sizeof(CRYPT_STREAM));
	if (td==NULL) return MCRYPT_FAILED;

	if (lt_dlinit() != 0) {
		return MCRYPT_FAILED;
	}

/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	td->algorithm_handle = mcrypt_dlopen(a_directory, m_directory, algorithm);
	if (td->algorithm_handle == NULL) {
		err=lt_dlerror();
		if (err!=NULL) fputs( err, stderr);
		fputs("\n", stderr);
		return MCRYPT_FAILED;
	}

	td->mode_handle = mcrypt_dlopen(a_directory, m_directory, mode);

	if (td->mode_handle == NULL) {
		err=lt_dlerror();
		if (err!=NULL) fputs( err, stderr);
		lt_dlclose(td->algorithm_handle);
		return MCRYPT_FAILED;
	}

	td->a_encrypt = lt_dlsym(td->algorithm_handle, "_mcrypt_encrypt");
	td->a_decrypt = lt_dlsym(td->algorithm_handle, "_mcrypt_decrypt");
	td->m_encrypt = lt_dlsym(td->mode_handle, "_mcrypt");
	td->m_decrypt = lt_dlsym(td->mode_handle, "_mdecrypt");
	td->a_block_size =
	    lt_dlsym(td->algorithm_handle, "_mcrypt_get_block_size");

	if (mcrypt_enc_is_block_algorithm_mode(td) !=
	    mcrypt_enc_is_block_algorithm(td)) {
		mcrypt_module_close(td);
		return MCRYPT_FAILED;
	}

	return td;
}



/* Modules' frontends */

WIN32DLL_DEFINE
int mcrypt_get_size(MCRYPT td)
{
	int (*_mcrypt_get_size) (void);

	const char *error;
	char *s;

	s = td->algorithm_handle;
	_mcrypt_get_size = lt_dlsym(s, "_mcrypt_get_size");
	if ((error = lt_dlerror())) {
		if (error!=NULL) fputs(error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}
	return _mcrypt_get_size();
}

WIN32DLL_DEFINE
int mcrypt_mode_get_size(MCRYPT td)
{
	int (*_mcrypt_get_size) (void);

	const char *error;
	char *s;

	s = td->mode_handle;
	_mcrypt_get_size = lt_dlsym(s, "_mcrypt_mode_get_size");
	if ((error = lt_dlerror())) {
		if (error!=NULL) fputs(error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}
	return _mcrypt_get_size();
}

WIN32DLL_DEFINE
int mcrypt_set_key(MCRYPT td, void *a, void *b, int c, void *d, int e)
{
	int (*__mcrypt_set_key_stream) (void *, void *, int, void *, int);
	int (*__mcrypt_set_key_block) (void *, void *, int);
	const char *error;
	char *s;

	s = td->algorithm_handle;
	if (mcrypt_enc_is_block_algorithm(td) == 0) {
		/* stream */
		__mcrypt_set_key_stream = lt_dlsym(s, "_mcrypt_set_key");
		if ((error = lt_dlerror())) {
			if (error!=NULL) fputs(error, stderr);
			fputs("\n", stderr);
			return -2;
		}
		return __mcrypt_set_key_stream(a, b, c, d, e);
	} else {
		__mcrypt_set_key_block = lt_dlsym(s, "_mcrypt_set_key");
		if ((error = lt_dlerror())) {
			if (error!=NULL) fputs(error, stderr);
			fputs("\n", stderr);
			return -2;
		}
		return __mcrypt_set_key_block(a, b, c);
	}
}

WIN32DLL_DEFINE
int mcrypt_enc_set_state(MCRYPT td, void *iv, int size)
{
	int (*__mcrypt_set_state) (void *, void *, int);
	const char *error;
	char *s;

	s = td->mode_handle;

	__mcrypt_set_state = lt_dlsym(s, "_mcrypt_set_state");
	if ((error = lt_dlerror())) {
		if (error!=NULL) fputs(error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}
	return __mcrypt_set_state(td->abuf, iv, size);
}

WIN32DLL_DEFINE
int mcrypt_enc_get_block_size(MCRYPT td)
{
	int (*_mcrypt_get_block_size) (void);

	_mcrypt_get_block_size = td->a_block_size;
	return _mcrypt_get_block_size();
}

WIN32DLL_DEFINE
int mcrypt_get_algo_iv_size(MCRYPT td)
{
	int (*_mcrypt_get_algo_iv_size) (void);
	char *s;

	s = td->algorithm_handle;

	_mcrypt_get_algo_iv_size = lt_dlsym(s, "_mcrypt_get_algo_iv_size");
	return _mcrypt_get_algo_iv_size();
}

WIN32DLL_DEFINE
int mcrypt_enc_get_iv_size(MCRYPT td)
{
	if (mcrypt_enc_is_block_algorithm_mode(td) == 1) {
		return mcrypt_enc_get_block_size(td);
	} else {
		return mcrypt_get_algo_iv_size(td);
	}
}

WIN32DLL_DEFINE
int mcrypt_enc_get_key_size(MCRYPT td)
{
	int (*_mcrypt_get_key_size) (void);
	char *s;

	s = td->algorithm_handle;

	_mcrypt_get_key_size = lt_dlsym(s, "_mcrypt_get_key_size");
	return _mcrypt_get_key_size();
}

WIN32DLL_DEFINE
int *mcrypt_enc_get_supported_key_sizes(MCRYPT td, int *len)
{
	int *(*_mcrypt_get_key_sizes) (int *);
	char *s;
	int *size;

	s = td->algorithm_handle;

	_mcrypt_get_key_sizes =
	    lt_dlsym(s, "_mcrypt_get_supported_key_sizes");
	size = _mcrypt_get_key_sizes(len);

	return size;
}

WIN32DLL_DEFINE
int mcrypt_enc_is_block_algorithm(MCRYPT td)
{
	int (*_is_block_algorithm) (void);
	char *s;

	s = td->algorithm_handle;

	_is_block_algorithm = lt_dlsym(s, "_is_block_algorithm");
	return _is_block_algorithm();
}

WIN32DLL_DEFINE
char *mcrypt_enc_get_algorithms_name(MCRYPT td)
{
	char *(*_mcrypt_get_algorithms_name) (void);
	char *s;

	s = td->algorithm_handle;

	_mcrypt_get_algorithms_name =
	    lt_dlsym(s, "_mcrypt_get_algorithms_name");
	return _mcrypt_get_algorithms_name();
}

WIN32DLL_DEFINE
int init_mcrypt(MCRYPT td, void *buf, void *a, int b, void *c)
{
	int (*_init_mcrypt) (void *, void *, int, void *, int);
	char *s;

	s = td->mode_handle;
	_init_mcrypt = lt_dlsym(s, "_init_mcrypt");
	return _init_mcrypt(buf, a, b, c, mcrypt_enc_get_block_size(td));
}

WIN32DLL_DEFINE
int end_mcrypt(MCRYPT td, void *buf)
{
	int (*_end_mcrypt) (void *);
	char *s;

	s = td->mode_handle;
	_end_mcrypt = lt_dlsym(s, "_end_mcrypt");
	return _end_mcrypt(buf);
}

WIN32DLL_DEFINE
int mcrypt(MCRYPT td, void *buf, void *a, int b)
{
	int (*_mcrypt) (void *, void *, int, int, void *, void *, void*);
	_mcrypt = td->m_encrypt;

	return _mcrypt(buf, a, b, mcrypt_enc_get_block_size(td), td->akey,
		       td->a_encrypt, td->a_decrypt);
}

WIN32DLL_DEFINE
int mdecrypt(MCRYPT td, void *buf, void *a, int b)
{
	int (*_mdecrypt) (void *, void *, int, int, void *, void *, void*);

	_mdecrypt = td->m_decrypt;
	return _mdecrypt(buf, a, b, mcrypt_enc_get_block_size(td),
			 td->akey, td->a_encrypt, td->a_decrypt);
}

WIN32DLL_DEFINE
char *mcrypt_enc_get_modes_name(MCRYPT td)
{
	char *(*_mcrypt_get_modes_name) (void);
	char *s;

	s = td->mode_handle;

	_mcrypt_get_modes_name = lt_dlsym(s, "_mcrypt_get_modes_name");
	return _mcrypt_get_modes_name();
}

WIN32DLL_DEFINE
int mcrypt_enc_is_block_mode(MCRYPT td)
{
	int (*_is_block_mode) (void);
	char *s;

	s = td->mode_handle;

	_is_block_mode = lt_dlsym(s, "_is_block_mode");
	return _is_block_mode();
}

WIN32DLL_DEFINE
int mcrypt_enc_mode_has_iv(MCRYPT td)
{
	int (*_has_iv) (void);
	char *s;

	s = td->mode_handle;

	_has_iv = lt_dlsym(s, "_has_iv");
	return _has_iv();
}

WIN32DLL_DEFINE
int mcrypt_enc_is_block_algorithm_mode(MCRYPT td)
{
	int (*_is_a_block_mode) (void);
	char *s;

	s = td->mode_handle;

	_is_a_block_mode = lt_dlsym(s, "_is_block_algorithm_mode");
	return _is_a_block_mode();
}

WIN32DLL_DEFINE
int mcrypt_enc_self_test(MCRYPT td)
{
	int (*_self_test) (void);
	char *s;

	s = td->algorithm_handle;

	_self_test = lt_dlsym(s, "_mcrypt_self_test");

	return _self_test();
}

WIN32DLL_DEFINE
int mcrypt_module_self_test(char *algorithm, char *a_directory)
{
	int i;
	lt_dlhandle *_handle;
	int (*_self_test) (void);
	const char* error;


	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);

	if (!_handle) {
		error=lt_dlerror();
		if (error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_self_test = lt_dlsym(_handle, "_mcrypt_self_test");

	i = _self_test();

	lt_dlclose(_handle);
	lt_dlexit();
	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_algorithm_version(char *algorithm, char *a_directory)
{
	int i;
	lt_dlhandle _handle;
	int (*_version) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);
	if (!_handle) {
		error=lt_dlerror();
		if (error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_version = lt_dlsym(_handle, "_mcrypt_algorithm_version");

	i = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_mode_version(char *mode, char *m_directory)
{
	int i;
	lt_dlhandle *_handle;
	int (*_version) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(m_directory, NULL, mode);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs(error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_version = lt_dlsym(_handle, "_mcrypt_mode_version");

	i = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_is_block_algorithm(char *algorithm, char *a_directory)
{
	int i;
	lt_dlhandle _handle;
	int (*_is_block_algorithm) (void);
	const char* error;
	
	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);
	
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_is_block_algorithm = lt_dlsym(_handle, "_is_block_algorithm");

	i = _is_block_algorithm();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_is_block_algorithm_mode(char *mode, char *m_directory)
{
	int i;
	lt_dlhandle *_handle;
	int (*_is_a_block_mode) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(m_directory, NULL, mode);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_is_a_block_mode = lt_dlsym(_handle, "_is_block_algorithm_mode");

	i = _is_a_block_mode();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_is_block_mode(char *mode, char *m_directory)
{
	int i;
	lt_dlhandle *_handle;
	int (*_is_block_mode) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(m_directory, NULL, mode);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_is_block_mode = lt_dlsym(_handle, "_is_block_mode");

	i = _is_block_mode();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_get_algo_block_size(char *algorithm, char *a_directory)
{
	int i;
	lt_dlhandle _handle;
	int (*_get_block_size) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_get_block_size = lt_dlsym(_handle, "_mcrypt_get_block_size");

	i = _get_block_size();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int mcrypt_module_get_algo_key_size(char *algorithm, char *a_directory)
{
	int i;
	lt_dlhandle _handle;
	int (*_get_key_size) (void);
	const char* error;

	if (lt_dlinit() != 0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		return MCRYPT_UNKNOWN_ERROR;
	}

	_get_key_size = lt_dlsym(_handle, "_mcrypt_get_key_size");

	i = _get_key_size();

	lt_dlclose(_handle);
	lt_dlexit();

	return i;
}

WIN32DLL_DEFINE
int *mcrypt_module_get_algo_supported_key_sizes(char *algorithm,
						char *a_directory,
						int *len)
{
	lt_dlhandle _handle;
	int *(*_mcrypt_get_key_sizes) (int *);
	int *size;
	const char* error;

	if (lt_dlinit() != 0) {
		*len = 0;
		return NULL;
	}
/*	LTDL_SET_PRELOADED_SYMBOLS(); */

	_handle = mcrypt_dlopen(a_directory, NULL, algorithm);
	if (!_handle) {
		error=lt_dlerror();
		if(error!=NULL) fputs( error, stderr);
		fputs("\n", stderr);
		*len = 0;
		return NULL;
	}

	_mcrypt_get_key_sizes =
	    lt_dlsym(_handle, "_mcrypt_get_supported_key_sizes");

	size = _mcrypt_get_key_sizes(len);

	lt_dlclose(_handle);
	lt_dlexit();

	return size;
}
