/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos This library is free
 * software; you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt_extra.c,v 1.12 2000/03/31 03:13:17 nikos Exp $ */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <xmemory.h>
#include <mcrypt_internal.h>

#if 0
extern int preloaded_symbols;
#endif 

int mcrypt_algorithm_module_ok(const char *file, const char* directory);
int mcrypt_mode_module_ok(const char *file, const char* directory);

char ** mcrypt_list_algorithms(char *libdir, int *size)
{
	DIR *pdir;
	char directory[500];
	struct dirent *dirname;
	char **filename = NULL, *ptr;
	int tmpsize;

	*size = 0;

	if (libdir == NULL) {
		strcpy(directory, LIBDIR);
	} else {
		strcpy(directory, libdir);
	}

#if 0
	if (preloaded_symbols!=0) { /* We have preloaded symbols */
		i=0;
		for (;;) {
			if (mcrypt_algorithm_module_ok(lt_preloaded_symbols[i].name, NULL) > 0 ) {
					tmpsize=strlen(lt_preloaded_symbols[i].name);
					filename =
					    realloc(filename,
						    (*size +
						     1) *
						    sizeof(char*));
					filename[*size] =
					    calloc(1, tmpsize + 1);
					strcpy(filename[*size],
					       lt_preloaded_symbols[i].name);
					ptr=strrchr(filename[*size], '.');
					if (ptr!=NULL) *ptr='\0';
					(*size)++;
			}
			if (lt_preloaded_symbols[i].address==0 && lt_preloaded_symbols[i].name==NULL) break;
			i++;
		}
	}
#endif

	pdir = opendir(directory);
	if (pdir == NULL) {
		fprintf(stderr, "Unable to open directory %s.\n",
			directory);
		return NULL;
	}

	for (;;) {
		dirname = readdir(pdir);
		if (dirname != NULL) {
#ifdef DT_REG
			if ((dirname->d_type == DT_REG)
			    || (dirname->d_type == DT_UNKNOWN)) {
#endif
				if (strlen(dirname->d_name) > 3) {
					tmpsize = strlen(dirname->d_name);

					if (mcrypt_algorithm_module_ok(dirname->d_name, directory) > 0 ) {
						filename =
						    realloc(filename,
							    (*size +
							     1) *
							    sizeof(char
								   *));
						filename[*size] =
						    calloc(1, tmpsize + 1);
						strcpy(filename[*size],
						       dirname->d_name);

						ptr=strrchr(filename[*size], '.');
						if (ptr!=NULL) *ptr='\0';
						(*size)++;
					}
				}
#ifdef DT_REG
			}
#endif
		} else {
			break;
		}

	}



	closedir(pdir);
	
	return filename;

}

char **  mcrypt_list_modes(char *libdir, int *size)
{
	DIR *pdir;
	char directory[500];
	struct dirent *dirname;
	char **filename = NULL, *ptr;
	int tmpsize;

	if (libdir == NULL) {
		strcpy(directory, LIBDIR);
	} else {
		strcpy(directory, libdir);
	}

	lt_dladdsearchdir(directory);

#if 0
	if (preloaded_symbols!=0) { /* We have preloaded symbols */
		i=0;
		for (;;) {
			if (mcrypt_mode_module_ok(lt_preloaded_symbols[i].name, NULL) > 0 ) {
					tmpsize=strlen(lt_preloaded_symbols[i].name);
					filename =
					    realloc(filename,
						    (*size +
						     1) *
						    sizeof(char*));
					filename[*size] =
					    calloc(1, tmpsize + 1);
					strcpy(filename[*size],
					       lt_preloaded_symbols[i].name);
					ptr=strrchr(filename[*size], '.');
					if (ptr!=NULL) *ptr='\0';
					(*size)++;
			}
			if (lt_preloaded_symbols[i].address==0 && lt_preloaded_symbols[i].name==NULL) break;
			i++;
		}
	}
#endif 

	pdir = opendir(directory);
	if (pdir == NULL) {
		fprintf(stderr, "Unable to open directory %s.\n",
			directory);
		return NULL;
	}

	*size = 0;
	for (;;) {

		dirname = readdir(pdir);
		if (dirname != NULL) {
#ifdef DT_REG
			if ((dirname->d_type == DT_REG)
			    || (dirname->d_type == DT_UNKNOWN)) {
#endif
				if (strlen(dirname->d_name) > 3) {
					tmpsize = strlen(dirname->d_name);
					if ( mcrypt_mode_module_ok(dirname->d_name, directory) > 0 ) {
						filename =
						    realloc(filename,
							    (*size +
							     1) *
							    sizeof(char
								   *));
						filename[*size] =
						    calloc(1, tmpsize + 1);
						strcpy(filename[*size],
						       dirname->d_name);
						ptr=strrchr(filename[*size], '.');
						if (ptr!=NULL) *ptr='\0';
						(*size)++;
					}
				}
#ifdef DT_REG
			}
#endif
		} else {
			break;
		}

	}

	closedir(pdir);
	return filename;
}


void  mcrypt_free_p(char** p, int size) {
int i;

	for (i=0;i<size;i++) {
		free(p[i]);
	}
	free(p);
}

int  mcrypt_algorithm_module_ok(const char *file, const char* directory)
{
	int i;
	word32 ret;
	lt_dlhandle *_handle;
	int (*_version) (void);

	if (file == NULL && directory==NULL) {
		return MCRYPT_UNKNOWN_ERROR;
	}

	if (lt_dlinit()!=0) {
		return MCRYPT_UNKNOWN_ERROR;
	}
	
	i=lt_dladdsearchdir(directory);

/*	LTDL_SET_PRELOADED_SYMBOLS(); */
	_handle = lt_dlopenext(file);
	if (!_handle) {
		_handle = lt_dlopen(file);
	}
	
	

	if (_handle==NULL) {
/*		fputs(lt_dlerror(), stderr);
 *		fputs("\n", stderr);
 */
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}


	_version = lt_dlsym(_handle, "_mcrypt_algorithm_version");

	if (_version==NULL) { 
		lt_dlclose(_handle);
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}

	ret = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return ret;

}

int  mcrypt_mode_module_ok(const char *file, const char* directory)
{
	int i;
	word32 ret;
	lt_dlhandle *_handle;
	int (*_version) (void);

	if (file == NULL && directory==NULL) {
		return MCRYPT_UNKNOWN_ERROR;
	}

	if (lt_dlinit()!=0) {
		return MCRYPT_UNKNOWN_ERROR;
	}	
/*	LTDL_SET_PRELOADED_SYMBOLS(); */
	i=lt_dladdsearchdir(directory);	
	
	_handle = lt_dlopenext(file);
	if (!_handle) {
		_handle = lt_dlopen(file);
	}
	
	if (!_handle) {
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}
	

	_version = lt_dlsym(_handle, "_mcrypt_mode_version");

	if (_version==NULL) {
		lt_dlclose(_handle);
		lt_dlexit();
		return MCRYPT_UNKNOWN_ERROR;
	}
	
	ret = _version();

	lt_dlclose(_handle);
	lt_dlexit();

	return ret;

}
#if 0
char **  mcrypt_list_algorithms(char *libdir, int *size)
{

	char **filename;
	int i;
	
	*size = 21;
	
	filename = malloc( (*size)*sizeof(char*));

	for (i=0; i<*size; i++) {
		filename[i]=malloc(strlen(algos[i])+1);
		strcpy(filename[i], algos[i]);
	}

	return filename;

}

char **  mcrypt_list_modes(char *libdir, int *size)
{
	char modes[6][64] = { "stream", "ecb", "cbc", "cfb", "ofb",
		"nofb" };
	char **filename;
	int i;
	
	*size = 6;
	
	filename = malloc( (*size)*sizeof(char*));

	for (i=0; i<*size; i++) {
		filename[i]=malloc(strlen(modes[i])+1);
		strcpy(filename[i], modes[i]);
	}

	return filename;
}


void   mcrypt_free_p(char** p, int size) {
int i;

	for (i=0;i<size;i++) {
		free(p[i]);
	}
	free(p);
}

int  mcrypt_algorithm_module_ok(char *file, char* directory)
{
	return algo_name2num(file);
}

int  mcrypt_mode_module_ok(char *file, char* directory)
{
	return mode_name2num(file);
}

#endif
