#include "../../lib/libdefs.h"
#include "../../lib/mcrypt_modules.h"

#define _init_mcrypt cbc_LTX__init_mcrypt
#define _end_mcrypt cbc_LTX__end_mcrypt
#define _mcrypt cbc_LTX__mcrypt
#define _mdecrypt cbc_LTX__mdecrypt
#define _has_iv cbc_LTX__has_iv
#define _is_block_mode cbc_LTX__is_block_mode
#define _is_block_algorithm_mode cbc_LTX__is_block_algorithm_mode
#define _mcrypt_get_modes_name cbc_LTX__mcrypt_get_modes_name
#define _mcrypt_mode_get_size cbc_LTX__mcrypt_mode_get_size
#define _mcrypt_mode_version cbc_LTX__mcrypt_mode_version

typedef struct cbc_buf {
	word32 *previous_ciphertext;
	word32 *previous_plaintext;
	word32 *previous_cipher;
} CBC_BUFFER;

/* CBC MODE */


int _init_mcrypt( CBC_BUFFER* buf,void *key, int lenofkey, void *IV, int size)
{
/* For cbc */

	buf->previous_ciphertext = malloc( size);
	buf->previous_plaintext = malloc( size);
	buf->previous_cipher = malloc( size);
	memmove(buf->previous_ciphertext, IV, size);
	memmove(buf->previous_plaintext, IV, size);

	return 0;
}

void _end_mcrypt( CBC_BUFFER* buf) {
	free(buf->previous_ciphertext);
	free(buf->previous_plaintext);
	free(buf->previous_cipher);
}

int _mcrypt( CBC_BUFFER* buf, void *plaintext, int len, int blocksize, void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{
	word32 *fplain = plaintext;
	word32 *plain;
	int i, j; 
	void (*_mcrypt_block_encrypt) (void *, void *);

	_mcrypt_block_encrypt = func;
	
	for (j = 0; j < len / blocksize; j++) {

		plain = &fplain[j * blocksize / sizeof(word32)];

		for (i = 0; i < blocksize / sizeof(word32); i++) {
			plain[i] ^= buf->previous_ciphertext[i];
		}

		_mcrypt_block_encrypt(akey, plain);

		/* Copy the ciphertext to prev_ciphertext */
		memmove(buf->previous_ciphertext, plain, blocksize);
	}

	return 0;
}



int _mdecrypt( CBC_BUFFER* buf, void *ciphertext, int len, int blocksize,void* akey, void (*func)(void*,void*), void (*func2)(void*,void*))
{
	word32 *cipher;
	word32 *fcipher = ciphertext;
	int i, j; 
	void (*_mcrypt_block_decrypt) (void *, void *);

	_mcrypt_block_decrypt = func2;


	for (j = 0; j < len / blocksize; j++) {

		cipher = &fcipher[j * blocksize / sizeof(word32)];
		memmove(buf->previous_cipher, cipher, blocksize);

		_mcrypt_block_decrypt(akey, cipher);
		for (i = 0; i < blocksize / sizeof(word32); i++) {
			cipher[i] ^= buf->previous_plaintext[i];
		}

		/* Copy the ciphertext to prev_cipher */
		memmove(buf->previous_plaintext, buf->previous_cipher, blocksize);

	}

	return 0;
}

int _has_iv() { return 1; }
int _is_block_mode() { return 1; }
int _is_block_algorithm_mode() { return 1; }
char *_mcrypt_get_modes_name() { char*x; x=malloc(10); strcpy(x, "CBC"); return x;}
int _mcrypt_mode_get_size () {return sizeof(CBC_BUFFER);}

word32 _mcrypt_mode_version() {
	return 20000331;
}

