/*
 *    "enigma.c" is in file cbw.tar from
 *      anonymous FTP host watmsg.waterloo.edu: pub/crypt/cbw.tar.Z
 *
 *      A one-rotor machine designed along the lines of Enigma
 *      but considerably trivialized.
 *
 *      A public-domain replacement for the UNIX "crypt" command.
 *      Changed to fit in mcrypt by nmav@i-net.paiko.gr
 */

/* modified in order to use the libmcrypt API by Nikos Mavroyanopoulos 
 * All modifications are placed under the license of libmcrypt.
 */

/* $Id: enigma.c,v 1.1.1.1 2000/05/22 13:09:15 nmav Exp $ */

#include "libdefs.h"
#include "bzero.h"
#include "enigma.h"

/* it needs to be linked against libufc or libcrypt */
/* it no longer needs that. It just needs the password to be
 * transformed by unix crypt() or the mhash SCRYPT 
 */

void _mcrypt_enigma_set_key(CRYPT_KEY *ckey, char* password, int plen)
{
	int ic, i, k, temp;
	unsigned random;
	sword32 seed;


	Bzero(ckey, sizeof(CRYPT_KEY));
	ckey->n1 = ckey->n2 = ckey->nr1 = ckey->nr2 = 0;

	if (plen > 13) plen = 13;
	memmove( ckey->cbuf, password, plen);
	
	seed = 123;
	for (i = 0; i < 13; i++)
		seed = seed * ckey->cbuf[i] + i;
	for (i = 0; i < ROTORSZ; i++) {
		ckey->t1[i] = i;
		ckey->deck[i] = i;
	}
	for (i = 0; i < ROTORSZ; i++) {
		seed = 5 * seed + ckey->cbuf[i % 13];
		random = seed % 65521;
		k = ROTORSZ - 1 - i;
		ic = (random & MASK) % (k + 1);
		random >>= 8;

		temp = ckey->t1[k];
		ckey->t1[k] = ckey->t1[ic];
		ckey->t1[ic] = temp;
		if (ckey->t3[k] != 0)
			continue;

		ic = (random & MASK) % k;
		while (ckey->t3[ic] != 0)
			ic = (ic + 1) % k;
		ckey->t3[k] = ic;
		ckey->t3[ic] = k;
	}

	for (i = 0; i < ROTORSZ; i++)
		ckey->t2[ckey->t1[i] & MASK] = i;

	return;
}


int shuffle(CRYPT_KEY* ckey)
{
	int i, ic, k, temp;
	unsigned random;
	static sword32 seed = 123;

	for (i = 0; i < ROTORSZ; i++) {
		seed = 5 * seed + ckey->cbuf[i % 13];
		random = seed % 65521;
		k = ROTORSZ - 1 - i;
		ic = (random & MASK) % (k + 1);
		temp = ckey->deck[k];
		ckey->deck[k] = ckey->deck[ic];
		ckey->deck[ic] = temp;
	}
	return 0;
}

void _mcrypt_enigma_encrypt(CRYPT_KEY *ckey, void *gtext, int textlen)
{				/* 0 or 1 */
	int i, j;
	int secureflg=0;
	char *text = gtext;

	for (j = 0; j < textlen; j++) {

		i = text[j];
		if (secureflg) {
			ckey->nr1 = ckey->deck[ckey->n1] & MASK;
			ckey->nr2 = ckey->deck[ckey->nr1] & MASK;
		} else {
			ckey->nr1 = ckey->n1;
		}
		i = ckey->t2[(ckey->t3[(ckey->t1[(i + ckey->nr1) & MASK] + ckey->nr2) & MASK] - ckey->nr2) & MASK] - ckey->nr1;
		text[j] = i;
		ckey->n1++;
		if (ckey->n1 == ROTORSZ) {
			ckey->n1 = 0;
			ckey->n2++;
			if (ckey->n2 == ROTORSZ)
				ckey->n2 = 0;
			if (secureflg) {
				shuffle(ckey);
			} else {
				ckey->nr2 = ckey->n2;
			}
		}
	}

	return;
}

void _mcrypt_enigma_decrypt(CRYPT_KEY *ckey, void *gtext, int textlen)
{				/* 0 or 1 */
	int i, j;
	int secureflg=0;
	char *text = gtext;


	for (j = 0; j < textlen; j++) {

		i = text[j];
		if (secureflg) {
			ckey->nr1 = ckey->deck[ckey->n1] & MASK;
			ckey->nr2 = ckey->deck[ckey->nr1] & MASK;
		} else {
			ckey->nr1 = ckey->n1;
		}
		i = ckey->t2[(ckey->t3[(ckey->t1[(i + ckey->nr1) & MASK] + ckey->nr2) & MASK] - ckey->nr2) & MASK] - ckey->nr1;
		text[j] = i;
		ckey->n1++;
		if (ckey->n1 == ROTORSZ) {
			ckey->n1 = 0;
			ckey->n2++;
			if (ckey->n2 == ROTORSZ)
				ckey->n2 = 0;
			if (secureflg) {
				shuffle(ckey);
			} else {
				ckey->nr2 = ckey->n2;
			}
		}
	}

	return;
}

