/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 * Encryption/decryption library. This library is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt-nm.h,v 1.1.1.1 2000/05/22 13:09:15 nmav Exp $ */

#define MCRYPT_API_VERSION 19991115

#ifdef __cplusplus
extern "C" {
#endif
 
#define MCRYPT_FAILED 0x0
	struct MCRYPT_INT;
	typedef struct MCRYPT_INT* MCRYPT;
 
#define MCRYPT_BLOWFISH 0
#define MCRYPT_DES 1
#define MCRYPT_TRIPLEDES 2
#define MCRYPT_THREEWAY 3
#define MCRYPT_GOST 4
#define MCRYPT_SAFER_SK64 6
#define MCRYPT_SAFER_SK128 7
#define MCRYPT_CAST_128 8
#define MCRYPT_XTEA 9
#define MCRYPT_RC2 11
#define MCRYPT_TWOFISH 13
#define MCRYPT_CAST_256 17
#define MCRYPT_SAFERPLUS 18
#define MCRYPT_LOKI97 19
#define MCRYPT_SERPENT 22
#define MCRYPT_RIJNDAEL_128 25
#define MCRYPT_RC4 MCRYPT_ARCFOUR
#define MCRYPT_ARCFOUR 104
#define MCRYPT_ENIGMA 107

#define MCRYPT_CBC 0
#define MCRYPT_ECB 1
#define MCRYPT_CFB 2
#define MCRYPT_OFB 3
#define MCRYPT_nOFB 4
#define MCRYPT_STREAM 5

typedef struct mcrypt_algorithm_entry mcrypt_algorithm_entry;
typedef struct mcrypt_mode_entry mcrypt_mode_entry;

#define end_mcrypt_ecb end_mcrypt
#define end_mcrypt_stream end_mcrypt

/* generic - high level functions. These are a bit slower because
 * they perform a switch before each call but they have the advantage
 * of being able to check at run-time which modes are in the library
 * and use them
 */

MCRYPT mcrypt_generic_init(const int mode,
                    const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_generic_end(const MCRYPT td);
int mdecrypt_generic(MCRYPT td, void *plaintext, int len);
int mcrypt_generic(MCRYPT td, void *plaintext, int len);
void mcrypt_generic_term();

/* extra functions */

int mcrypt_get_block_size(int algorithm);
int mcrypt_get_key_size(int algorithm);

int mcrypt_is_ok_algorithm(int algorithm); /* if this algorithm exists returns 0 */
int mcrypt_is_ok_mode(int mode); /* if this mode exists returns 0 */
int mcrypt_is_block_algorithm(int algorithm); /* If this is a block algorithm returns 1 */
int mcrypt_is_block_algorithm_mode(int mode);
int mcrypt_mode_has_iv(int mode);

char* mcrypt_get_algorithms_name(int algorithm);
char *mcrypt_get_modes_name(int mode);


/* Functions used internally and in mcrypt (the program) */
MCRYPT init_mcrypt ( const int mode, const int algorithm, void * key, int lenofkey);
int mcrypt(MCRYPT td, void *plaintext);
int mdecrypt(MCRYPT td, void *plaintext);
int end_mcrypt(MCRYPT td);

/* ECB */
MCRYPT init_mcrypt_ecb( const int algorithm, void * key, int lenofkey);
int mcrypt_ecb(MCRYPT td, void *plaintext,int len);
int mdecrypt_ecb(MCRYPT td, void *plaintext, int);

/* CBC */
int end_mcrypt_cbc(MCRYPT td);
int mcrypt_cbc(MCRYPT td, void *plaintext, int);
int mdecrypt_cbc(MCRYPT td, void *ciphertext, int);
MCRYPT init_mcrypt_cbc( const int algorithm, void * key, int lenofkey);
MCRYPT init_mcrypt_cbc_iv( const int algorithm, void * key, int lenofkey, void *IV);

/* CFB */
int end_mcrypt_cfb(MCRYPT td);
int mcrypt_cfb(MCRYPT td, void *plaintext,int len);
int mdecrypt_cfb(MCRYPT td, void *ciphertext, int len);
MCRYPT init_mcrypt_cfb( const int algorithm, void * key, int lenofkey, void *IV);

/* OFB */
int end_mcrypt_ofb(MCRYPT td);
int mcrypt_ofb(MCRYPT td, void *plaintext,int len);
int mdecrypt_ofb(MCRYPT td, void *ciphertext, int len);
MCRYPT init_mcrypt_ofb( const int algorithm, void * key, int lenofkey, void *IV);

/* nbit OFB */
MCRYPT init_mcrypt_nofb(const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_nofb(MCRYPT td, void *plaintext, int len);
int mdecrypt_nofb(MCRYPT td, void *plaintext, int len);
int end_mcrypt_nofb(MCRYPT td);

/* STREAM */
MCRYPT init_mcrypt_stream(const int algorithm, void *key, int lenofkey);
int mcrypt_stream(MCRYPT td, void *plaintext, int len);
int mdecrypt_stream(MCRYPT td, void *ciphertext, int len);

#ifdef __cplusplus
}
#endif
