/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos This library is free
 * software; you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt_extra.c,v 1.1.1.1 2000/05/22 13:08:59 nmav Exp $ */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <swap.h>
#include <mcrypt_int.h>
#include <blowfish.h>
#include <3-way.h>
#include <des.h>
#include <safer.h>
#include <tean.h>
#include <xmemory.h>
#include <rc2.h>
#include <loki97.h>
#include <rijndael.h>
#include <ctype.h>

#define MCRYPT_ENTRY(name, blksize, keysize, block) \
        { #name, name, blksize, keysize, block }

struct mcrypt_algorithm_entry {
	char *name;
	int id;
	size_t blocksize;
	size_t keysize;
	int block;
};

static mcrypt_algorithm_entry algorithms[] = {
	MCRYPT_ENTRY(MCRYPT_BLOWFISH, 8, 56, 1),
	MCRYPT_ENTRY(MCRYPT_DES, 8, 8, 1),
	MCRYPT_ENTRY(MCRYPT_TRIPLEDES, 8, 24, 1),
	MCRYPT_ENTRY(MCRYPT_THREEWAY, 12, 12, 1),
	MCRYPT_ENTRY(MCRYPT_GOST, 8, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SAFER_SK64, 8, 8, 1),
	MCRYPT_ENTRY(MCRYPT_SAFER_SK128, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_CAST_128, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_XTEA, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_RC2, 8, 128, 1),
	MCRYPT_ENTRY(MCRYPT_TWOFISH, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_CAST_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SAFERPLUS, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_LOKI97, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SERPENT, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_RIJNDAEL_128, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_ARCFOUR, 1, 256, 0),
	MCRYPT_ENTRY(MCRYPT_ENIGMA, 1, 13, 0),
	{0}
};

void tolow( char* str, int size) {
int i;

	for(i=0;i<size;i++) {
		str[i]=tolower(str[i]);
	}
}

#define MCRYPT_LOOP(b) \
        mcrypt_algorithm_entry *p; \
                for(p = algorithms; p->name != NULL; p++) { b ; }

#define MCRYPT_ALG_LOOP(a) \
                        MCRYPT_LOOP( if(p->id == algorithm) { a; break; } )


#define MCRYPT_MODE_ENTRY(name, block_algo, IV, block) \
        { #name, name, block_algo, IV, block }

struct mcrypt_mode_entry {
	char *name;
	int id;
	int block_algo;
	int IV;
	int block;
};

static mcrypt_mode_entry modes[] = {
	MCRYPT_MODE_ENTRY(MCRYPT_ECB, 1, 0, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_CBC, 1, 1, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_CFB, 1, 1, 0),
	MCRYPT_MODE_ENTRY(MCRYPT_OFB, 1, 1, 0),
	MCRYPT_MODE_ENTRY(MCRYPT_nOFB, 1, 1, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_STREAM, 0, 0, 0),
	{0}
};


#define MCRYPT_MODE_LOOP(b) \
        mcrypt_mode_entry *p; \
                for(p = modes; p->name != NULL; p++) { b ; }

#define MCRYPT_MLOOP(a) \
                        MCRYPT_MODE_LOOP( if(p->id == mode) { a; break; } )


int mcrypt_mode_has_iv(int mode)
{
	int ret = 0;

	MCRYPT_MLOOP(ret = p->IV);
	return ret;

}




int mcrypt_get_block_size(int algorithm)
{
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->blocksize);
	return ret;

}

int mcrypt_is_block_algorithm(int algorithm)
{
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->block);
	return ret;

}

int mcrypt_is_block_algorithm_mode(int mode)
{
	int ret = 0;

	MCRYPT_MLOOP(ret = p->block_algo);
	return ret;

}

int mcrypt_is_block_mode(int mode)
{
	int ret = 0;

	MCRYPT_MLOOP(ret = p->block);
	return ret;

}

int mcrypt_get_key_size(int algorithm)
{				/* In bytes */
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->keysize);
	return ret;

}



char *mcrypt_get_algorithms_name(int algorithm)
{
	char *ret = NULL;
	char *pointerTo_;

	/* avoid prefix */
	MCRYPT_ALG_LOOP(ret = strdup(p->name + sizeof("MCRYPT_") - 1));


	if (ret != NULL) {
		tolow( ret, strlen(ret));
		pointerTo_ = strchr(ret, '_');

		while (pointerTo_ != NULL) {
			*pointerTo_ = '-';
			pointerTo_ = strchr(ret, '_');
		}
	}
	return ret;
}



int mcrypt_is_ok_algorithm(int algorithm)
{
	char *y = mcrypt_get_algorithms_name(algorithm);

	if (y != NULL) {
		free(y);
		return 0;
	} else {
		return 1;
	}

}

int mcrypt_is_ok_mode(int mode)
{				/* if this mode exists returns 0 */
	char *y = mcrypt_get_modes_name(mode);

	if (y != NULL) {
		free(y);
		return 0;
	} else {
		return 1;
	}

}




char *mcrypt_get_modes_name(int mode)
{
	char *ret = NULL;
	
	/* avoid prefix */
	MCRYPT_MLOOP(ret = strdup(p->name + sizeof("MCRYPT_") - 1));
	if (ret!=NULL) tolow( ret, strlen(ret));
	
	return ret;
}

