#include "../lib/mcrypt-nm.h"
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <string.h>

/* Prints plaintext and ciphertext in hex for all the algorithms */

/* #define DEBUG */

/* $Id: cipher_test.c,v 1.1.1.1 2000/05/22 13:09:19 nmav Exp $ */

char test0[200][200];

int main()
{

	MCRYPT td, td2;
	int i;
	int j, x = 0;
	unsigned char *keyword = NULL, *password;
	unsigned char *plaintext;
	unsigned char *ciphertext;
	unsigned char cipher_tmp[200];
	char *name;
	int blocksize;


	printf
	    ("Checking whether the algorithm's encryption/decryption work normally\n");

/* Test vectors */

	strcpy(test0[MCRYPT_BLOWFISH], "dec5fcfb5feb111b");
	strcpy(test0[MCRYPT_DES], "a6a0623c9acd9a69");
	strcpy(test0[MCRYPT_TRIPLEDES], "21c6b0ca2c2d37e3");
	strcpy(test0[MCRYPT_THREEWAY], "6efbd64c1aa44091caf7109c");
	strcpy(test0[MCRYPT_GOST], "cc99cd11b48378d4");
	strcpy(test0[MCRYPT_SAFER_SK64], "c8a1490249dd916b");
	strcpy(test0[MCRYPT_SAFER_SK128], "e394643fa1dbc74b");
	strcpy(test0[MCRYPT_CAST_128], "b5bad40c18a3a133");
	strcpy(test0[MCRYPT_XTEA], "2a6c2f9db5b776a4");
	strcpy(test0[MCRYPT_RC2], "1180baf6f36a21e3");
	strcpy(test0[MCRYPT_TWOFISH],
	       "717669e1ca4cd3d4ba2e73adfb05d68c");
	strcpy(test0[MCRYPT_CAST_256], "9a1eeb06e48614338e008ca30e30494c");
	strcpy(test0[MCRYPT_SAFERPLUS],
	       "96cd24a706ed2c54f3b9edbca1df8143");
	strcpy(test0[MCRYPT_LOKI97], "b2913deee25f25dd6e31d727bdd77d4f");
	strcpy(test0[MCRYPT_SERPENT],
	       "3fc472889c60e2ba9e35d311646dad9c");
	strcpy(test0[MCRYPT_RIJNDAEL_128],
	       "621a5598eb65170f411d959377a0d510");
	strcpy(test0[MCRYPT_ARCFOUR],
	       "371e6d430e7bf997dd96aeb5d2b7a01a42525e60ea778730ac5ea11f99d1116efc0fa4512801eea15ab1f484bf883dfdabd6");
	strcpy(test0[MCRYPT_ENIGMA],
	       "3569e0b24f2e974540a2097a4a3788dfa4abd55527d3c771a6d9d1ab52c4a263915ef870ecdce8fa6d2c51edf73e0fc7b92a");

	for (i = 0; i <= 150; i++) {

		if (mcrypt_is_ok_algorithm(i) != 0)
			continue;

		password = malloc(mcrypt_get_key_size(i));
		keyword = calloc(1, mcrypt_get_key_size(i));
		memset(password, '\2', mcrypt_get_key_size(i));
		memset(password, '\3', mcrypt_get_key_size(i) / 2);
		memset(password, '\5', mcrypt_get_key_size(i) / 4);
		memmove(keyword, password, mcrypt_get_key_size(i));


		if (mcrypt_is_block_algorithm(i) != 0) {
			bzero(cipher_tmp, sizeof(cipher_tmp));
			td =
			    mcrypt_generic_init(MCRYPT_ECB, i, keyword,
						mcrypt_get_key_size(i),
						NULL);
			td2 =
			    mcrypt_generic_init(MCRYPT_ECB, i, keyword,
						mcrypt_get_key_size(i),
						NULL);
		} else {
			bzero(cipher_tmp, sizeof(cipher_tmp));
			td =
			    mcrypt_generic_init(MCRYPT_STREAM, i, keyword,
						mcrypt_get_key_size(i),
						NULL);
			td2 =
			    mcrypt_generic_init(MCRYPT_STREAM, i, keyword,
						mcrypt_get_key_size(i),
						NULL);
		}

		if (td == MCRYPT_FAILED || td2 == MCRYPT_FAILED) {
			continue;
		}

		name = mcrypt_get_algorithms_name(i);
		if (name == NULL)
			continue;

		printf("Algorithm: %s... ", name);

		blocksize = mcrypt_get_block_size(i);
		if (blocksize == 1) {	/* stream */
			blocksize = 50;
		}

		ciphertext = malloc(blocksize);
		plaintext = malloc(blocksize);
		bzero(plaintext, blocksize);

		for (j = 0; j < blocksize; j++) {
			plaintext[j] = j % 256;
		}
		memcpy(ciphertext, plaintext, blocksize);

#ifdef DEBUG
		printf("plaintext:  ");
		for (j = 0; j < blocksize; j++) {
			printf("%.2x", ciphertext[j]);
		}
#endif

#ifdef DEBUG
		printf("\nkeyword:    ");
		for (j = 0; j < mcrypt_get_key_size(i); j++) {
			printf("%.2x", keyword[j]);
		}
#endif

		mcrypt_generic(td, ciphertext, blocksize);

#ifdef DEBUG
		printf("\nciphertext: ");
#endif
		for (j = 0; j < blocksize; j++) {
			sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
				ciphertext[j]);
		}

#ifdef DEBUG
		printf("%s\n", cipher_tmp);
#endif


#ifndef DEBUG
		if (strcmp((char *) cipher_tmp, test0[i]) != 0) {
			printf("failed compatibility\n");
			x = 1;
			mcrypt_generic_end(td);
			mcrypt_generic_end(td2);
			free(name);
			free(keyword);
			free(ciphertext);
			free(plaintext);
			free(password);
			continue;
		}
#endif

#ifdef DEBUG
		printf("\n");
#endif

#ifndef DEBUG
		mdecrypt_generic(td2, ciphertext, blocksize);
		if (memcmp(ciphertext, plaintext, blocksize)
		    != 0) {
			printf("failed internally\n");
			x = 1;
			mcrypt_generic_end(td);
			mcrypt_generic_end(td2);
			free(name);
			free(keyword);
			free(ciphertext);
			free(plaintext);
			free(password);
			continue;
		}

		printf("ok\n");
#endif

		mcrypt_generic_end(td);
		mcrypt_generic_end(td2);
		free(name);
		free(keyword);
		free(ciphertext);
		free(plaintext);
		free(password);
	}

	return x;

}
