/*
 *    Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: random.c,v 1.4 2002/05/24 19:14:22 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif
#include <errors.h>

static char rcsid[] = "$Id: random.c,v 1.4 2002/05/24 19:14:22 nmav Exp $";

/* originally was defined in 3way.c */
#define RAND32 (word32) ((word32)rand() << 17 ^ (word32)rand() << 9 ^ rand())
#define RAND8 (word8) ((word8)rand() << 4 ^ (word8)rand() << 2 ^ rand())

#ifdef HAVE_DEV_RANDOM

static int fd;


/* When need of many data is required */

static int open_rand(int safe)
{
	if (safe == 0) {
		fd = open(NAME_OF_DEV_URANDOM, O_RDONLY);
		if (fd == -1) {
			perror(NAME_OF_DEV_URANDOM);
			exit(-1);
		}
	} else {
		fd = open(NAME_OF_DEV_RANDOM, O_RDONLY);
		if (fd == -1) {
			perror(NAME_OF_DEV_RANDOM);
			exit(-1);
		}
	}
	return 0;
}

static void close_rand(void)
{
	close(fd);
}



#endif				/* HAVE_DEV_RANDOM */

void mcrypt_randomize( void* _buf, int buf_size, int type) {
unsigned char *buf = _buf;

#ifdef HAVE_DEV_RANDOM
	open_rand(type);

	if (read( fd, buf, buf_size)==-1) {
		err_quit(_("Error while reading random data\n"));
	}
	close_rand();
#else
	
	for (i=0;i<buf_size;i++) {
		buf[i] = RAND8;
	}

#endif

}
