#include "matrix.hpp"

unsigned int matrix::getn() const
{
return itsn;
}

NUM matrix::get(const unsigned int i,const unsigned int j) const
{
return elem[i*itsn + j];
}

void matrix::fill(const NUM fl)
{
for (ushort i=0;i<itsn;i++)
        {
        for (ushort j=0;j<itsn;j++)
                {
                elem[i*itsn+j]=fl;
                }
        }
}


void matrix::diagfill(const NUM fl)
{
for (ushort i=0;i<itsn;i++)      
        {
        for (ushort j=0;j<itsn;j++)
                {
                if (i==j)
                        {elem[i*itsn+j]=fl;}
                else
                        {elem[i*itsn+j]=0;}
                }
        }
}

matrix::matrix(const unsigned int n)
{
elem=new NUM[n*n];
itsn=n;
for (ushort i=0;i<n;i++)      
        {
        for (ushort j=0;j<n;j++)
                {
                elem[i*itsn+j]=0;
                }
         }

}

matrix::~matrix()
{
itsn=0;
delete [] elem;
}

ostream & operator<< (ostream & output, const matrix & A)
{
unsigned int n=A.getn();
for (unsigned int i=0;i<n;i++)
        {
        for (ushort j=0;j<n;j++)
                {
                output << A.eget(i*n+j)<<"\t";
                }
        output <<endl;
        }
return output;
}

matrix::matrix(const matrix & rhs)
{

itsn=rhs.getn();
elem=new NUM[itsn*itsn];
unsigned int n=itsn;
for (ushort i=0;i<n;i++)      
        {
        for (ushort j=0;j<n;j++)
                {
                elem[i*itsn+j]=rhs.get(i,j);
                }
        }
}

matrix matrix::operator+ (const matrix & rhs)
{
if (itsn!=rhs.getn()) return matrix(0);
matrix B(itsn);
for (ushort i=0;i<itsn;i++)
        {
        for (ushort j=0;j<itsn;j++)
        B.set(i,j,elem[i*itsn+j]+rhs.get(i,j));
        }
return B;
}

matrix matrix::operator- (const matrix & rhs)
{
if (itsn!=rhs.getn()) return matrix(0);
matrix B(itsn);
for (ushort i=0;i<itsn;i++)
        {
        for (ushort j=0;j<itsn;j++)
        B.set(i,j,elem[i*itsn+j]-rhs.get(i,j));
        }
return B;
}


matrix & matrix::operator= (const matrix & rhs)
{
if (this==&rhs) return *this;
delete [] elem;
unsigned int n=rhs.getn();
itsn=n;
elem=new NUM[n*n];

for (ushort i=0;i<n;i++)
        {
        for (ushort j=0;j<n;j++)
        elem[i*itsn+j]=rhs.get(i,j);
        }
return *this;
}

matrix matrix::operator* (const NUM l)
{
matrix B(itsn);
for (ushort i=0;i<itsn;i++)
        {
        for (ushort j=0;j<itsn;j++)
                {
                B.set(i,j,l*elem[i*itsn+j]);
                }
        }
return B;
} 


matrix matrix::operator* (const matrix & rhs)
{
if (itsn!=rhs.getn()) return matrix(0);
matrix B(itsn);
unsigned int n=itsn;
NUM sum=0;
for (ushort i=0;i<itsn;i++)
        {
        for (ushort j=0;j<itsn;j++)
                {
                sum=0;
                for (ushort x=0;x<n;x++)
                        {
                        sum=sum+elem[i*itsn+x]*rhs.get(x,j);
                        }
                B.set(i,j,sum);
                }
        }
return B;
}


//real functions
matrix step(ushort a,ushort b,const matrix & A)
{
matrix B(A.getn() - 1);
unsigned int n=A.getn();
long bi=-1;
long bj=-1;
ushort j=0,i=0;

for (i=0;i<n;i++)
        {
        if (i!=a) bi++;
        bj=-1;
        for (j=0;j<n;j++)
                {
                if (j!=b) bj++;
                if (i!=a && j!=b) B.set( (ushort) bi, (ushort) bj,A.get(i,j));
                }
        }
return B;
}

//prosomoiosi tou (-1)^(i+j)
int pros(unsigned int i,unsigned int j)
{
i+=1;
j+=1;

if ((i+j)%2==0)
        {return 1;}
else
        {return -1;}
}

//orizousa (at last!)
NUM det (const matrix & A)
{
unsigned int n=A.getn();
NUM b=0,sum=0;
if (A.getn()==2)
        {return A.get(0,0)*A.get(1,1) - A.get(1,0)*A.get(0,1);}
else
        {
        if (A.getn()==0 || A.getn()==1) 
                {
                return 0;
                }
        else
                {
                for (ushort j=0;j<n;j++)
                        {
                        b=det(step(0,j,A))*pros(0,j)*A.get(0,j);
                        sum=sum+b;
                        }
                return sum;
                }
        }
}      

//anastrofos pinakas
matrix invert(const matrix & A)
{
unsigned int n=A.getn();
matrix B(n);
        for (unsigned int i=0;i<n;i++)
                {
                for (unsigned int j=0;j<n;j++)
                        {
                        B.set(j,i,A.get(i,j));
                        }
                }
return B;
}

//antistrofos pinakas!
matrix anti (const matrix & A)
{
NUM a=0,b=det(A);

if (b==0) return matrix(0);
unsigned int n=A.getn();
matrix B(n);

if (n==2)
        {
        B.set(0,0,A.get(1,1)/det(A));        
        B.set(0,1,(-1)*A.get(0,1)/det(A));        
        B.set(1,0,(-1)*A.get(1,0)/det(A));        
        B.set(1,1,A.get(0,0)/det(A));        
        }
else
        {
        if (n<2) 
                {
                B.fill(0);
                }
        else
                {
                for (unsigned int i=0;i<n;i++)
                        {
                        for (unsigned int j=0;j<n;j++)
                                {
                                a=(pros(i,j)*det(step(i,j,A)))/b;
                                B.set(j,i,a);
                                }
                        }
                }
        }

return B;

}



