// Ioannina 1998
// HPP file for square matrices
// Has all the functions needed for matrices(eg. det,invert,anti,+,-,* etc.)
// Nikos Mavroyanopoulos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

// NOTE: Initialize a matrix (maybe as matrix(0)) before using =

#include <iostream.h>
#define ushort unsigned int

typedef double NUM;

class matrix
{
public:
matrix(const unsigned int);
~matrix();
matrix(const matrix &);

//functions
        unsigned int getn() const;
        NUM get(const unsigned int i,const unsigned int j) const;
        NUM eget(const unsigned int ij) const {return elem[ij];}
        void set(const unsigned int i,const unsigned int j,NUM val){elem[i*itsn +j ]=val;}
        void eset(const unsigned int i,NUM val){elem[i]=val;}
        void fill(const NUM fl);
        void diagfill(const NUM fl);


//operators
        matrix operator+ (const matrix&);
        matrix operator- (const matrix&);
        matrix & operator= (const matrix&);
        matrix operator*(const NUM);
        matrix operator*(const matrix&);
        friend ostream & operator<< (ostream& ,const matrix &);

private:
        unsigned int itsn;
        NUM * elem;
};

//diloseis synartisewn
matrix step(ushort a,ushort b,const matrix & A);
NUM det (const matrix & A);
int pros(unsigned int i,unsigned int j);
matrix invert(const matrix & A);
matrix anti (const matrix & A);
