//  Mini-Crypt program. It crypts text or binary files using
//  keywords. The keyword is NOT included in the encrypted file so
//  there is no way to decrypt it, if you forgot it.
//  Nikos Mavroyanopoulos
//  I can be reached via email in ngm@beryl.kapatel.gr
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "mcrypt.hpp"

int stream_flag=0;

				//prints error for arguments
void usage(char *name)
{
     cout << "\nThis program encrypts and decrypts files using nxn matrices\n";
     cout << "Do not use it to encrypt valuable data, it is NOT safe\n\n";
     cout << "To encrypt write:\n"<<name<<" -e source.file -o encrypted.file\n";
     cout << "To decrypt write:\n"<<name<<" -d encrypted.file -o output.file\n";
     cout << "You can also specify '-s' to enter the keyword.\n\n";
     cout << "Or:\n";
     cout << "To encrypt write:\nmcrypt -s \"keyword\" < source.file > encrypted.file\n";
     cout << "To decrypt write:\nmdecrypt -s \"keyword\" < encrypted.file > output.file\n\n";
     cout << " --help         prints this help\n";
     cout << " --version      prints the version number\n\n";
     cout << "Report bugs to nmav@i-net.paiko.gr.\n\n";
}



				//The main
main(int argc,char **argv)
{
	cerr << "\n-=- Mini-Crypt -=-\n\n";
#ifdef DEBUG
	cerr << "Debug Mode\n";
#endif

	int ch,ein=0,din=0,out=0,kin=0;
	char *einfile=0, *outfile=0 ,*dinfile=0, *keyword=0;
	extern char *optarg;

	int x;

#ifdef HAVE_GETOPT_H

	struct option longopts[] =
        {
	    { "version", 0, 0, 'v' },
	    { "help", 0, 0, 'h' },
	    { "encrypt", 0, 0, 'e' },
	    { "decrypt", 0, 0, 'd' },
	    { "output", 0, 0, 'o' },
	    { "key", 0, 0, 's' },
	    { 0, 0, 0, 0 }
	};
 


	while( (ch=getopt_long(argc,argv,"e:d:o:s:hv",longopts, (int *)0 )) != EOF )
#else
	while( (ch=getopt(argc,argv,"e:d:o:s:hv")) != EOF )
#endif
		switch(ch) {
	
		case 'e':
			einfile= new char[strlen(optarg)+1];
			strcpy(einfile,optarg);
			ein=1;
			if (din!=0) {cerr << "You cannot specify both encryption and decryption.\n";return 1;}
			break;

		case 'v':
			cout << "\nMini-crypt v"<<VERSION<<"\n";
			cout << "By Nikos Mavroyanopoulos\n\n";
			return 0;
			break;

		case 'o':
			outfile= new char[strlen(optarg)+1];
			strcpy(outfile,optarg);
			out=1;
			break;

		case 'd':
			dinfile= new char[strlen(optarg)+1];
			strcpy(dinfile,optarg);
			din=1;
			if (ein!=0) {cerr << "You cannot specify both encryption and decryption.\n";return 1;}
			break;

		case 's':
			kin=1;
			keyword= new char[strlen(optarg)+1];
			strcpy(keyword,optarg);
			if (keyword==NULL) {cerr << "You must specify a keyword.\n";return 1;}
			break;

		case '?':
		case 'h':
		default:
		     usage(argv[0]);
		     return 1;
		     break;


		}
	



if (argc==3 && kin!=0) {

	stream_flag=1;

	if (strstr(argv[0],"mcrypt")!=NULL) 
	{
		x=encrypt(dinfile,outfile,keyword);
		return x;
	}
	else  /* mdecrypt */ 
	{
		x=decrypt(dinfile,outfile,keyword);
		return x;
	}
}	

if (argc==1 ) 
{
	cerr << "\nYou must specify a keyword via '-s'.\n";
	cerr << "Use --help for more help.\n";
	return 1;
}

// if not streams force output file
	if (out==0) 
	{cerr << "You must specify an output file.\n";return 1;}


//Decrypt
	if (din!=0) {
		if (strcmp(dinfile,outfile)==0) 
		{
			cerr << "\n\nYou cannot use the same file.\n";return 1;
		} 
			else
		{
			x=decrypt(dinfile,outfile,keyword);
			if (x==0)
        	        	{cout << "The file was decrypted.\n";}
	        	else
        	        	{cout << "\nThe file was NOT decrypted successfully.\n";}
        
	        	return x;
		}
	}		

//Encrypt
	if (ein!=0) {
		if (strcmp(einfile,outfile)==0) 
		{
			cerr <<"\n\nYou cannot use the same file.\n";
			return 1;
		}
		else
		{
	        	x=encrypt(einfile,outfile,keyword);
	        	if (x==0)
		                {cout << "The file was successfully encrypted.\n";}
		        else
	        	        {cout << "\nThe file was NOT encrypted successfully.\n";}
		        return x;
		}
	}        

}




				//encryption

int encrypt(char *fromfile,char *tofile,char *key)
{
int ch=0;
int tempint,i=0,idoc;
FILE *TOF;
FILE *FROMF;

//open files
if (stream_flag==1)
{
	TOF=stdout;
	FROMF=stdin;
	if (FROMF==NULL) {cerr <<"Error opening stdin\n";fclose(FROMF);return 1;}
	if (TOF==NULL) {cerr <<"Error opening stdout\n";fclose(TOF);return 1;}
}
else
{
	TOF=fopen(tofile,"w");
	FROMF=fopen(fromfile,"r");
	if (FROMF==NULL) {cerr <<"Error opening file: "<<fromfile<<"\n";return 1;}
	if (TOF==NULL) {cerr <<"Error opening file: "<<tofile<<"\n";return 1;}
}

matrix B(0);

	if (key==NULL)
	{
		B=prompt();
	}
	else
	{
		B=prompt(key);
	}

cerr << "Crypting...\n";
int a=B.getn();

//text matrix

matrix TEX(a);
matrix ENC(0);

#ifdef DEBUG
cerr << "\nStarted reading and writing files.\n";
#endif
//reads the first a*a characters of the file and stores the to doc
do
{
        for (idoc=0;idoc<a*a;idoc++)
	{

		if (ch==2) 
		{
//2000 is used to point the EOF ...
			TEX.eset(0,2000);
			for (idoc=1;idoc<a*a;idoc++) 
			{
				srand(idoc);
				//Set random numbers to make difficult finding the keyword from EOF
				TEX.eset(idoc,rand()%255);
			}
	        	        ch=1;
		}

		if (ch==0)
		{
//			fscanf(FROMF,"%c",&doc[0]);
//			TEX.eset(idoc,doc[0]);
			tempint=fgetc(FROMF);
		        if (tempint!=EOF) 
				{TEX.eset(idoc,tempint);}
			else
        		{
	        		        ch=1;
					#ifdef DEBUG
					cout << "EOF"<<endl;
					#endif			

					if ((idoc)<a*a) 
					{	
						TEX.eset(idoc,2000);
						for (idoc++;idoc<a*a;idoc++) 
						{
							srand(idoc);
							//Set random numbers to make difficult finding the keyword from EOF
							TEX.eset(idoc,rand()%255);
						}

					}
					else
					{
						//rare but it caused problems
						ch=2;
					}
			}

	        }

	}
#ifdef DEBUG
cerr <<TEX;           
cerr <<endl;
#endif
                ENC=TEX*B;
//read encrypted matrix and put it to file        
        
                for (i=0;i<a*a;i++) 
                                {
//double->int
                                tempint=fix(ENC.eget(i));
//                                fprintf(TOF,"%x.",tempint);
				if (fwrite(&tempint,sizeof(tempint),1,TOF)==0) {perror("fwrite");}
                                }
}
while(ch!=1);

// Enter some random numbers... To confuse anyone trying to decrypt via the
// EOF stop.
	cerr << "Enabling random seed...\n";
	long randstop=rand()%RANDOM;
	srand(idoc);
	for (i=1;i<randstop;i++) 
                                {
                                tempint=rand()%8000;
//                                fprintf(TOF,"%x.",tempint);
				if (fwrite(&tempint,sizeof(tempint),1,TOF)==0) {perror("fwrite");}
				}
//close files
        fclose(TOF);
        fclose(FROMF);

#ifdef DEBUG
cerr <<endl<<"Files closed."<<endl;
#endif

return 0;
}










//Decryption Function


int decrypt(char *fromfile,char *tofile, char *key)
{
int ch=0,tempint=0;
int temp;

FILE *TOF;
FILE *FROMF;

if(stream_flag==1)
{
	TOF=stdout;
	FROMF=stdin;
	if (FROMF==NULL) {cerr <<"Error opening stdin\n";fclose(FROMF);return 1;}
	if (TOF==NULL) {cerr <<"Error opening stdout\n";fclose(TOF);return 1;}
}
else
{
	TOF=fopen(tofile,"w");
	FROMF=fopen(fromfile,"r");
	if (FROMF==NULL) {cerr <<"Error opening file: "<<fromfile<<"\n";fclose(FROMF);return 1;}
	if (TOF==NULL) {cerr <<"Error opening file: "<<tofile<<"\n";fclose(TOF);return 1;}
}

matrix B(0);

	if (key==NULL)
	{
		B=prompt_get();
	}
	else
	{
		B=prompt(key);
	}

cerr << "Decrypting...\n";
matrix C(0);
C=anti(B);

int a=B.getn();

//text matrix

int idoc,j;

matrix TEX(a),DEC(0);

//reads the first a*a characters of the file and stores the to matrix TEX
do
        {

        for (idoc=0;idoc<a*a;idoc++)
                {
//                fscanf(FROMF,"%x.",&tempint);
		if (fread(&tempint,sizeof(tempint),1,FROMF)==0) {perror("fread");}
                TEX.eset(idoc,tempint);        
		if (feof(FROMF)!=0) {ch=2;break;}
                }


           
//decrypt                
                DEC=TEX*C;
#ifdef DEBUG
cerr <<DEC;
cerr <<endl;
#endif

//put decrypted to file        
        
                for (j=0;j<a*a;j++)
                {
//conversion double->int
	                tempint=fix(DEC.eget(j));
			temp=tempint;
//#ifdef DEBUG
//			cerr <<temp;
//#endif
			if (tempint==2000)
			{
				ch=1;
				#ifdef DEBUG
				cerr << "EOF found!\n";
				#endif
				break;
			}
			else 
			{
				fputc(temp,TOF);
			}

                }
}
while(ch==0);

//close files
        fclose(TOF);
        fclose(FROMF);


#ifdef DEBUG
cerr <<endl<<"Files closed."<<endl;
#endif

return 0;

}



matrix prompt()
	{
		matrix B(0);
		int intpass;
		NUM x;
		ushort docount=0,a,i,flag=0;
		char pass[LENGTH];
		char passii[LENGTH];
		matrix * Z;
		matrix * I;	

		do
		{
			if (docount!=0)
		        	{
			        cerr << "Illegal Keyword.\n";
				}

			cerr << "\nNow, you have to provide a keyword.\n";
			cerr << "Do not use keywords with 5 characters or less.\n";

//keyword prompt
			do
			{
#ifndef NOT_CURSES
				initscr();
				cbreak();
#endif
				cerr << "Enter the keyword: ";
#ifndef NOT_CURSES
				noecho();
#endif
				cin.getline(pass,LENGTH);
#ifndef NOT_CURSES
				echo();
				cerr <<endl;
#endif
				cerr << "Renter the keyword: ";
#ifndef NOT_CURSES
				noecho();
#endif
				cin.getline(passii,LENGTH);
#ifndef NOT_CURSES
				echo();
#endif
				if (strcmp(pass,passii)!=0) 
					{cerr << "\nSorry keywords do not match.\n";flag=1;}
				else
					{flag=0;}

#ifndef NOT_CURSES
				endwin();
#endif
			}
			while(flag!=0);

		a=1;
		
		while (a*a<strlen(pass)) 
		        {
		        a++;
        		}
	
		Z=new matrix(a);
		Z->diagfill(1);
		B=*Z;

//Encryption matrix
		for (i=0;i<strlen(pass);i++)
		        {
		        intpass=pass[i];
//changed to *3 so that similar keywords do not decrypt partly the document
		        B.eset(i,intpass*3);
	        	}


		x=det(B);
//If det=0 use B+900*I or B-900*I... That way we reduce the number of illegal
// keywords.

		I=new matrix(a);
		I->diagfill(900);
		if (x==0) B=(B)+(*I);
		x=det(B);
		if (x==0) B=(B)-((*I)*2);
		x=det(B);


#ifdef DEBUG
cerr <<"\nDet:"<<det(B)<<endl;
cerr <<"Normal:\n"<<B<<endl;
cerr <<"Reversed:\n"<<anti(B)<<endl;
cerr <<"I:\n"<<anti(B)*B<<endl;
#endif

		delete I;
		delete Z;
 		docount++;
		}        
		while (x==0);

return B;

	}


//prompt but to decrypt function
matrix prompt_get()
	{
		matrix * I;
		matrix * Z;
		matrix B(0);
		int intpass;
		NUM x;
		ushort docount=0,a,i;
		char pass[LENGTH];
	
		do
		{
		if (docount!=0)
		        {
		        cerr << "Illegal Keyword.\n";
	        	}
	
//keyword prompt
#ifndef NOT_CURSES
		initscr();
		cbreak();
#endif

		cerr << "Enter the keyword: ";


#ifndef NOT_CURSES
		noecho();
#endif

		cin.getline(pass,LENGTH);


#ifndef NOT_CURSES
		echo();
		endwin();
#endif

		a=1;
		
		while (a*a<strlen(pass)) 
		        {
		        a++;
        		}
	
		
		Z=new matrix(a);
		Z->diagfill(1);
		B=*Z;
	

//Encryption matrix
		for (i=0;i<strlen(pass);i++)
		        {
		        intpass=pass[i];
		        B.eset(i,intpass*3);
	        	}



		docount++;
		x=det(B);
//If det=0 use B+300*I or B-300*I... That way we reduce the number of illegal
// keywords. I use 300 so there is no second keyword that decrypts.

		I=new matrix(a);
		I->diagfill(300);

		if (x==0) B=B+(*I);
		x=det(B);
		if (x==0) B=B-((*I)*2);
		x=det(B);


#ifdef DEBUG
cerr <<"\nDet:"<<det(B)<<endl;
cerr <<"Normal:\n"<<B<<endl;
cerr <<"Reversed:\n"<<anti(B)<<endl;
cerr <<"I:\n"<<anti(B)*B<<endl;
#endif
		}        
		while (x==0);

return B;
	}



int fix(NUM a)
{
	int aint=static_cast<int>(a);
	if (abs(a-aint)>=0.5)
		{return aint+1;}
	else
		{return aint;}
}

NUM abs(NUM a)
{
	if (a>0)
		{return a;}
	else
		{return (-1)*a;}
}





matrix prompt(char *key)
{
		matrix B(0);
		int intpass;
		NUM x=0;
		ushort docount=0,a,i;
		char pass[LENGTH];
		matrix * Z;
		matrix * I;	
		
		strcpy(pass,key);

		a=1;
		
		while (a*a<strlen(pass)) 
		        {
		        a++;
        		}
	
		Z=new matrix(a);
		Z->diagfill(1);
		B=*Z;

//Encryption matrix
		for (i=0;i<strlen(pass);i++)
		        {
		        intpass=pass[i];
//changed to *3 so that similar keywords do not decrypt partly the document
		        B.eset(i,intpass*3);
	        	}


		x=det(B);
//If det=0 use B+900*I or B-900*I... That way we reduce the number of illegal
// keywords.

		I=new matrix(a);
		I->diagfill(900);
		if (x==0) B=(B)+(*I);
		x=det(B);
		if (x==0) B=(B)-((*I)*2);
		x=det(B);


#ifdef DEBUG
cerr <<"\nDet:"<<det(B)<<endl;
cerr <<"Normal:\n"<<B<<endl;
cerr <<"Reversed:\n"<<anti(B)<<endl;
cerr <<"I:\n"<<anti(B)*B<<endl;
#endif

		delete I;
		delete Z;
 		docount++;

		if (x==0) {cerr << "Illegal keyword.\n"; return 1;}

return B;

}


//prompt but to decrypt function
