/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "defines.h"
#include "extra.h"
#include "bits.h"

/* expands the one keyword to three (for tripleDES)
 */
int BreakToThree(void * key, unsigned int keylen, void * keyword1, void * keyword2, void * keyword3)
{
unsigned int D,y,i,j,z;
unsigned char key_buf[5][32];  /* up to sixteen  (128/4=32) */
char *tmpkey=key;

  if (keylen<3) {
   fprintf(stderr,_("Not enough long keyword for tripleDES (3 char at least)\n"));
   return 1;
  }
  else {

      if (keylen>=24) keylen=24;

          D=keylen/3;
          y=keylen % 3;

          for (i=0;i<3;i++) {

              bzero(key_buf[i],sizeof(key_buf[i]));
              if (i==2) { /* last round */
                memcpy(key_buf[i],tmpkey,D+y);
              }
              else {
               memcpy(key_buf[i],tmpkey,D);    
              }
         
              for (j=0;j<D;j++) {
                for (z=0;z<(keylen-j-1);z++)
                  memcpy(&tmpkey[z],&tmpkey[z+1],1);
              }
          }

         memcpy(keyword1,key_buf[0],8); 
         memcpy(keyword2,key_buf[1],8); 
         memcpy(keyword3,key_buf[2],8); 
         return 0;
}

}


/* Byte swap a 32bit integer */
word32 byteswap(word32 x)
{
	register char *cp,tmp;

	cp = (char *)&x;
	tmp = cp[3];
	cp[3] = cp[0];
	cp[0] = tmp;

	tmp = cp[2];
	cp[2] = cp[1];
	cp[1] = tmp;

	return x;
}

char * my_getpass(char * prt) {
char *atmp;
char ztmp[128];
char *btmp;

   atmp=getpass(prt);

   bzero(ztmp,sizeof(ztmp));
   strncat(ztmp,atmp,127);

   btmp=getpass("Re-Enter key: ");
   
  if (strcmp(ztmp,btmp)!=0) {
     fprintf(stderr,_("Keywords do not match.\n"));
     return NULL;
  }

 return btmp;
}

char * get_password(int numofchar,int bitmode,int mode,int type)
{
int x=0;
char *tmp;
char msg[100];

  if (bitmode==0) {
   sprintf(msg,_("Enter key (%d chars): "),numofchar);

   if (mode==ENCRYPT) {tmp=my_getpass(msg);} else {tmp=getpass(msg);}
/*   if (strncmp(tmp,"\0",1)==0) return NULL; */
   if(tmp==NULL) return NULL;

   if ((strlen(tmp) > numofchar) && (type!=BLOWFISH)) { fprintf(stderr,_("Warning: keyword is too small for this algorithm\n")); }
   if (strlen(tmp) > numofchar) { fprintf(stderr,_("Warning: Reducing the size of keyword\n")); }
 }
 else { /* 7bit mode */


   if ( ((numofchar*8) % 7) !=0 ) x=1;
   sprintf(msg,_("Enter key (%d chars): "),((numofchar*8)/7)+x);

   if (mode==ENCRYPT) {tmp=my_getpass(msg);} else {tmp=getpass(msg);}
/*   if (strncmp(tmp,"\0",1)==0) return NULL; */
   if(tmp==NULL) return NULL;

   if ((strlen(tmp) < (numofchar*8)/7) && (type!=BLOWFISH)) { fprintf(stderr,_("Warning: keyword is too small for this algorithm\n")); }
   if (strlen(tmp) > ((numofchar*8)/7)+x) { fprintf(stderr,_("Warning: Reducing the size of keyword\n")); }
   strip8bit(tmp,strlen(tmp));
}

return tmp;

}


int show_mode(int ende, int stype,int smode,char *output,int bitmode)
{
  
  if (stype==DES) fprintf (stderr,_( "Algorithm: DES \n"));  
  if (stype==TripleDES) fprintf (stderr,_( "Algorithm: 3DES\n"));
  if (stype==ThreeWAY) fprintf (stderr,_( "Algorithm: 3-WAY\n"));
  if (stype==BLOWFISH) fprintf (stderr,_( "Algorithm: Blowfish\n"));
  if (stype==GOST) fprintf (stderr,_( "Algorithm: GOST\n"));
  if (stype==CRYPT) {
    fprintf (stderr,_( "Algorithm: Unix Crypt\n"));  
  }
  else {

  if (smode==CBC) fprintf (stderr,_( "Mode: CBC\n"));
  if (smode==ECB) fprintf (stderr,_( "Mode: ECB\n"));
  }
  
  if (bitmode==BITS7) fprintf (stderr,_( "Keyword Bit Mode: 7bits/char\n"));
  if (bitmode==BITS8) fprintf (stderr,_( "Keyword Bit Mode: 8bits/char\n"));  
    
   if (ende==ENCRYPT) {
     fprintf (stderr,_( "Crypting to %s ...\n"),output);
     }
   else {
     fprintf (stderr, _("Decrypting to %s ...\n"),output);
     }
  
return 0;  
}


#ifdef HAVE_SYS_STAT_H

int check_file(char * filename) {
struct stat ostat;

  if (stat(filename,&ostat) == 0) {
    return 1; /* exists */
  }
  else {
    return 0; /* ok */
  }


}

#endif

int my_read(int fd, void *buf, size_t count) {

  int i,x;
  char *tmpbuf=buf;

 x=read(fd,tmpbuf,count);
 if (x < count) { 
  for (i=x;i<count;i++) {
    x=read(fd,&tmpbuf[i],1);
    if (x==0) return i;
    if (x==-1) return (-1);
  }
 }
 
return count;

}

int check_file_head(char * filename, unsigned int *algorithm, unsigned int *mode, unsigned int *bit7_flag, unsigned int stream_flag)
{
FILE *fstream;
char buf[6];

 if (stream_flag==TRUE) {
  fstream=(FILE *) stdin;
 }
 else {
  fstream=fopen(filename,"r");
 } 

 fread(buf, 1, 6, fstream);

 if (buf[0]=='\0' && buf[1]=='m' && buf[2]=='\0') {
  /* headers are ok */

  *algorithm=(unsigned int) buf[3];
  *mode=(unsigned int) buf[4];
  *bit7_flag=(unsigned int) buf[5];

/* 6 To 9 are crc32 */

  if (stream_flag==FALSE) fclose(fstream);
  return 0;
 }  
 else { /* No headers present */
   if (stream_flag==FALSE) { 
    fclose(fstream); 
    return 1;
   }
   else { /* restart the stream so we will not loose important data */
     if (fseek( fstream, 0, SEEK_SET)==-1) {
       perror("fseek");
       fprintf(stderr,_("Unable to get algorithm information. Use the --bare flag and specify the algorithm manualy.\n"));
       exit(-1);
     }
     else {
       return 1;
     }
     
   }
 }

}


int write_file_head(int filedes, unsigned int algorithm, unsigned int mode, unsigned int bit7_flag)
{
unsigned char buf[6];

 buf[0]='\0';
 buf[1]='m';
 buf[2]='\0';
 buf[3]=(unsigned char) algorithm;
 buf[4]=(unsigned char) mode;
 buf[5]=(unsigned char) bit7_flag;

/* 6 to 9 are crc32 */

  if (write(filedes, buf, 6)==6) {
   return 0;
  }
  else {
   return 1;
  }
   
}

#ifdef HAVE_SYS_STAT_H
# ifdef HAVE_UTIME_H
void copyDate ( char *srcName, char *dstName )
{
   int retVal;
   struct stat statBuf;
   struct utimbuf uTimBuf;
            
   retVal = stat ( srcName, &statBuf );
   if (retVal==-1) perror("stat");

   uTimBuf.actime = statBuf.st_atime;
   uTimBuf.modtime = statBuf.st_mtime;
                        
   retVal = utime ( dstName, &uTimBuf );
   if (retVal==-1) perror("utime");
}
# endif
#endif
                                       