#ifndef DEFINES_H_INC
 #define DEFINES_H_INC
 #include <defines.h>
#endif

#include <lcrypt.h>
#include <blowfish.h>
#include <3-way.h>
#include <gost.h>
#include <des.h>

static blf_ctx c; /* For Blowfish */
static char kn1[16][8]; /* For DES */
static char kn2[16][8];
static char kn3[16][8]; /* For tripleDES */

int get_block_size(int algorithm)
{
  switch(algorithm) {
  
   case DES:
   case TripleDES:
   case BLOWFISH:
   case GOST:
      return 8;
      break;

   case ThreeWAY:
      return 12;
      break;

   default:
      return 0;
  }


}

int get_key_size(int algorithm) /* In bytes */
{
  switch(algorithm) {
  
   case DES:
      return 8; /* Actually 7 but the algorithm here uses 8 */
      break;

   case TripleDES:
      return 24; 
      break;

   case BLOWFISH:
      return 56; 
      break;

   case GOST:
      return 32;
      break;

   case ThreeWAY:
      return 12;
      break;

   default:
      return 0;
  }

}


int init_mcrypt(const int algorithm, void * key,const int lenofkey)
{

char keyword1[8], keyword2[8], keyword3[8]; /* For DES */

   switch(algorithm) {
  
   case DES:
      desinit(0);
      des_setkey(kn1, key);
      return 0;
      break;
      
   case TripleDES:
      desinit(0);
      BreakToThree(key, lenofkey, keyword1, keyword2, keyword3);
      des_setkey(kn1, keyword1);
      des_setkey(kn2, keyword2);
      des_setkey(kn3, keyword3);
      return 0;
      break;
       
   case BLOWFISH:
      blf_key(&c,key,lenofkey);
      return 0;
      break;

   case GOST:
      kboxinit();
      return 0;
      break;

   case ThreeWAY:
      return 0;
      break;

   default:
      return 0;
  }

}


/* plaintext should be in block's size */
int mcrypt(int algorithm, void *key, const int lenofkey, void *plaintext)
{

  switch(algorithm) {

   case DES:
      endes (kn1, plaintext);
      return 0;
      break;
      
   case TripleDES:
      endes (kn1, plaintext);
      dedes (kn2, plaintext);
      endes (kn3, plaintext);
      return 0;
      break;

   case BLOWFISH:
      enblf(&c, plaintext);
      return 0;
      break;

   case GOST:
      gostcrypt(plaintext, key);
      return 0;
      break;

   case ThreeWAY:
      en3way(plaintext,key);
      return 0;
      break;

   default:
      return 0;
  }
}


/* plaintext should be in block's size */
int mdecrypt(int algorithm, void *key,const int lenofkey, void *plaintext)
{

  switch(algorithm) {
  
   case DES:
      dedes (kn1, plaintext);
      return 0;
      break;
      
   case TripleDES:
      dedes (kn3, plaintext);
      endes (kn2, plaintext);
      dedes (kn1, plaintext);
      return 0;
      break;

   case BLOWFISH:
      deblf(&c, plaintext);
      return 0;
      break;

   case GOST:
      gostdecrypt(plaintext, key);
      return 0;
      break;

   case ThreeWAY:
      de3way(plaintext,key);
      return 0;
      break;

   default:
      return 0;
  }
}


int end_mcrypt(const int algorithm)
{

   switch(algorithm) {
  
   case DES:
   case TripleDES:
      desdone();
      break;
      
   case BLOWFISH:
   case GOST:
   case ThreeWAY:
      break;

   default:
      return 0;
  }

return 0;
}

