/*  Mini-Crypt2 program. It encrypts text or binary files using
 *  keywords. The keyword is NOT included in the encrypted file so
 *  there is no way to decrypt it, if you forgot it. 
 *  For a brief description of the algorithms read the README file and
 *  the man page.
 *                                     Nikos Mavroyanopoulos
 *                                         nmav@i-net.paiko.gr
 *
 *    Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "mcrypt.h"
#include "des.h"
#include "gost.h"
#include "3-way.h"
#include "crypt.h"
#include "blowfish.h"
#include "bits.h"
#include "lcrypt.h"
#include "sunlink.h"
#include "crc32.h"

 unsigned int bit7_flag=BITS7;
 unsigned int stream_flag=FALSE;
 unsigned int mode=CBC; /* 0:cbc 1:ecb */
 unsigned int type=BLOWFISH; /* default: blowfish */
 int quiet=TRUE; /* silent by default */
 int unlink_flag=FALSE;
 int bare_flag=FALSE;

void usage(char *name)
{

     fprintf(stderr,_("Usage: %s (-e) FILE1 FILE2 ...\n"),name);
     fprintf(stderr,_("Usage: %s -d FILE1 FILE2 ...\n\n"),name);

     fprintf(stderr,_("\n  mini-crypt encrypts and decrypts files using the des, triple des \n\
3-way, gost and blowfish algorithms.\n\
\n\
 -e --encrypt      encrypts\n\
 -d --decrypt      decrypts\n\
 -t --type TYPE    specify the encryption and decryption algorithm.\n\
   Legal parameters are: 3way,des,3des,gost,crypt and blowfish.\n\
    (Default is blowfish)\n\
 -m --mode MODE    specify the mode (ecb or cbc). (Default is cbc)\n\
 -k --key  KEYWORD keyword to use.\n\
 -7 --7bit         keyword in 7bit mode. (default)\n\
 -8 --8bit         keyword in 8bit mode.\n\
 -u --unlink       unlink (and destroy) the input file after encryption/decryption\n\
 -L --license      displays license information.\n\
 -q --quiet        Suppresses some non critical warnings.\n\
 -V --verbose      Some more information is displayed.\n\
 -b --bare         Do not keep algorithm information in the encrypted file.\n\
 -f --force        forces output to stdout.\n\
 \n\
 -h --help         prints this help\n\
 -v --version      prints the version number\n\
 \n\
Report bugs to nmav@i-net.paiko.gr.\n\n"));
}




/*				The main    */
int main(int argc,char **argv)
{
	short int ch,ein=0,din=0,kin=0,force=0,return_val=0;
	char *einfile=0, *outfile=0 ,*dinfile=0, *keyword=0,*modet=0,*typet=0;
	char **file; 
	extern char *optarg;
	int x,y,i,file_count=0;


struct option longopts[] = {
	    { "version", 0, 0, 'v' },
	    { "help", 0, 0, 'h' },
	    { "bare", 0, 0, 'b' },	    
	    { "encrypt", 0, 0, 'e' },
	    { "decrypt", 0, 0, 'd' },
	    { "mode", 1, 0, 'm' },
	    { "type", 1, 0, 't' },
	    { "key", 1, 0, 'k' },
	    { "force", 0, 0, 'f' },
	    { "7bit", 0, 0, '7' },	    
	    { "8bit", 0, 0, '8' },
	    { "quiet", 0, 0, 'q'},
	    { "verbose", 0, 0, 'V'},	    
	    { "license", 0, 0, 'L'},
	    { "unlink", 0, 0, 'u'},	    
	    { 0, 0, 0, 0 }
       	  };
 

#ifdef ENABLE_NLS
  setlocale (LC_MESSAGES, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
#endif

            /* File pointers are as much as the file arguments */

        file=malloc((argc-optind)*sizeof(char*)); 

	while( (ch=getopt_long(argc,argv,"f78bLVuqedt:m:k:hv",longopts, (int *)0 )) != EOF )

		switch(ch) {
	
		case 'e':
			ein=1;
			if (din!=0) {fprintf (stderr, _("%s: You cannot specify both encryption and decryption.\n"),argv[0]);return 1;}
			break;

		case 'v':
			printf (_("Mini-crypt v.%s\n"),VERSION);
			printf (_("Copyright (C) 1998,1999 Nikos Mavroyanopoulos (nmav@i-net.paiko.gr)\n"));
			return 0;
			break;

		case 'L':
			printf (_("\nCopyright (C) 1998,1999 Nikos Mavroyanopoulos\n\
This program is free software; you can redistribute it and/or modify \n\
it under the terms of the GNU General Public License as published by \n\
the Free Software Foundation; either version 2 of the License, or \n\
(at your option) any later version. \n\
\n\
This program is distributed in the hope that it will be useful, \n\
but WITHOUT ANY WARRANTY; without even the implied warranty of \n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \n\
GNU General Public License for more details. \n\
\n\
You should have received a copy of the GNU General Public License \n\
along with this program; if not, write to the Free Software \n\
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\n"));
			                                                
			return 0;
			break;			

		case 'd':
			din=1;
			if (ein!=0) {fprintf (stderr, _("%s: You cannot specify both encryption and decryption.\n"),argv[0]);return 1;}
			break;

		case 'f':
			force=1;
			break;

		case 'b':
			bare_flag=TRUE;
			break;

		case 'u':
			unlink_flag=TRUE;
			break;			

		case 'q':
			quiet=TRUE;
			break;			

		case 'V':
			quiet=FALSE;
			break;

		case '7':
			bit7_flag=BITS7;
			break;			

		case '8':
			bit7_flag=BITS8;
			break;			

		case 'k':
			kin=1;
			keyword= malloc(strlen(optarg)+10);
			strcpy(keyword,optarg);
			break;
		case 'm':
			modet= malloc(strlen(optarg)+1);
			strcpy(modet,optarg);
			if (modet[0]=='e' || modet[0]=='E') mode=1;
			free(modet);
			break;
		case 't':
			typet= malloc(strlen(optarg)+1);
			strcpy(typet,optarg);
			if (strncasecmp(typet,"DES",3)==0) {
			  type=DES;
			 }
			else {
			 if (strncasecmp(typet,"3DES",4)==0 || strncasecmp(typet,"3-DES",3)==0) {
                          type=TripleDES;
                         }
                         else {
                          if (strncasecmp(typet,"3WAY",4)==0 || strncasecmp(typet,"3-WAY",3)==0) {
                           type=ThreeWAY;
                          }
                          else {
                           if (strncasecmp(typet,"BLOWFISH",8)==0) {
                            type=BLOWFISH;
                           }
                           else {
                             if (strncasecmp(typet,"GOST",4)==0) {
                               type=GOST;
                             }
                             else {
                              if (strncasecmp(typet,"CRYPT",5)==0) {
                              type=CRYPT;
                              }
                             }
                           }
                          }
                         }
                        }
			free(typet);
			break;


		case '?':
		case 'h':
		default:
		     usage(argv[0]);
		     return 1;
		     break;


		}

#ifdef HAVE_SYS_STAT_H
  umask(066);
#endif

/* Normal startup */



    i=0;
    file_count+= (argc - optind);


    if (file_count==0) {
        stream_flag=TRUE;
    }  

    while (optind < argc) {
        file[i]=argv[optind++];
        i++;
    }

    if (stream_flag==TRUE) file_count++;


/* Do as many times as many files we got */
for(i=0;i<file_count;i++) {

    if(i!=0) { free(outfile); fprintf(stderr,"\n"); }

    if (stream_flag==FALSE) {
      if (quiet==FALSE) fprintf(stderr, _("File: %s\n"),file[i]);
    }
    else {
      if (quiet==FALSE) fprintf(stderr, _("File: stdin\n"));    
    }
    
	if ( (strstr(argv[0],"decrypt")!=NULL) || (din==1)) {
            if (stream_flag!=TRUE) dinfile=file[i];
            din=1;
             if( (isatty(fileno( (FILE *)(stdin) ) ) == 1) && (stream_flag==TRUE) && (force==0) ) { /* not a tty */        
             fprintf(stderr,_("%s: Data will not be read from a terminal.\n"),argv[0]);
             fprintf(stderr,_("Redirect the input instead.\nUse the --help parameter for more help.\n"));
             exit(-1);
             }
        }
        else { /* called as mcrypt or something like that */
            if (stream_flag!=TRUE) einfile=file[i];
            ein=1;
             if( (isatty(fileno( (FILE *)(stdout) ) ) == 1) && (stream_flag==TRUE) && (force==0) ) { /* not a tty */        
             fprintf(stderr,_("%s: Data will not be written to a terminal.\n"),argv[0]);
             fprintf(stderr,_("Redirect the output instead.\nUse the --help parameter for more help.\n"));
             exit(-1);
             }            
        }



       if(stream_flag!=TRUE) {
	 if (din==1) {

            y=strlen(dinfile);
            /* If the file finished in .enc remove it */
             
            if (dinfile[y-1]=='c' && dinfile[y-2]=='n' && dinfile[y-3]=='e' && dinfile[y-4]=='.') {

	      outfile= calloc(y-3,1);
  	      strncat(outfile,dinfile,y-4);
#ifdef HAVE_SYS_STAT_H
              /* But if it exists exit */
              if (check_file(outfile)!=0) {fprintf(stderr,_("\nFile %s exists... skipping...\n\n"),outfile); fflush(stderr); continue;}
#endif  	      
            }
            else { /* append .dec */

	     outfile=calloc(y+5,1);
             strncpy(outfile,dinfile,y);
             strcat(outfile,".dec");
            }
         }
	 else { /* encryption- append .enc */
	    outfile= calloc(strlen(einfile)+5,1);
	    strcpy(outfile,einfile);
	    strcat(outfile,".enc");
	 }
       }
       else { /* if streams */

         outfile=malloc(7);
         strcpy(outfile,"stdout");

       }

/* Decrypt */
	if (din==TRUE) {

           if (bare_flag==FALSE) {
             if (check_file_head(file[i],&type,&mode, &bit7_flag, stream_flag)!=FALSE) {
               fprintf(stderr,_("No headers. Assuming encrypted file with Unix crypt.\n")); 
               type=CRYPT;
             }
           }

		      switch (type) {
		        case DES:
		        case TripleDES:
			case ThreeWAY:
			case BLOWFISH:
			case GOST:
			 x=decrypt_general(type,dinfile,outfile,keyword);
			 break;
			case CRYPT:
			 x=encrypt_ucrypt(dinfile,outfile,keyword);
			 break;			 
                        default:
                         x=1;
                         break;
                        }
                        
			if (x==0) {
        	            if (stream_flag==FALSE) {
        	              if (quiet==FALSE) fprintf (stderr,_("File %s was decrypted.\n"),dinfile);
        	            }
        	            else {
        	              if (quiet==FALSE) fprintf (stderr,_("Stdin was decrypted.\n"));
        	            }
        	           
#ifdef HAVE_SYS_STAT_H
# ifdef HAVE_UTIME_H
                           if (stream_flag==FALSE) copyDate(dinfile,outfile);
#endif
        	           if (unlink_flag==TRUE && stream_flag==FALSE) x=safe_unlink(dinfile);
	        	   if (x!=0) perror("safe_unlink");
#endif        	           
        	        }
	        	else {
                          if (stream_flag==FALSE) {
        	           fprintf (stderr,_("File %s was NOT decrypted successfully.\n"),dinfile);
        	          }
        	          else {
        	           fprintf (stderr,_("Stdin was NOT decrypted successfully.\n"));
        	          }
        	        }
        
                        return_val+=x;
	}		

/* Encrypt */
	if (ein==1) {
		      switch (type) {
		        case DES:
		        case TripleDES:
	        	case ThreeWAY:
	        	case BLOWFISH:
	        	case GOST:
	        	 x=encrypt_general(type,einfile,outfile,keyword);
	        	 break;
	        	 
	        	case CRYPT:
	        	 x=encrypt_ucrypt(einfile,outfile,keyword);
	        	 break;
	        	 
	        	default:
	        	 x=1;
	        	 break;
                        }

	        	if (x==0) {
                          if (stream_flag==FALSE) {
	        	   if (quiet==FALSE) fprintf (stderr,_("File %s was successfully encrypted.\n"),einfile);
	        	  }
                          else {
	        	   if (quiet==FALSE) fprintf (stderr,_("Stdin was successfully encrypted.\n"));
	        	  }
#ifdef HAVE_SYS_STAT_H
# ifdef HAVE_UTIME_H
                           if (stream_flag==FALSE) copyDate(einfile,outfile);
# endif
	        	   if (unlink_flag==TRUE && stream_flag==FALSE) x=safe_unlink(einfile);
	        	   if (x!=0) perror("safe_unlink");
#endif	        	   
		       	}
	                else {
                         if (stream_flag==FALSE) {
	                  fprintf (stderr,_("File %s was NOT encrypted successfully.\n"),einfile);
	                 }
                         else {
	                  fprintf (stderr,_("Stdin was NOT encrypted successfully.\n"));
	                 }
	                }
	                
	                return_val+=x;
		}

   } /* the main loop */

return (return_val);

}




/* UNIX CRYPT Encryption */

int encrypt_ucrypt(char *fromfile,char *tofile,char *key)
{
word32 plaintext[2]; /* 64 bit */
int ch=0,how=8; /* how needs to be initialized to 8 */
char keyword[13]; 
char *tmp;
FILE *TOF;
FILE *FROMF;

/* Crypt does not care about these */
mode=2;
bit7_flag=BITS8;


/* open files */
if (stream_flag==TRUE) {
	FROMF=stdin;
	TOF=stdout;
}
else {

	FROMF=fopen(fromfile,"r");
	if (FROMF==NULL) {perror("fopen");return 1;}
	TOF=fopen(tofile,"w");
	if (TOF==NULL) {perror("fopen");return 1;}
}

        bzero(keyword,sizeof(keyword));

	if (key==NULL) 	{
          tmp=get_password(8,bit7_flag,DECRYPT,type);
          if (tmp==NULL) return 1;

          memcpy(keyword,tmp,strlen(tmp));

	}
	else {
           if (strlen(key)>8) {key[8]='\0'; fprintf(stderr,_("Warning: Reducing the size of the key\n"));}
	   memcpy(keyword,key,strlen(key)); /* Copy the 64 bits in key */
	}


if (quiet==FALSE) show_mode(ENCRYPT,type,mode,tofile,bit7_flag); 


if (unix_setup(keyword)==1) {fprintf(stderr,_("Cannot encrypt key\n"));return 1; }/* init the crypt */

do
{
/* else read the first 1 byte of the file and stores the to plaintext */
 
                how=fread(plaintext, 1, sizeof(plaintext), FROMF);
                if (how==0) {
                 if (feof(FROMF)!=0) {
                  ch=1;
                 }
                 else {
                  perror("fread");
                  return 1;
                 }
                }
                   
		unix_crypt(keyword,plaintext,how,0);
                
                if (ch==0)
		 if (fwrite(plaintext,1,how,TOF)==0) {perror("fwrite"); return(1);}

}
while(ch==0);

/* close files */
   fclose(TOF);
   fclose(FROMF);

return 0;
}













/* General Encryption */

int encrypt_general(int algorithm, char *fromfile,char *tofile,char *key)
{
unsigned char counter=0;
word32 fcrc32;
int i=0,j=0,ch=0,start=0,how=0;
char *tmp,*copychar;
unsigned int len=0;
FILE *RTOF;
FILE *FROMF;
int keysize=get_key_size(algorithm);
int blocksize=get_block_size(algorithm);

word32 *IV=malloc(blocksize);
word32 *keyword=calloc(keysize,1); 
word32 *ciphertext=malloc(blocksize);
word32 *ciphertextcbc=malloc(blocksize);
FILE * TOF; 

 TOF=tmpfile();
 
 /* Initialisation Vector */
 srand(time(0));

/* Random number generator */

 for (i=0;i<blocksize/4;i++) {
  IV[i] = RAND32 ;
 }


/* open files */
  if (stream_flag==TRUE) {
	FROMF=stdin;
	RTOF=stdout;
  }
  else {
	FROMF=fopen(fromfile,"r");
	if (FROMF==NULL) {perror("fopen");return 1;}

	RTOF=fopen(tofile,"w");
	if (RTOF==NULL) {perror("fopen");return 1;}
  }



  if (bare_flag==FALSE) {
    write_file_head( fileno((FILE*)TOF), type, mode, bit7_flag);
  }
//  fseek(TOF, blocksize, SEEK_CUR); /* move blocksize bytes */
write(fileno((FILE*)TOF),ciphertext,blocksize);

	if (key==NULL) 	{
          tmp=get_password( keysize, bit7_flag, ENCRYPT, algorithm );
          if (tmp==NULL) return 1;
          len=strlen(tmp);

          if (len > keysize) len=keysize;
          memcpy(keyword, tmp, len);
                
	}
	else {

           if (bit7_flag==BITS8) {
               len=strlen(key);

               if (len>keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memcpy(keyword, key, len);
           }
           else { /* 7bit mode */
               strip8bit(key, strlen(key));
               len=strlen(key);
               if (len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memcpy(keyword, key, len);
           }           
	}


 if (quiet==FALSE) show_mode(ENCRYPT,algorithm,mode,tofile,bit7_flag);

 if (algorithm != BLOWFISH) {
   len=keysize; /* Only Blowfish has non-fixed key */
 }
 else { /* blowfish */
   if (len<2) {
    fprintf(stderr, _("Too small key for this algorithm. Aborting.\n"));
    return 1;
    }
 }

 init_mcrypt(algorithm,keyword,len);
 if (bare_flag==FALSE) clear_crc32();


/* Encryption Starts here */

if (mode==CBC) {
  do
  {

    /* If first time use the Init. vector */
      if (start==0) {
        memcpy(ciphertext,IV,blocksize);
        start=1;
      }
      else {

     /* else read the first n bytes of the file and store to ciphertext */
 
                   how=fread(ciphertext, 1, blocksize,FROMF);
 	           if (how < blocksize) {

                      if ( how ==0 && feof(FROMF)==0) {
                         perror("fread"); 
                         return 1;
                      }
                   
		      counter=(unsigned char) how;
                      ch=1;
                   }

       /* crc32 */
        if (bare_flag==FALSE) crc32(ciphertext, how);

       /* for cbc xor the plaintext with the old ciphertext block */
          for(j=0; j<blocksize/4; j++)
            ciphertext[j] ^= ciphertextcbc[j];

      }


     mcrypt(algorithm, keyword, len, ciphertext);

     /* for cbc keep the old ciphertext */
     memcpy(ciphertextcbc,ciphertext,blocksize);

         
     if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}
      if (ch==1) if (fwrite(&counter, 1, sizeof(counter), TOF) == 0) {perror("fwrite"); return 1;}
  }
  while(ch==0);

}
else { /* mode==ECB */

  do
  {

  /* else read the first n bytes of the file and store to ciphertext */
 
                   how=fread(ciphertext,1,blocksize,FROMF);

  	           if (how<blocksize) {
                    if ( how ==0 && feof(FROMF)==0) {
                       perror("fread"); 
                       return 1;
                    }

		    counter=((unsigned char) how);
                    ch=1;
                   }



  /* crc32 */
   if (bare_flag==FALSE) crc32(ciphertext, how);

   mcrypt(algorithm, keyword, len, ciphertext);

         
    if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}
    if (ch==1) {
      if (fwrite(&counter, 1, sizeof(counter), TOF) == 0) {perror("fwrite"); return 1;}
    }

  }
  while(ch==0);

} /* if mode=xy */

 if (bare_flag==FALSE) {
    /* Put the crc32 in byte 6 */

#ifdef WORDS_BIGENDIAN
   fcrc32=get_crc32();
#else
   fcrc32=byteswap(get_crc32());
#endif   

/* encrypt the crc32, but first put some random data there 
 */
   for(j=0; j<blocksize/4; j++)
     ciphertext[j] = RAND32;
   memcpy(ciphertext,&fcrc32,sizeof(fcrc32));
   mcrypt(algorithm, keyword, len, ciphertext);
   fseek(TOF,6,SEEK_SET);
   if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}

 }

/* Copy the temporary to RTOF */
   fseek(TOF,0,SEEK_SET);

 copychar=malloc(4096);

 do {
    how=fread(copychar, 1, 4096, TOF);
    fwrite(copychar, how, 1, RTOF);
 } while ( how!=0 );

 free(copychar);
/* End of copy */
   
/* close files */
    fclose(TOF);

    end_mcrypt(algorithm);
  
    fclose(RTOF);
    fclose(FROMF);

    free(IV);
    free(keyword); 
    free(ciphertext);
    free(ciphertextcbc);


  return 0;
}





/* General Decryption */

int decrypt_general(int algorithm, char *fromfile,char *tofile,char *key)
{
word32 fcrc32, newcrc32;
unsigned char counter=0;
int i=0,j=0,ch=0,start=0;
char *tmp;
int keysize=get_key_size(algorithm);
int blocksize=get_block_size(algorithm);

word32 *ciphertext_old=malloc(blocksize);
word32 *buffer=malloc(blocksize);
word32 *ciphertext=malloc(blocksize);
word32 *ciphertext_orig=malloc(blocksize);
word32 *keyword=calloc(1,keysize);

unsigned int len=0;

FILE *RTOF;
FILE *FROMF;


/* open files */
if (stream_flag==TRUE) {
	FROMF=stdin;
	RTOF=stdout;
}
else {

	FROMF=fopen(fromfile,"r");
	if (FROMF==NULL) {perror("fopen");return 1;}
	RTOF=fopen(tofile,"w");
	if (RTOF==NULL) {perror("fopen");return 1;}

        if (bare_flag==FALSE) fseek( FROMF, 6, SEEK_CUR);
        /* In streams this has been done when checking for headers. */
}


  
	if (key==NULL) {
          tmp=get_password(keysize,bit7_flag,DECRYPT,algorithm);
          if (tmp==NULL) return 1;
          len=strlen(tmp);
                              
          if (len>keysize) len=keysize;
          memcpy(keyword, tmp, len);

	}
	else {
            if (bit7_flag==BITS8) {
              len=strlen(key);
              if (len>keysize) {
                 fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                 len=keysize;
              }
              memcpy(keyword, key, len);
            }
            else { /* 7bit mode */
               strip8bit(key,strlen(key));
               len=strlen(key);
               if (len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memcpy(keyword, key, len);
            }          
        }

if (quiet==FALSE) show_mode(DECRYPT,algorithm,mode,tofile,bit7_flag);


 if (algorithm!=BLOWFISH) {
  len=keysize;
 }
 else { /* blowfish */
   if (len<2) {
    fprintf(stderr, _("Too small key for this algorithm. Aborting.\n"));
    return 1;
    }
 }
 
 init_mcrypt(algorithm,keyword,len);

 if (bare_flag==FALSE) clear_crc32();

/* Decrypt CRC32 stored in file */
 if (bare_flag==FALSE) {

    /* Read CRC32 */
   fread(ciphertext, 1, blocksize, FROMF);
   mdecrypt(algorithm, keyword, len ,ciphertext);
   memcpy(&fcrc32, ciphertext, sizeof(fcrc32));
#ifndef WORDS_BIGENDIAN
   fcrc32=byteswap(fcrc32);
#endif

 }


/* decryption starts here */
 do
 {

  /* reads the first n bytes of the file and stores the to ciphertext */
  /* /4 is here because word32 is 4 bytes */
  
        for (i=0;i<blocksize/4;i++) { 
           if(ch!=0) break;
           if ((fread(&ciphertext[i], 1, sizeof(ciphertext[i]),FROMF)==0) && (feof(FROMF)==0)) {perror("fread"); return 1;}
            
           if (feof(FROMF)!=0) {
            ch=1;
            memcpy(&counter, &ciphertext[i], sizeof(counter));
            if (counter >= blocksize) {fprintf(stderr,_("Incorrect file type\n")); return 1;}
            clearerr(FROMF);
           }
         }

         /* Decrypt the ciphertext */

        memcpy(ciphertext_orig,ciphertext,blocksize); /* keep backup */


        mdecrypt(algorithm, keyword, len, ciphertext);
	
/* if cbc: xor the new plaintext with the old ciphertext */
        if (mode==CBC && start>0) {
          for(j=0; j<blocksize/4; j++) {
            ciphertext[j] ^= ciphertext_old[j];
          }
        }

        memcpy(ciphertext_old,ciphertext_orig,blocksize);


/* Buffer isn't immediately written here. It waits a round to do
 * so we can keep track of the end of file garbage and the IV at the begining
 */

         if (start>1 || mode==ECB) {
 
		if (ch==1) {
                  if (counter==0) break;
		  if (fwrite(buffer,(int)counter,1,RTOF)==0) {perror("fwrite"); return 1;}
  		   /* CRC32 */
          	  if (bare_flag==FALSE) crc32(buffer, (int)counter);

		}
		else {
		    if (mode!=1 || start!=0) {
   		      if (fwrite(buffer,blocksize,1,RTOF)==0) {perror("fwrite"); return 1;}
                       /* CRC32 */
                      if (bare_flag==FALSE) crc32(buffer, blocksize);

   		    }
                }
         }



         memcpy(buffer,ciphertext,blocksize);  /* copy the plaintext to buffer */

         start++; /* ok enter that functions */

 }
 while(ch==0);

/* close files */
    fclose(RTOF);
    fclose(FROMF);

    end_mcrypt(algorithm);  

  free(ciphertext_old);
  free(buffer);
  free(ciphertext);
  free(ciphertext_orig);
  free(keyword);

 if (bare_flag==FALSE) {

  newcrc32=get_crc32();

  if (newcrc32==fcrc32) {
   return 0; /* crc check passed */
  }
  else {
   fprintf(stderr, _("CRC32 check failed\n"));
   return 1; /* CRC32s Do not match */
  }
 }
else { /* no crc is stored here */
 return 0;
}
}

