/*    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sunlink.h"

/* Whether this function succeeds is highly depended on the hard disk's
 * behaviour (cache). 
 */

#ifdef HAVE_SYS_STAT_H
int safe_unlink(char * filename)
{
struct stat buf;
int x,fdes;
unsigned long i,j;
unsigned char what_to_write;

  x=stat(filename,&buf);
  if (x!=0) return x;
  if (buf.st_nlink > 1) fprintf(stderr,_("File %s has more than one hard links. Now they are unusable.\n"),filename);

  fdes=open (filename,O_WRONLY);
  if (fdes==-1) { perror("open"); return 1;}
  
  for (j=0;j<2;j++) {
       if (lseek(fdes,0,SEEK_SET)==-1) {perror("lseek"); return 1;}
      
      if (j%2==0) {
        what_to_write='\0';
      }
      else {
        what_to_write=255;
      }
    
      for (i=0;i<(buf.st_size);i++) {
         if (write(fdes,&what_to_write,1)==-1) {perror("write"); return 1;}
      }

      fsync(fdes);
  }

  srand(time(0));
  
  for (j=0;j<5;j++) {
       if (lseek(fdes,0,SEEK_SET)==-1) {perror("lseek"); return 1;}
    
      for (i=0;i<(buf.st_size);i++) {
         what_to_write=rand()%255; /* Not too random... */
         if (write(fdes,&what_to_write,1)==-1) {perror("write"); return 1;}
      }

      fsync(fdes);
  }
  
  close(fdes);
  unlink(filename);

  return 0;
  
}
#endif
