#include <config.h>

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
# include <stdio.h>
#endif

#include <time.h>
#include "getopt.h"

#ifndef FUNCTIONS_H
# define FUNCTIONS_H
# include "functions.h"
#endif


#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) gettext (String) 
#else
# define _(String) (String) 
#endif

#ifdef HAVE_UTIME_H
# include <utime.h>
#endif


/* for open */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/* defines */
#define BITS7 1
#define BITS8 0

#define TRUE 1
#define FALSE 0

#define NO_TYPE 999

#define CBC 0
#define ECB 1
#define CFB 2

#define ENCRYPT 0
#define DECRYPT 1

#define CRYPT 5

#if SIZEOF_UNSIGNED_LONG_INT == 4
 typedef unsigned long word32;
#elif SIZEOF_UNSIGNED_INT == 4
 typedef unsigned int word32;
#else
# error "Cannot find a 32 bit integer in your system, sorry."
#endif

#if SIZEOF_UNSIGNED_INT == 2
 typedef unsigned int word16;
#elif SIZEOF_UNSIGNED_SHORT_INT == 2
 typedef unsigned short word16;
#else 
# error "Cannot find a 16 bit integer in your system, sorry."
#endif

#if SIZEOF_UNSIGNED_CHAR == 1
 typedef unsigned char word8; 
#else
# error "Cannot find an 8 bit char in your system, sorry."
#endif

/* originally was defined in 3way.c */
#ifndef HAVE_DEV_RANDOM
# define RAND32 (word32) ((word32)rand() << 17 ^ (word32)rand() << 9 ^ rand())
# define SRAND32 RAND32
# define RAND8 (word8) ((word8)rand() << 4 ^ (word8)rand() << 2 ^ rand())
# define SRAND8 RAND8
#else
# define RAND32 get_rand32()
# define RAND8 get_rand8()
# define SRAND32 get_safe_rand32()
# define SRAND8 get_safe_rand8()
#endif

#ifndef HAVE_MEMMOVE
# ifdef HAVE_BCOPY
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# else
#  error "Neither memmove nor bcopy exists on your system."
# endif
#endif

extern char *getpass();
extern char *crypt(); /* libufc */
