#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif
#include <extra.h>
#include <lcrypt.h>
#include <hex.h>
#include <bzero.h>
#include <bits.h>

void* fixkey(char * key, unsigned int* len, int bit7_flag, int hexflag,int algorithm, int quiet, int stream_flag, int enc_mode) {

char *tmp;
char* keyword;
char *tmpkey;
int keysize=get_key_size(algorithm);

  if (len!=0) {
    tmpkey=malloc(*len);
  }
  else {
    tmpkey=malloc(128);
  }

keyword=calloc(1, get_key_size(algorithm));


  if (key==NULL) 	{
    tmp=get_password( keysize, bit7_flag, enc_mode, algorithm , len);
    if (tmp==NULL) return NULL;
    *len=strlen(tmp);

    /* If specified in hex and no 7bit */
        if (hexflag==TRUE && bit7_flag==BITS8) {
           *len=hexToChar(tmp, *len);
           if (*len==-1) {
             fprintf(stderr, _("Keyword not in proper hex format\n")); 
             exit(1);
           }
        }

        if (*len > keysize) *len=keysize;
        memmove(keyword, tmp, *len);
        Bzero(tmp, *len);
	}

    else { /* Key was given on the command line */

         memmove(tmpkey, key, *len);
         
         if (bit7_flag==BITS8) { /* 8bit mode */

            /* If specified in hex */
             if (hexflag==TRUE) {
               *len=hexToChar(tmpkey, *len);

               if (*len==-1) {
                 fprintf(stderr, _("Keyword not in proper hex format\n")); 
                 exit(1);
               }
             }


             if (*len>keysize) {
                fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                *len=keysize;
             }

             memmove(keyword, tmpkey, *len);
           }

           else { /* 7bit mode / No hex here */

               *len=strip8bit(tmpkey, *len);
               if (*len > keysize && hexflag==FALSE) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  *len=keysize;
               }


               memmove(keyword, tmpkey, *len);
               Bzero(tmpkey, *len); /* key is not bzero'd because it may be used again */
           }           
	}

return keyword;

}

