/*    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sunlink.h>
#include <locks.h>
#include <random.h>

/* Whether this function succeeds is highly depended on the hard disk's
 * behaviour (cache). 
 */


int safe_unlink(char * filename)
{
#ifdef HAVE_STAT
struct stat buf;
int x;
unsigned long i,j;
unsigned char what_to_write;
FILE *fstream;


  x=stat(filename,&buf);
  if (x!=0) return x;
  if (buf.st_nlink > 1) fprintf(stderr,_("File %s has more than one hard links. Now they are unusable.\n"),filename);


  fstream=fopen( filename,"wb");
  if (fstream==NULL) { perror("fopen"); return 1;}


  
  for (j=0;j<2;j++) {
       if (fseek(fstream,0,SEEK_SET)==-1) {perror("fseek"); return 1;}
      
      if (j%2==0) {
        what_to_write='\0';
      }
      else {
        what_to_write=255;
      }
    
      for (i=0;i<(buf.st_size);i++) {
         if (fwrite( &what_to_write, 1, sizeof(what_to_write), fstream)==0) {perror("fwrite"); return 1;}
      }

      fflush(fstream);
# ifdef HAVE_FSYNC
      fsync( fileno( (FILE*) fstream) );
# endif      
  }

  for (j=0;j<5;j++) {
       if (fseek(fstream,0,SEEK_SET)==-1) {perror("fseek"); return 1;}
    
      for (i=0;i<(buf.st_size);i++) {
         what_to_write=RAND8; /* We need to be fast here */
         if (fwrite( &what_to_write, 1, sizeof(what_to_write), fstream)==0) {perror("fwrite"); return 1;}
      }

      fflush(fstream);
# ifdef HAVE_FSYNC
      fsync(fileno( (FILE*) fstream));
# endif      
  }

  unlock( fileno((FILE*)fstream) );  
  fclose(fstream);

#endif /* STAT */

/* If stat() does not exist then we just remove the file. sorry
 */
  remove(filename);
  return 0;
}

