/*
 *	"enigma.c" is in file cbw.tar from
 *	anonymous FTP host watmsg.waterloo.edu: pub/crypt/cbw.tar.Z
 *
 *	A one-rotor machine designed along the lines of Enigma
 *	but considerably trivialized.
 *
 *	A public-domain replacement for the UNIX "crypt" command.
 *      Changed to fit in mcrypt by nmav@i-net.paiko.gr
 *      Unfortunately now it is nonreentrant. (but who cares;)
 */

#include <enigma.h>
#include <bzero.h>

#define ECHO 010
#define ROTORSZ 256
#define MASK 0377
char	t1[ROTORSZ];
char	t2[ROTORSZ];
char	t3[ROTORSZ];
char	deck[ROTORSZ];
char	cbuf[13];
static int n1,n2,nr1,nr2;

int unix_setup(void *gpw)
{
	int ic, i, k, temp, len;
	unsigned random;
	long seed;
	char key[9], salt[3], *enciph;
        char *pw=gpw;

/* Just because they're static */
n1=n2=nr1=nr2=0;

        Bzero(cbuf,sizeof(cbuf));
	strncpy(cbuf, pw, 8);
	while (*pw)
		*pw++ = '\0'; 
		

	strncpy(salt, cbuf, sizeof(salt) - 1);
	strncpy(key, cbuf,sizeof(key) - 1);

        enciph = crypt(key, salt);
	len = strlen(enciph);
         
        if (len!=13) { /* cannot crypt key */ return 1; }
        memmove(cbuf,enciph,13);


	seed = 123;
	for (i=0; i<13; i++)
		seed = seed*cbuf[i] + i;
	for(i=0;i<ROTORSZ;i++) {
		t1[i] = i;
		deck[i] = i;
	}
	for(i=0;i<ROTORSZ;i++) {
		seed = 5*seed + cbuf[i%13];
		random = seed % 65521;
		k = ROTORSZ-1 - i;
		ic = (random&MASK)%(k+1);
		random >>= 8;
		temp = t1[k];
		t1[k] = t1[ic];
		t1[ic] = temp;
		if(t3[k]!=0) continue;
		ic = (random&MASK) % k;
		while(t3[ic]!=0) ic = (ic+1) % k;
		t3[k] = ic;
		t3[ic] = k;
	}
	for(i=0;i<ROTORSZ;i++)
		t2[t1[i]&MASK] = i;

return 0;
}

int unix_crypt(void *given_key,void *gtext, int textlen, int secureflg) /* 0 or 1 */
{
	int i, j;
        char *text=gtext;


  for (j=0;j<textlen;j++) {

	i=text[j];
		if (secureflg) {
			nr1 = deck[n1]&MASK;
			nr2 = deck[nr1]&MASK;
		} else {
			nr1 = n1;
		}
		i = t2[(t3[(t1[(i+nr1)&MASK]+nr2)&MASK]-nr2)&MASK]-nr1;
		text[j]=i;
		n1++;
		if(n1==ROTORSZ) {
			n1 = 0;
			n2++;
			if(n2==ROTORSZ) n2 = 0;
			if (secureflg) {
				shuffle(deck);
			} else {
				nr2 = n2;
			}
		}
    }

return 0;
}

int shuffle(char deck[])
{
	int i, ic, k, temp;
	unsigned random;
	static long seed = 123;

	for(i=0;i<ROTORSZ;i++) {
		seed = 5*seed + cbuf[i%13];
		random = seed % 65521;
		k = ROTORSZ-1 - i;
		ic = (random&MASK)%(k+1);
		temp = deck[k];
		deck[k] = deck[ic];
		deck[ic] = temp;
	}
return 0;
}
