/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif
#include <hex.h>
#include <ctype.h>

int hexToChar (void *given_chain, int len) {

 char* chain=given_chain;
 char tmp[3];
 char *tmpchain;
 int i; 


 /* The chain should have 2*n characters */
 if (len % 2 !=0) return -1;
 if (check_hex(chain, len)==-1) return -1;

 tmpchain=malloc((len/2)+1);
 
 for (i=0; i<len; i+=2) {
   strncpy( tmp, &chain[i], 2);

   tmpchain[i/2]= strtol ( tmp, (char**)NULL, 16);
 }

 strncpy( chain, tmpchain, len/2);
 chain[(len/2)]='\0';
 free(tmpchain);

 return len/2;
}


int check_hex(char *given_chain, int len) {
 int i;

 for (i=0; i<len;i++)
  if ( isxdigit(given_chain[i])==0 ) return -1;

 return 0;
}
