/********************************************************************\
*                                                                    *
* C specification of the threeway block cipher                       *
*                                                                    *
\********************************************************************/
#include "libdefs.h"
#include "3-way.h"
#ifndef XMEMORY_H
# define XMEMORY_H
# include <xmemory.h>
#endif

#define   STRT_E   0x0b0b /* round constant of first encryption round */ 
#define   STRT_D   0xb1b1 /* round constant of first decryption round */
#define     NMBR       11 /* number of rounds is 11                   */


void mu(word32 *a)       /* inverts the order of the bits of a */
{
int i ;
word32 b[3] ;

b[0] = b[1] = b[2] = 0 ;
for( i=0 ; i<32 ; i++ )
   {
   b[0] <<= 1 ; b[1] <<= 1 ; b[2] <<= 1 ;
   if(a[0]&1) b[2] |= 1 ;
   if(a[1]&1) b[1] |= 1 ;
   if(a[2]&1) b[0] |= 1 ;
   a[0] >>= 1 ; a[1] >>= 1 ; a[2] >>= 1 ;
   }

a[0] = b[0] ; a[1] = b[1] ; a[2] = b[2] ;
}

void gamma(word32 *a)   /* the nonlinear step */
{
word32 b[3] ;

b[0] = a[0] ^ (a[1]|(~a[2])) ; 
b[1] = a[1] ^ (a[2]|(~a[0])) ; 
b[2] = a[2] ^ (a[0]|(~a[1])) ; 

a[0] = b[0] ; a[1] = b[1] ; a[2] = b[2] ;
}


void theta(word32 *a)    /* the linear step */
{
word32 b[3];

b[0] = a[0] ^  (a[0]>>16) ^ (a[1]<<16) ^     (a[1]>>16) ^ (a[2]<<16) ^
               (a[1]>>24) ^ (a[2]<<8)  ^     (a[2]>>8)  ^ (a[0]<<24) ^
               (a[2]>>16) ^ (a[0]<<16) ^     (a[2]>>24) ^ (a[0]<<8)  ;
b[1] = a[1] ^  (a[1]>>16) ^ (a[2]<<16) ^     (a[2]>>16) ^ (a[0]<<16) ^
               (a[2]>>24) ^ (a[0]<<8)  ^     (a[0]>>8)  ^ (a[1]<<24) ^
               (a[0]>>16) ^ (a[1]<<16) ^     (a[0]>>24) ^ (a[1]<<8)  ;
b[2] = a[2] ^  (a[2]>>16) ^ (a[0]<<16) ^     (a[0]>>16) ^ (a[1]<<16) ^
               (a[0]>>24) ^ (a[1]<<8)  ^     (a[1]>>8)  ^ (a[2]<<24) ^
               (a[1]>>16) ^ (a[2]<<16) ^     (a[1]>>24) ^ (a[2]<<8)  ;

a[0] = b[0] ;      a[1] = b[1] ;      a[2] = b[2] ;
}

void pi_1(word32 *a)   
{
a[0] = (a[0]>>10) ^ (a[0]<<22);  
a[2] = (a[2]<<1)  ^ (a[2]>>31);
}

void pi_2(word32 *a)   
{
a[0] = (a[0]<<1)  ^ (a[0]>>31);
a[2] = (a[2]>>10) ^ (a[2]<<22);
}

void rho(word32 *a)    /* the round function       */
{
theta(a) ; 
pi_1(a) ; 
gamma(a) ; 
pi_2(a) ;
}

void rndcon_gen(word32 strt,word32 *rtab)
{                           /* generates the round constants */
int i ;

for(i=0 ; i<=NMBR ; i++ )
   {
   rtab[i] = strt ;
   strt <<= 1 ; 
   if( strt&0x10000 ) strt ^= 0x11011 ;
   }
}

void en3way(word32 *ta, word32 *tk)
{
int i ;
word32 rcon[NMBR+1] ;
word32 a[3],k[3];

/* Added to make it compatible with bigendian machines
 * --nikos
 */

#ifndef WORDS_BIGENDIAN
  a[0]=byteswap(ta[0]);
  a[1]=byteswap(ta[1]);
  a[2]=byteswap(ta[2]);
  k[0] = byteswap(tk[0]); 
  k[1] = byteswap(tk[1]); 
  k[2] = byteswap(tk[2]); 
#else
  a[0]=ta[0];
  a[1]=ta[1];
  a[2]=ta[2];
  k[0] = (tk[0]); 
  k[1] = (tk[1]); 
  k[2] = (tk[2]); 
#endif

rndcon_gen(STRT_E,rcon) ; 
for( i=0 ; i<NMBR ; i++ )   
   {
   a[0] ^= k[0] ^ (rcon[i]<<16) ; 
   a[1] ^= k[1] ; 
   a[2] ^= k[2] ^ rcon[i] ;
   rho(a) ;
   }
a[0] ^= k[0] ^ (rcon[NMBR]<<16) ; 
a[1] ^= k[1] ; 
a[2] ^= k[2] ^ rcon[NMBR] ;
theta(a) ;

#ifndef WORDS_BIGENDIAN
  ta[0]=byteswap(a[0]);
  ta[1]=byteswap(a[1]);
  ta[2]=byteswap(a[2]);
#else
  ta[0]=a[0];
  ta[1]=a[1];
  ta[2]=a[2];
#endif

}


void de3way(word32 *ta, word32 *k)
{             
int i ;
word32 ki[3] ;          /* the `inverse' key             */
word32 rcon[NMBR+1] ;   /* the `inverse' round constants */
word32 a[3];

#ifndef WORDS_BIGENDIAN
  a[0]=byteswap(ta[0]);
  a[1]=byteswap(ta[1]);
  a[2]=byteswap(ta[2]);
  ki[0] = byteswap(k[0]); 
  ki[1] = byteswap(k[1]); 
  ki[2] = byteswap(k[2]); 
#else
  a[0]=ta[0];
  a[1]=ta[1];
  a[2]=ta[2];
  ki[0] = k[0]; 
  ki[1] = k[1]; 
  ki[2] = k[2]; 
#endif

theta(ki) ;
mu(ki) ;

rndcon_gen(STRT_D,rcon) ; 

mu(a) ;
for( i=0 ; i<NMBR ; i++ )
   {
   a[0] ^= ki[0] ^ (rcon[i]<<16) ; 
   a[1] ^= ki[1] ; 
   a[2] ^= ki[2] ^ rcon[i] ;
   rho(a) ;
   }
a[0] ^= ki[0] ^ (rcon[NMBR]<<16) ; 
a[1] ^= ki[1] ; 
a[2] ^= ki[2] ^ rcon[NMBR] ;
theta(a) ;
mu(a) ;

#ifndef WORDS_BIGENDIAN
  ta[0]=byteswap(a[0]);
  ta[1]=byteswap(a[1]);
  ta[2]=byteswap(a[2]);

#else
  ta[0]=a[0];
  ta[1]=a[1];
  ta[2]=a[2];
#endif

}

