/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LIBDEFS_H
# define LIBDEFS_H
# include <libdefs.h>
#endif

#include <bzero.h>
#include <xmemory.h>

/* Byte swap a 32bit integer */
word32 byteswap(word32 x)
{
	register char *cp,tmp;

	cp = (char *)&x;
	tmp = cp[3];
	cp[3] = cp[0];
	cp[0] = tmp;

	tmp = cp[2];
	cp[2] = cp[1];
	cp[1] = tmp;

	return x;
}


/* memory allocation */

void *mxmalloc(size_t size) {
char *x;

 x=malloc(size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(2);
  x=malloc(size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;
}

void *mxcalloc(size_t nmemb, size_t size) {
char *x;

 x=calloc(nmemb, size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(2);
  x=calloc(nmemb, size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;

}

void *mxrealloc(void *ptr, size_t size) {
char *x;

 x=realloc(ptr, size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(2);
  x=realloc(ptr, size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;

}


/* expands the one keyword to three (for tripleDES)
 */
int BreakToThree(void * key, unsigned int keylen, void * keyword1, void * keyword2, void * keyword3)
{
unsigned int i;
unsigned char *key_buf;
char *tmpkey=key;
key_buf=mxcalloc(1, 24);

/* Copy the key into keybuf (the rest is padded) */

 for (i=0;i<keylen;i++) {
   memmove (&key_buf[i], &tmpkey[i], 1);
 }

  memmove(keyword1,&key_buf[0],8); 
  memmove(keyword2,&key_buf[8],8); 
  memmove(keyword3,&key_buf[16],8); 

  free(key_buf);

  return 0;

}
