/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Some functions that didn't fit elsewhere */

#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif

#include <lcrypt.h>
#include <bzero.h>
#include "extra.h"
#include "bits.h"
#include "locks.h"
#include <errors.h>
#include <getpass.h>

extern char* outfile;
extern int stream_flag;
extern int cleanDelete;



char * my_getpass(char * prt) {
char *atmp;
char ztmp[128];
char *btmp;

   atmp=getpass(prt);

   Bzero(ztmp,sizeof(ztmp));
   strncat(ztmp,atmp,127);

   btmp=getpass(_("Re-Enter key: "));
   
  if (strcmp(ztmp,btmp)!=0) {
     fprintf(stderr,_("Keywords do not match or they are too long.\n"));
     return NULL;
  }

 return btmp;
}

char * get_password(int numofchar,int bitmode,int mode,int type, unsigned int* len)
{
int x=0;
char *tmp;
char msg[100];

  if (bitmode==0) {
   sprintf(msg,_("Enter key (%d chars): "),numofchar);

   if (mode==ENCRYPT) {tmp=my_getpass(msg);} else {tmp=getpass(msg);}
/*   if (strncmp(tmp,"\0",1)==0) return NULL; */
   if(tmp==NULL) return NULL;

   if ((strlen(tmp) < numofchar) && (type!=BLOWFISH)) { fprintf(stderr,_("Warning: keyword is too small for this algorithm\n")); }
   if (strlen(tmp) > numofchar) { fprintf(stderr,_("Warning: Reducing the size of keyword\n")); }
   *len=strlen(tmp);
 }
 else { /* 7bit mode */


   if ( ((numofchar*8) % 7) !=0 ) x=1;
   sprintf(msg,_("Enter key (%d chars): "),((numofchar*8)/7)+x);

   if (mode==ENCRYPT) {tmp=my_getpass(msg);} else {tmp=getpass(msg);}
/*   if (strncmp(tmp,"\0",1)==0) return NULL; */
   if(tmp==NULL) return NULL;

   if ((strlen(tmp) < (numofchar*8)/7) && (type!=BLOWFISH)) { fprintf(stderr,_("Warning: keyword is too small for this algorithm\n")); }
   if (strlen(tmp) > ((numofchar*8)/7)+x) { fprintf(stderr,_("Warning: Reducing the size of keyword\n")); }

   *len=strip8bit(tmp,strlen(tmp));
}

return tmp;

}


int show_mode(int ende, int stype,int smode,char *output,int bitmode)
{
char *x=get_algorithms_name(stype);


 fprintf (stderr,_( "Algorithm: %s\n"),x);
 free(x); 
   
 if (stype!=CRYPT) {
   switch(smode) {
    case CBC:
     fprintf (stderr,_( "Mode: CBC\n"));
     break;
    case ECB:
     fprintf (stderr,_( "Mode: ECB\n"));
     break;
    case CFB:
     fprintf (stderr,_( "Mode: CFB\n"));
     break;
   }
 }

  switch (bitmode) {
   case BITS7:
    fprintf (stderr,_( "Keyword Bit Mode: 7bits/char\n"));
    break;
   case BITS8:
    fprintf (stderr,_( "Keyword Bit Mode: 8bits/char\n"));  
    break;
  }

   if (ende==ENCRYPT) {
     fprintf (stderr,_( "Crypting to %s ...\n"),output);
   }
   else {
     fprintf (stderr, _("Decrypting to %s ...\n"),output);
   }
  
return 0;  
}


#ifdef HAVE_STAT

int check_file(char * filename) {
struct stat ostat;

  if (stat(filename,&ostat) == 0) {
    return 1; /* exists */
  }
  else {
    return 0; /* ok */
  }


}

#endif


int check_file_head(char * filename, unsigned int *algorithm, unsigned int *mode, unsigned int *bit7_flag, unsigned int stream_flag)
{
FILE *fstream;
char buf[6];

 if (stream_flag==TRUE) {
  fstream=(FILE *) stdin;
 }
 else {
  fstream=fopen(filename,"r");
  if (read_lock( fileno((FILE*)fstream))==-1) return (-1);
 } 

 fread(buf, 1, 6, fstream);

 if (buf[0]=='\0' && buf[1]=='m' && buf[2]=='\0') {
  /* headers are ok */

  *algorithm=(unsigned int) buf[3];
  *mode=(unsigned int) buf[4]; 
  *bit7_flag=(unsigned int) buf[5];

/* 6 To 9 are crc32 */

  if (stream_flag==FALSE) { fflush(fstream); unlock( fileno((FILE*)fstream)); fclose(fstream); }
  return 0;
 }  
 else { /* No headers present */
   if (stream_flag==FALSE) { 
    fflush(fstream);
    unlock( fileno((FILE*)fstream));
    fclose(fstream);
    return 1;
   }
   else { /* restart the stream so we will not loose important data */
     if (fseek( fstream, 0, SEEK_SET)==-1) {
       perror("fseek");
       fprintf(stderr,_("Unable to get algorithm information. Use the --bare flag and specify the algorithm manualy.\n"));
       exit(-1);
     }
     else {
       return 1;
     }
     
   }
 }

}


int write_file_head(int filedes, unsigned int algorithm, unsigned int mode, unsigned int bit7_flag)
{
unsigned char buf[6];

 buf[0]='\0';
 buf[1]='m';
 buf[2]='\0';
 buf[3]=(unsigned char) algorithm;
 buf[4]=(unsigned char) mode; 
 buf[5]=(unsigned char) bit7_flag;

/* 6 to 9 are crc32 */

  if (write(filedes, buf, 6)==6) {
   return 0;
  }
  else {
   return 1;
  }
   
}

#ifdef HAVE_STAT
# ifdef HAVE_UTIME
void copyDate ( char *srcName, char *dstName )
{
   int retVal;
   struct stat statBuf;
   struct utimbuf uTimBuf;
            
   retVal = stat ( srcName, &statBuf );
   if (retVal==-1) perror("stat");

   uTimBuf.actime = statBuf.st_atime;
   uTimBuf.modtime = statBuf.st_mtime;
                        
   retVal = utime ( dstName, &uTimBuf );
   if (retVal==-1) perror("utime");
}
# endif


int is_normal_file(char *filename)
{
   struct stat statBuf;

# ifdef HAVE_LSTAT /* Do not treat symlinks as regular files */
   if (lstat ( filename, &statBuf )!=0) return FALSE;
# else
   if (stat ( filename, &statBuf )!=0) return FALSE;
# endif

   if ( S_ISREG(statBuf.st_mode)!=0 ) {
     return TRUE;
   }
   else {
     return FALSE;
   }

}

#endif

void shandler(int signal)
{

 fprintf(stderr, _("Signal %d caught. Exiting.\n"),signal);
 cleanUp();
 exit(-1);

}

void snhandler(int signal)
{

 fprintf(stderr, _("\nSignal %d caught. Exiting.\n"),signal);
 cleanUp();
 exit(-1);

}

void cleanUp() {

 fflush(NULL);
 if (stream_flag==FALSE && cleanDelete==TRUE) remove(outfile); /* Delete the file we were writing to */

}


char** read_key_file(char * file, int* num) {

  FILE* FROMF;
  char keyword[128], **keys=NULL;
  int x=0;

  FROMF=fopen(file,"r");
  if (FROMF==NULL) {
    fprintf(stderr, _("Keyfile could not be opened. Ignoring it.\n"));
    return NULL;
  }

  if (read_lock( fileno((FILE*)FROMF))==-1) {
    fprintf(stderr, _("Keyfile could not be locked. Ignoring it.\n"));
    return NULL;
  }


  while (fgets( keyword, 128, FROMF)!=NULL) {
    x++;
    keys=realloc(keys, x*sizeof(char*));
    keys[x-1]=malloc(strlen(keyword)+1);
/* Remove newline */
    if (keyword[strlen(keyword)-1]=='\n') keyword[strlen(keyword)-1]='\0';
    strcpy( keys[x-1], keyword);

  }

  *num=x;

  unlock( fileno((FILE*)FROMF));
  return keys;

}

#ifdef HAVE_GETPWUID
char *get_cfile(int uid, char* cfile) {

char *home;
struct passwd* pwd;

  pwd=getpwuid(uid);
  home=malloc(strlen(pwd->pw_dir)+strlen(cfile)+2);
  strcpy(home, pwd->pw_dir);
  strcat(home, "/");
  strcat(home, cfile);
  
  return home;

}
#endif


int ask_overwrite(char *name, char * file) {
char x[2];

#ifdef HAVE_SIGNAL_H
 Signal( SIGINT , snhandler);
 Signal( SIGQUIT, snhandler);
 Signal( SIGSEGV, snhandler);
 Signal( SIGPIPE, snhandler);
 Signal( SIGTERM, snhandler);
 Signal( SIGHUP , snhandler);
#endif
         

 fprintf(stderr, _("%s: %s already exists; do you wish to overwrite (y or n)?"), name, file);
 x[0]=getc(stdin);
 x[1]='\0';

#ifdef HAVE_SIGNAL_H
 Signal( SIGINT , shandler);
 Signal( SIGQUIT, shandler);
 Signal( SIGSEGV, shandler);
 Signal( SIGPIPE, shandler);
 Signal( SIGTERM, shandler);
 Signal( SIGHUP , shandler);
#endif

 if (strncmp(x,"y",1)==0 || strncmp(x,"Y",1)==0) {
  return TRUE;
 }
 else {
  return FALSE;
 }

}
