/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif
#include "bits.h"
#include <bzero.h>

/* Bit manipulation set/get. I know this are not fast and good but at least
 * they work. Assuming that if a char=1 then his bits are 00000001.
 */

unsigned int m_getbit(unsigned char bit,unsigned int which)
{

  bit=bit << which;
  bit=bit >> which;
  bit=bit >> (7-which);

return bit;

}

unsigned char m_setbit(unsigned char bit,unsigned int which,unsigned int what)
{

 switch (which) {
       
     case 7:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 1);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~1));              
            }
         }
        break;

     case 6:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 2);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~2));
            }
         }
        break;         

     case 5:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 4);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~4));              
            }
         }       
        break;

     case 4:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 8);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~8));              
            }
         }       
        break;

     case 3:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 16);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~16));              
            }
         }       
        break;

     case 2:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 32);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~32));              
            }
         }       
        break;

     case 1:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 64);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~64));              
            }
         }       
        break;

     case 0:
         if (what!=0) {
            if (m_getbit(bit,which)==0) {
              return (bit | 128);
            }
            else {
              return bit;
            }
         }
         else {
            if (m_getbit(bit,which)==0) {
              return bit;
            }
            else {
              return (bit & (~128));              
            }
         }       
        break;
       default:
         return 0;

 }
}

/* Removes the 8th bit of every byte in a string */
int strip8bit(char * chain,unsigned int sizeofchain)
{
  char tmpchain[128];
  int i,j,x,y;


  Bzero(tmpchain,sizeof(tmpchain));
    
  y=0;
  x=1;
  
  for (i=0;i<sizeofchain;i++) {
    for (j=0;j<8;j++) {
      tmpchain[i]=m_setbit(tmpchain[i], j, m_getbit(chain[y],x));
      if (x==7) { x=0; y++; }
      x++;
    }
                /* I think this is not needed but... */
    if (y >= sizeofchain) break; 
  }


Bzero(chain,sizeofchain);
strncpy(chain,tmpchain,i);

return i;

}


