#include <config.h>

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
# include <stdio.h>
#endif

#include <time.h>
#include "getopt.h"

#ifndef FUNCTIONS_H
# define FUNCTIONS_H
# include "functions.h"
#endif

#ifdef BZIP2
# define ZIP
#endif

#ifdef GZIP
# define ZIP
#endif



#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) gettext (String) 
#else
# define _(String) (String) 
#endif

#ifdef HAVE_UTIME_H
# include <utime.h>
#endif

/* for open */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifdef HAVE_PWD_H
# include <pwd.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/* defines */
#define BITS7 1
#define BITS8 0

#define TRUE 1
#define FALSE 0

#define NO_TYPE 999

#define CBC 0
#define ECB 1
#define CFB 2
#define OFB 3

#define MAX_ALGO 110
#define MAX_MODE 4

#define ENCRYPT 0
#define DECRYPT 1

#if SIZEOF_UNSIGNED_LONG_INT == 4
 typedef unsigned long word32;
 typedef signed long sword32;
#elif SIZEOF_UNSIGNED_INT == 4
 typedef unsigned int word32;
 typedef signed int sword32;
#else
# error "Cannot find a 32 bit integer in your system, sorry."
#endif

#if SIZEOF_UNSIGNED_INT == 2
 typedef unsigned int word16;
#elif SIZEOF_UNSIGNED_SHORT_INT == 2
 typedef unsigned short word16;
#else 
# error "Cannot find a 16 bit integer in your system, sorry."
#endif

#if SIZEOF_UNSIGNED_CHAR == 1
 typedef unsigned char word8; 
#else
# error "Cannot find an 8 bit char in your system, sorry."
#endif

/* originally was defined in 3way.c */
#ifndef HAVE_DEV_RANDOM
# define RAND32 (word32) ((word32)rand() << 17 ^ (word32)rand() << 9 ^ rand())
# define SRAND32 RAND32
# define RAND8 (word8) ((word8)rand() << 4 ^ (word8)rand() << 2 ^ rand())
# define SRAND8 RAND8
#else
# define RAND32 get_rand32()
# define RAND8 get_rand8()
# define SRAND32 get_safe_rand32()
# define SRAND8 get_safe_rand8()
#endif

#ifndef HAVE_MEMMOVE
# ifdef HAVE_BCOPY
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# else
#  error "Neither memmove nor bcopy exists on your system."
# endif
#endif

/*extern char *getpass();*/
extern char *crypt(); /* libufc */

#if HAVE_TERMIOS_H
# include <termios.h>
# define STTY(fd, termio) tcsetattr(fd, TCSANOW, termio)
# define GTTY(fd, termio) tcgetattr(fd, termio)
# define TERMIO struct termios
# define USE_TERMIOS
#elif HAVE_TERMIO_H
# include <sys/ioctl.h>
# include <termio.h>
# define STTY(fd, termio) ioctl(fd, TCSETA, termio)
# define GTTY(fd, termio) ioctl(fd, TCGETA, termio)
# define TEMRIO struct termio
# define USE_TERMIO
#elif HAVE_SGTTY_H
# include <sgtty.h>
# define STTY(fd, termio) stty(fd, termio)
# define GTTY(fd, termio) gtty(fd, termio)
# define TERMIO struct sgttyb
# define USE_SGTTY
#endif
