/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif
#include "bits.h"
#include <bzero.h>
#include <extra.h> /* for MAX_KEY_LEN */

/* Bit manipulation set/get. I know this are not fast and good but at least
 * they work. Assuming that if a char=1 then his bits are 00000001.
 */

/* returns the which bit of fullnum */

unsigned int m_getbit(unsigned char fullnum,unsigned int which)
{

  fullnum=fullnum << which;
  fullnum=fullnum >> which;
  fullnum=fullnum >> (7-which);

return fullnum;

}

/* Sets the which bit of fullnum to what */

unsigned char m_setbit(unsigned char fullnum,unsigned int which,unsigned int what)
{

 switch (which) {
       
     case 7:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 1);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~1));              
            }
         }
        break;

     case 6:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 2);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~2));
            }
         }
        break;         

     case 5:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 4);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~4));              
            }
         }       
        break;

     case 4:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 8);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~8));              
            }
         }       
        break;

     case 3:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 16);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~16));              
            }
         }       
        break;

     case 2:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 32);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~32));              
            }
         }       
        break;

     case 1:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 64);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~64));              
            }
         }       
        break;

     case 0:
         if (what!=0) {
            if (m_getbit(fullnum,which)==0) {
              return (fullnum | 128);
            }
            else {
              return fullnum;
            }
         }
         else {
            if (m_getbit(fullnum,which)==0) {
              return fullnum;
            }
            else {
              return (fullnum & (~128));              
            }
         }       
        break;
       default:
         return 0;

 }
}

/* Removes the 8th bit of every byte in a string */
int strip8bit(char * chain,unsigned int sizeofchain)
{
  char tmpchain[MAX_KEY_LEN];
  int i,j,x,y;


  Bzero(tmpchain,sizeof(tmpchain));
    
  y=0;
  x=1;
  
  for (i=0;i<sizeofchain;i++) {
    for (j=0;j<8;j++) {
      tmpchain[i]=m_setbit(tmpchain[i], j, m_getbit(chain[y],x));
      if (x==7) { x=0; y++; }
      x++;
    }
                /* I think this is not needed but... */
    if (y >= sizeofchain) break; 
  }

 if (i>1) {
  Bzero(chain,sizeofchain);
  memmove(chain,tmpchain,i);
  chain[i]='\0';

  return i;
 }
 
 return i+1;

}



/* Removes the first 4 bits of every byte in a string */
int strip4bits(char * chain,unsigned int sizeofchain)
{
  char tmpchain[MAX_KEY_LEN];
  int i,j;


  Bzero(tmpchain, sizeof(tmpchain));
    


  for (i=0;i<sizeofchain+1;i+=2) {
      for (j=4;j<8;j++) {
/* puts the first last bits from chain[i] as the first four bits of tmpchain[i] */
          tmpchain[i/2]=m_setbit(tmpchain[i/2], j-4 , m_getbit( chain[i], j));
      }

      if (chain[i+1]=='\0') break;

      for (j=4;j<8;j++) {
/* puts the first last bits from chain[i+1] as the last four bits of tmpchain[i] */
          tmpchain[i/2]=m_setbit(tmpchain[i/2], j , m_getbit( chain[i+1], j));
      }
  
  }

  Bzero(chain,sizeofchain);

  if (sizeofchain % 2 == 0) {
    memmove( chain, tmpchain, sizeofchain/2);
    chain[sizeofchain/2]='\0';
    return (sizeofchain/2);

  } else {
    memmove( chain, tmpchain, (sizeofchain/2)+1);
    chain[(sizeofchain/2)+1]='\0';
    return ((sizeofchain/2)+1);
  }
  

}


