#include <stdio.h>

void __gaa_helpsingle(char short_name, char *name, 
	char *arg_desc, char *opt_help)
{
     int col1, col3, col4, tabsize = 3, curr;
     int i;

     col1 = 5; /* Default values */
     col3 = 30;
     col4 = 70;

     curr = 0;
     for(i = 0; i < col1; i++)
        {
        printf(" ");
        curr++;
        }
     if(short_name)
        {
        if(name && *name)
          {
            printf("-%c, ", short_name);
            curr += 4;
          }
        else
          {
            printf("-%c ", short_name);
            curr += 3;
          }
        }
     if(name && *name)
        {
          printf("--%s ", name);
          curr += 3 + strlen(name);
        }
     if(arg_desc && *arg_desc)
        {
          printf("%s ", arg_desc);
          curr += 1 + strlen(arg_desc);
        }
     if(curr >= col3)
        {
          printf("\n");
          curr = 0;
        }
     if(opt_help) /* let's print the option's help body */
        {
        const char *str = opt_help;
        while(*str)
          {
             while(curr < col3)
               {
                 printf(" ");
                 curr++;
               }
             switch(*str)
               {
                 case '\n':
                     printf("\n");
                     curr = 0;
                     break;
                 case '\t':
                     do
                        {
                        printf(" ");
                        curr++;
                        }
                     while((curr - col3) % tabsize != 0 && curr < col4);
                 case ' ':
                     if(*str == ' ')
                        {
                        curr++;
                        printf(" ");
                        }
                     for(i = 1; str[i] && str[i] != ' ' && str[i] != '\n'
                        && str[i] != '\t'; i++);
                     if(curr + i - 1 >= col4)
                        curr = col4;
                     break;
                default:
                     printf("%c", *str);
                     curr++;
               }
             if(curr >= col4)
               {
                 printf("\n");
                 curr = 0;
               }
             str++;
          }
        }
     printf("\n");
}

void gaa_help()
{
	printf("Mcrypt help\nUsage : mcrypt [options] file1 file2 ...""\n");
	__gaa_helpsingle('V', "verbose", "", "some more information is displayed.");
	__gaa_helpsingle('q', "quiet", "", "suppress some non critical warnings.");
	__gaa_helpsingle('F', "force", "", "forces output to stdout.");
	__gaa_helpsingle('r', "random", "", "Use real random data (if your system supports it).");
	__gaa_helpsingle('b', "bare", "", "Do not keep algorithm information in the encrypted""file.");
	__gaa_helpsingle('z', "gzip", "", "Compress before encryption.");
	__gaa_helpsingle('p', "bzip2", "", "Compress before encryption.");
	__gaa_helpsingle('d', "decrypt", "", "decrypts.");
	__gaa_helpsingle('x', "hex", "", "Keyword is in hex.");
	__gaa_helpsingle('i', "bit", "", "keyword bit mode (4,7 or 8).");
	__gaa_helpsingle('u', "unlink", "", "unlink the input file after""encryption/decryption.");
	__gaa_helpsingle('s', "sunlink", "", "unlink (and destroy) the input file after""encryption/decryption.");
	__gaa_helpsingle('f', "keyfile", """keyfile"" ", "file to read the keyword from.");
	__gaa_helpsingle('c', "config", """config"" ", "Use configuration file FILE.");
	__gaa_helpsingle('a', "algorithm", """algorithm"" ", "specify the encryption and decryption algorithm.""Legal parameters are: 3way, des, 3des, gost, tea,""safer64, safer128, cast128, crypt, twofish""and blowfish. (Default is blowfish)");
	__gaa_helpsingle('k', "key", """key1 key2...keyN"" ", "specify the key(s)");
	__gaa_helpsingle('m', "mode", """mode"" ", "specify the encryption and decryption mode.""CBC, ECB or CFB. CBC is the default.");
	__gaa_helpsingle('h', "help", "", "prints this help");
	__gaa_helpsingle('v', "version", "", "prints the version number");
	__gaa_helpsingle('L', "license", "", "displays license information.");

#line 100 "gaa.skel"
}
/* Copy of C area */

#line 104 "gaa.skel"
/* GAA HEADER */
#ifndef GAA_HEADER_POKY
#define GAA_HEADER_POKY

typedef struct _gaainfo gaainfo;

struct _gaainfo
{
#line 67 "mcrypt.gaa"
	char **input;
#line 66 "mcrypt.gaa"
	int size;
#line 58 "mcrypt.gaa"
	char *mode;
#line 55 "mcrypt.gaa"
	char **keys;
#line 54 "mcrypt.gaa"
	int keysize;
#line 48 "mcrypt.gaa"
	char *algorithm;
#line 45 "mcrypt.gaa"
	char *config_file;
#line 44 "mcrypt.gaa"
	int config;
#line 41 "mcrypt.gaa"
	char *keyfile;
#line 37 "mcrypt.gaa"
	int sunlink_flag;
#line 33 "mcrypt.gaa"
	int unlink_flag;
#line 30 "mcrypt.gaa"
	int bit;
#line 27 "mcrypt.gaa"
	int hexflag;
#line 24 "mcrypt.gaa"
	int ed_specified;
#line 23 "mcrypt.gaa"
	int ein;
#line 22 "mcrypt.gaa"
	int din;
#line 19 "mcrypt.gaa"
	int bzipflag;
#line 16 "mcrypt.gaa"
	int gzipflag;
#line 13 "mcrypt.gaa"
	int bare_flag;
#line 10 "mcrypt.gaa"
	int real_random_flag;
#line 7 "mcrypt.gaa"
	int force;
#line 3 "mcrypt.gaa"
	int quiet;

#line 114 "gaa.skel"
};

#ifdef __cplusplus
extern "C"
{
#endif

    int gaa(int argc, char *argv[], gaainfo *gaaval);

    void gaa_help();
    
    int gaa_file(char *name, gaainfo *gaaval);
    
#ifdef __cplusplus
}
#endif


#endif

#line 135 "gaa.skel"

/* C declarations */

#define GAAERROR    \
{                   \
gaa_error = 1;      \
return;        \
}

char *gaa_current_option;
int gaa_error = 0;

/* Generated by gaa */

#include <string.h>
#include <stdlib.h>


#define GAA_OK                       -1

#define GAA_ERROR_NOMATCH            0
#define GAA_ERROR_NOTENOUGH_ARGS     1
#define GAA_ERROR_INVALID_ARG        2
#define GAA_ERROR_UNKNOWN            3

#define GAA_NOT_AN_OPTION       0
#define GAA_WORD_OPTION         1
#define GAA_LETTER_OPTION       2
#define GAA_MULTIPLE_OPTION     3

#define GAA_REST                0
#define GAA_NB_OPTION           20
#define GAAOPTID_license	1
#define GAAOPTID_version	2
#define GAAOPTID_help	3
#define GAAOPTID_mode	4
#define GAAOPTID_key	5
#define GAAOPTID_algorithm	6
#define GAAOPTID_config	7
#define GAAOPTID_keyfile	8
#define GAAOPTID_sunlink	9
#define GAAOPTID_unlink	10
#define GAAOPTID_bit	11
#define GAAOPTID_hex	12
#define GAAOPTID_decrypt	13
#define GAAOPTID_bzip2	14
#define GAAOPTID_gzip	15
#define GAAOPTID_bare	16
#define GAAOPTID_random	17
#define GAAOPTID_force	18
#define GAAOPTID_quiet	19
#define GAAOPTID_verbose	20

#line 168 "gaa.skel"

#define GAA_CHECK1STR(a,b)      \
if(a[0] == str[0])              \
{                               \
    gaa_current_option = a;     \
    return b;                   \
}

#define GAA_CHECKSTR(a,b)                \
if(strcmp(a,str) == 0)                   \
{                                        \
    gaa_current_option = a;              \
    return b;                            \
}

#define GAA_TESTMOREARGS                                                  \
if(!OK)                                                                     \
{                                  \
while((gaa_last_non_option != gaa_index) && (gaa_arg_used[gaa_index] == 1)) \
    gaa_index++;                                                            \
if(gaa_last_non_option == gaa_index)                                        \
    return GAA_ERROR_NOTENOUGH_ARGS; \
}

#define GAA_TESTMOREOPTIONALARGS                                                  \
if(!OK) \
{ \
while((gaa_last_non_option != gaa_index) && (gaa_arg_used[gaa_index] == 1)) \
    gaa_index++;                                                            \
if(gaa_last_non_option == gaa_index)                                        \
    OK = 1; \
}

#define GAA_FILL_2ARGS(target, func)           \
target = func(GAAargv[gaa_index]);       \
gaa_arg_used[gaa_index] = 1;             \
if(gaa_error == 1)                       \
{                                        \
    gaa_error = 0;                       \
    return GAA_ERROR_INVALID_ARG;        \
} 



#define GAA_FILL(target, func, num)           \
if(!OK) \
{ \
target = func(GAAargv[gaa_index]);       \
gaa_arg_used[gaa_index] = 1;             \
if(gaa_error == 1)                       \
{                                        \
    gaa_error = 0;                       \
    return GAA_ERROR_INVALID_ARG;        \
} \
num = 1;  \
} \
else \
{ \
num = 0; \
}

#define GAA_LIST_FILL(target, func, type ,num)                      \
if(!OK) \
{ \
num = 0;                                                            \
target = malloc((gaa_last_non_option - gaa_index) * sizeof(type));  \
for(; gaa_index < gaa_last_non_option; gaa_index++)                 \
{                                                                   \
    if(gaa_arg_used[gaa_index] == 0)                                \
    {                                                               \
        GAA_FILL_2ARGS(target[num], func);                                \
        num++;                                                      \
    }                                                               \
}                                                                   \
if(num == 0)                                                        \
    return GAA_ERROR_NOTENOUGH_ARGS; \
}

#define GAA_OPTIONALLIST_FILL(target, func, type ,num)                      \
if(!OK) \
{ \
num = 0;                                                            \
target = malloc((gaa_last_non_option - gaa_index) * sizeof(type));  \
for(; gaa_index < gaa_last_non_option; gaa_index++)                 \
{                                                                   \
    if(gaa_arg_used[gaa_index] == 0)                                \
    {                                                               \
        GAA_FILL_2ARGS(target[num], func);                                \
        num++;                                                      \
    }                                                               \
} \
}

#define GAA_OBLIGAT(str)                                            \
k = 0;                                                              \
for(i = 0; i < strlen(str); i++)                                    \
{                                                                   \
    j = gaa_get_option_num(str + i, GAA_LETTER_OPTION);           \
    if(j == GAA_ERROR_NOMATCH)                                       \
    {                                                               \
        printf("Error : invalid 'obligat' set\n");                  \
        exit(-1);                                                   \
    }                                                               \
    if(opt_list[j] == 1)                                            \
        k = 1;                                                      \
}                                                                    \
if(k == 0)                                                            \
{                                                                      \
    if(strlen(str) == 1)                                                \
        printf("You must give the -%s option\n", str);                     \
    else                                                                  \
        printf("You must give at least one option of '%s'\n", str);          \
    return 0;         \
}
        
#define GAA_INCOMP(str)                                                \
k = 0;                                                              \
for(i = 0; i < strlen(str); i++)                                    \
{                                                                   \
    j = gaa_get_option_num(str + i, GAA_LETTER_OPTION);           \
    if(j == GAA_ERROR_NOMATCH)                                      \
    {                                                               \
        printf("Error : invalid 'obligat' set\n");                  \
        exit(-1);                                                   \
    }                                                               \
    if(opt_list[j] == 1)                                            \
        k++;                                                      \
}                   \
if(k > 1)                                                            \
{                                                                      \
    printf("The options '%s' are incompatible\n", str);              \
    return 0;                                                          \
}
        

char **GAAargv;
int GAAargc;
char *gaa_arg_used;
int gaa_processing_file = 0;
int inited = 0;

int gaa_getint(char *arg)
{
    int tmp;
    char a;
    if(sscanf(arg, "%d%c", &tmp, &a) != 1)
    {
        printf("Option %s : '%s' isn't an integer\n", gaa_current_option, arg);
        GAAERROR;
    }
    return tmp;
}

char gaa_getchar(char *arg)
{
    if(strlen(arg) != 1)
    {
        printf("Option %s : '%s' isn't an character\n", gaa_current_option, arg);
        GAAERROR;
    }
    return arg[0];
}

char* gaa_getstr(char *arg)
{
    return arg;
}
float gaa_getfloat(char *arg)
{
    float tmp;
    char a;
    if(sscanf(arg, "%f%c", &tmp, &a) != 1)
    {
        printf("Option %s : '%s' isn't a float number\n", gaa_current_option, arg);
        GAAERROR;
    }
    return tmp;
}
/* option structures */

struct GAAOPTION_license 
{
};

struct GAAOPTION_version 
{
};

struct GAAOPTION_help 
{
};

struct GAAOPTION_mode 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_key 
{
	char** arg1;
	int size1;
};

struct GAAOPTION_algorithm 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_config 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_keyfile 
{
	char* arg1;
	int size1;
};

struct GAAOPTION_sunlink 
{
};

struct GAAOPTION_unlink 
{
};

struct GAAOPTION_bit 
{
	int arg1;
	int size1;
};

struct GAAOPTION_hex 
{
};

struct GAAOPTION_decrypt 
{
};

struct GAAOPTION_bzip2 
{
};

struct GAAOPTION_gzip 
{
};

struct GAAOPTION_bare 
{
};

struct GAAOPTION_random 
{
};

struct GAAOPTION_force 
{
};

struct GAAOPTION_quiet 
{
};

struct GAAOPTION_verbose 
{
};
#define GAA_REST_EXISTS

struct GAAREST
{
	char** arg1;
	int size1;
};
         
#line 349 "gaa.skel"
int gaa_is_an_argument(char *str)
{
    if(str[0] != '-')
        return GAA_NOT_AN_OPTION;
    if(str[1] == 0)
        return GAA_NOT_AN_OPTION;
    if(str[1] == '-')
    {
        if(str[2] != 0)
            return GAA_WORD_OPTION;
        else
            return GAA_NOT_AN_OPTION;
    }
    if(str[2] == 0)
        return GAA_LETTER_OPTION;
    else
        return GAA_MULTIPLE_OPTION;
}

int gaa_get_option_num(char *str, int status)
{
    switch(status)
        {
        case GAA_LETTER_OPTION:
			GAA_CHECK1STR("m", GAAOPTID_mode);
			GAA_CHECK1STR("k", GAAOPTID_key);
			GAA_CHECK1STR("a", GAAOPTID_algorithm);
			GAA_CHECK1STR("c", GAAOPTID_config);
			GAA_CHECK1STR("f", GAAOPTID_keyfile);
			GAA_CHECK1STR("i", GAAOPTID_bit);
        case GAA_MULTIPLE_OPTION:
#line 375 "gaa.skel"
			GAA_CHECK1STR("L", GAAOPTID_license);
			GAA_CHECK1STR("v", GAAOPTID_version);
			GAA_CHECK1STR("h", GAAOPTID_help);
			GAA_CHECK1STR("s", GAAOPTID_sunlink);
			GAA_CHECK1STR("u", GAAOPTID_unlink);
			GAA_CHECK1STR("x", GAAOPTID_hex);
			GAA_CHECK1STR("d", GAAOPTID_decrypt);
			GAA_CHECK1STR("p", GAAOPTID_bzip2);
			GAA_CHECK1STR("z", GAAOPTID_gzip);
			GAA_CHECK1STR("b", GAAOPTID_bare);
			GAA_CHECK1STR("r", GAAOPTID_random);
			GAA_CHECK1STR("F", GAAOPTID_force);
			GAA_CHECK1STR("q", GAAOPTID_quiet);
			GAA_CHECK1STR("V", GAAOPTID_verbose);

#line 277 "gaa.skel"
        break;
        case GAA_WORD_OPTION:
			GAA_CHECKSTR("license", GAAOPTID_license);
			GAA_CHECKSTR("version", GAAOPTID_version);
			GAA_CHECKSTR("help", GAAOPTID_help);
			GAA_CHECKSTR("mode", GAAOPTID_mode);
			GAA_CHECKSTR("key", GAAOPTID_key);
			GAA_CHECKSTR("algorithm", GAAOPTID_algorithm);
			GAA_CHECKSTR("config", GAAOPTID_config);
			GAA_CHECKSTR("keyfile", GAAOPTID_keyfile);
			GAA_CHECKSTR("sunlink", GAAOPTID_sunlink);
			GAA_CHECKSTR("unlink", GAAOPTID_unlink);
			GAA_CHECKSTR("bit", GAAOPTID_bit);
			GAA_CHECKSTR("hex", GAAOPTID_hex);
			GAA_CHECKSTR("decrypt", GAAOPTID_decrypt);
			GAA_CHECKSTR("bzip2", GAAOPTID_bzip2);
			GAA_CHECKSTR("gzip", GAAOPTID_gzip);
			GAA_CHECKSTR("bare", GAAOPTID_bare);
			GAA_CHECKSTR("random", GAAOPTID_random);
			GAA_CHECKSTR("force", GAAOPTID_force);
			GAA_CHECKSTR("quiet", GAAOPTID_quiet);
			GAA_CHECKSTR("verbose", GAAOPTID_verbose);

#line 281 "gaa.skel"
	break;
        default: break;
        }
    return GAA_ERROR_NOMATCH;
}

int gaa_try(int gaa_num, int gaa_index, gaainfo *gaaval, char *opt_list)
{
    int OK = 0;
    int gaa_last_non_option;
	struct GAAOPTION_license GAATMP_license;
	struct GAAOPTION_version GAATMP_version;
	struct GAAOPTION_help GAATMP_help;
	struct GAAOPTION_mode GAATMP_mode;
	struct GAAOPTION_key GAATMP_key;
	struct GAAOPTION_algorithm GAATMP_algorithm;
	struct GAAOPTION_config GAATMP_config;
	struct GAAOPTION_keyfile GAATMP_keyfile;
	struct GAAOPTION_sunlink GAATMP_sunlink;
	struct GAAOPTION_unlink GAATMP_unlink;
	struct GAAOPTION_bit GAATMP_bit;
	struct GAAOPTION_hex GAATMP_hex;
	struct GAAOPTION_decrypt GAATMP_decrypt;
	struct GAAOPTION_bzip2 GAATMP_bzip2;
	struct GAAOPTION_gzip GAATMP_gzip;
	struct GAAOPTION_bare GAATMP_bare;
	struct GAAOPTION_random GAATMP_random;
	struct GAAOPTION_force GAATMP_force;
	struct GAAOPTION_quiet GAATMP_quiet;
	struct GAAOPTION_verbose GAATMP_verbose;

#line 393 "gaa.skel"
#ifdef GAA_REST_EXISTS
    struct GAAREST GAAREST_tmp;
#endif

    opt_list[gaa_num] = 1;
    
    for(gaa_last_non_option = gaa_index;
        (gaa_last_non_option != GAAargc) && (gaa_is_an_argument(GAAargv[gaa_last_non_option]) == GAA_NOT_AN_OPTION);
        gaa_last_non_option++);

    if(gaa_num == GAA_REST)
    {
        gaa_index = 1;
        gaa_last_non_option = GAAargc;
    }
    
    switch(gaa_num)
    {
	case GAAOPTID_license:
	OK = 0;
#line 64 "mcrypt.gaa"
{ mcrypt_license(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_version:
	OK = 0;
#line 63 "mcrypt.gaa"
{ mcrypt_version(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_help:
	OK = 0;
#line 62 "mcrypt.gaa"
{ usage(); exit(0); ;};

		return GAA_OK;
		break;
	case GAAOPTID_mode:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_mode.arg1, gaa_getstr, GAATMP_mode.size1);
		gaa_index++;
#line 59 "mcrypt.gaa"
{ gaaval->mode = GAATMP_mode.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_key:
	OK = 0;
		GAA_LIST_FILL(GAATMP_key.arg1, gaa_getstr, char*, GAATMP_key.size1);
#line 56 "mcrypt.gaa"
{ gaaval->keys = GAATMP_key.arg1; gaaval->keysize = GAATMP_key.size1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_algorithm:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_algorithm.arg1, gaa_getstr, GAATMP_algorithm.size1);
		gaa_index++;
#line 49 "mcrypt.gaa"
{ gaaval->algorithm = GAATMP_algorithm.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_config:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_config.arg1, gaa_getstr, GAATMP_config.size1);
		gaa_index++;
#line 46 "mcrypt.gaa"
{ gaaval->config=1; if (GAATMP_config.size1==1) gaaval->config_file = GAATMP_config.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_keyfile:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_keyfile.arg1, gaa_getstr, GAATMP_keyfile.size1);
		gaa_index++;
#line 42 "mcrypt.gaa"
{ gaaval->keyfile = GAATMP_keyfile.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_sunlink:
	OK = 0;
#line 38 "mcrypt.gaa"
{ gaaval->sunlink_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_unlink:
	OK = 0;
#line 34 "mcrypt.gaa"
{ gaaval->unlink_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_bit:
	OK = 0;
		GAA_TESTMOREARGS;
		GAA_FILL(GAATMP_bit.arg1, gaa_getint, GAATMP_bit.size1);
		gaa_index++;
#line 31 "mcrypt.gaa"
{ gaaval->bit = GAATMP_bit.arg1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_hex:
	OK = 0;
#line 28 "mcrypt.gaa"
{ gaaval->hexflag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_decrypt:
	OK = 0;
#line 25 "mcrypt.gaa"
{ gaaval->ed_specified=1; gaaval->din = 1; gaaval->ein=0; ;};

		return GAA_OK;
		break;
	case GAAOPTID_bzip2:
	OK = 0;
#line 20 "mcrypt.gaa"
{ gaaval->bzipflag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_gzip:
	OK = 0;
#line 17 "mcrypt.gaa"
{ gaaval->gzipflag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_bare:
	OK = 0;
#line 14 "mcrypt.gaa"
{ gaaval->bare_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_random:
	OK = 0;
#line 11 "mcrypt.gaa"
{ gaaval->real_random_flag = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_force:
	OK = 0;
#line 8 "mcrypt.gaa"
{ gaaval->force = 1 ;};

		return GAA_OK;
		break;
	case GAAOPTID_quiet:
	OK = 0;
#line 5 "mcrypt.gaa"
{ gaaval->quiet = 2 ;};

		return GAA_OK;
		break;
	case GAAOPTID_verbose:
	OK = 0;
#line 4 "mcrypt.gaa"
{ gaaval->quiet = 0 ;};

		return GAA_OK;
		break;
	case GAA_REST:
		GAA_OPTIONALLIST_FILL(GAAREST_tmp.arg1, gaa_getstr, char*, GAAREST_tmp.size1);
#line 68 "mcrypt.gaa"
{ gaaval->input = GAAREST_tmp.arg1; gaaval->size = GAAREST_tmp.size1 ;};

		return GAA_OK;
		break;

#line 413 "gaa.skel"
    default: break;
    }
    return GAA_ERROR_UNKNOWN;
}

int gaa(int argc, char **argv, gaainfo *gaaval)
{
    int tmp1, tmp2;
    int i, j, k;
    char *opt_list;

    GAAargv = argv;
    GAAargc = argc;

    opt_list = (char*) malloc(GAA_NB_OPTION + 1);
    for(i = 0; i < GAA_NB_OPTION + 1; i++)
        opt_list[i] = 0;
    /* initialization */
    if(inited == 0)
    {

#line 70 "mcrypt.gaa"
{ gaaval->force=0; gaaval->quiet=1; gaaval->real_random_flag=0; gaaval->config=0;
       gaaval->bare_flag = 0; gaaval->din = 0; gaaval->ein=1; gaaval->hexflag = 0; gaaval->unlink_flag = 0;
       gaaval->bit = 4; gaaval->keysize=0; gaaval->gzipflag=0; gaaval->bzipflag=0;
       gaaval->sunlink_flag = 0; gaaval->keyfile=NULL; gaaval->algorithm=NULL; gaaval->keys=NULL;
       gaaval->config_file=NULL; gaaval->mode=NULL; gaaval->input=NULL; gaaval->ed_specified=0 ;};

    }
    inited = 1;
#line 438 "gaa.skel"
    gaa_arg_used = malloc(argc * sizeof(char));
    for(i = 1; i < argc; i++)
        gaa_arg_used[i] = 0;
    for(i = 1; i < argc; i++)
    {
        if(gaa_arg_used[i] == 0)
        {
            j = 0;
            tmp1 = gaa_is_an_argument(GAAargv[i]);
            switch(tmp1)
            {
            case GAA_WORD_OPTION:
                j++;
            case GAA_LETTER_OPTION:
                j++;
                tmp2 = gaa_get_option_num(argv[i]+j, tmp1);
                if(tmp2 == GAA_ERROR_NOMATCH)
                {
                    printf("Invalid option '%s'\n", argv[i]+j);
                    return 0;
                }
                switch(gaa_try(tmp2, i+1, gaaval, opt_list))
                {
                case GAA_ERROR_NOTENOUGH_ARGS:
                    printf("'%s' : not enough arguments\n",gaa_current_option);
                    return 0;
                case GAA_ERROR_INVALID_ARG:
                    printf("Invalid arguments\n");
                    return 0;
                case GAA_OK:
                    break;
                default:
                    printf("Unknown error\n");
                }
                gaa_arg_used[i] = 1;
                break;
            case GAA_MULTIPLE_OPTION:
                for(j = 1; j < strlen(argv[i]); j++)
                {
                    tmp2 = gaa_get_option_num(argv[i]+j, tmp1);
                    if(tmp2 == GAA_ERROR_NOMATCH)
                    {
                        printf("Invalid option '%c'\n", *(argv[i]+j));
                        return 0;
                    }
                    switch(gaa_try(tmp2, i+1, gaaval, opt_list))
                    {
                    case GAA_ERROR_NOTENOUGH_ARGS:
                        printf("'%s' : not enough arguments\n",gaa_current_option);
                        return 0;
                    case GAA_ERROR_INVALID_ARG:
                        printf("Invalid arguments\n");
                        return 0;
                    case GAA_OK:
                        break;
                    default:
                        printf("Unknown error\n");
                    }
                }
                gaa_arg_used[i] = 1;
                break;
            default: break;
            }
        }
    }
if(gaa_processing_file == 0)
{
	GAA_INCOMP("zp");
	GAA_INCOMP("Vq");
	GAA_INCOMP("kf");
	GAA_INCOMP("us");

#line 507 "gaa.skel"
#ifdef GAA_REST_EXISTS
    switch(gaa_try(GAA_REST, 1, gaaval, opt_list))
    {
    case GAA_ERROR_NOTENOUGH_ARGS:
        printf("Rest : not enough arguments\n");
        return 0;
    case GAA_ERROR_INVALID_ARG:
        printf("Invalid arguments\n");
        return 0;
    case GAA_OK:
        break;
    default:
        printf("Unknown error\n");
    }
}
#endif
    for(i = 1; i < argc; i++)
    {
        if(gaa_arg_used[i] == 0)
        {
            printf("Too many arguments\n");
            return 0;
        }
    }
    free(gaa_arg_used);
    free(opt_list);
    return -1;
}

struct gaastrnode
{
    char *str;
    struct gaastrnode *next;
};

typedef struct gaastrnode gaa_str_node;

int gaa_internal_get_next_str(FILE *file, gaa_str_node *tmp_str, int argc)
{
    int pos_ini;
    char a;
    int i = 0, len = 0, newline = 0;

    if(argc == 1)
        newline = 1;
    
    if(fscanf(file,"%c", &a) != 1) return 0;

    while(a == ' ' || a == 9 || a == '\n')
    {
        if(a == '\n')
        {
            newline=1;
            len = 2;
        }
        if(fscanf(file,"%c", &a) != 1) return 0;
    }

    pos_ini = ftell(file) - 1;

    while(a != ' ' && a != 9 && a != '\n')
    {

        len++;
        if(fscanf(file,"%c", &a) != 1) a = ' ';
    }
    
    tmp_str->str = malloc((len + 1) * sizeof(char));
    if(newline == 1)
    {
        tmp_str->str[0] = '-';
        tmp_str->str[1] = '-';
        i = 2;
    }
    else
    {
        i = 0;
    }

    fseek(file,pos_ini, SEEK_SET);
    do
    {
        if(fscanf(file, "%c", &a) != 1)
        {
            i+=2;
            break;
        }
        tmp_str->str[i] = a;
        i++;
    }
    while(a != ' ' && a != 9 && a != '\n');

    tmp_str->str[i - 1] = 0;

    fseek(file,- 1, SEEK_CUR);
        
    return -1;
}

int gaa_file(char *name, gaainfo *gaaval)
{
    gaa_str_node *first_str, **tmp_str, *tmp_str2;
    int rval, i;
    char **argv;
    int argc = 0;
    FILE *file;

    gaa_processing_file = 1;
    
    if((file = fopen(name, "r")) == NULL)
    {
        printf("Couldn't open '%s' configuration file for reading\n", name);
        return 0;
    }
    
    tmp_str = &first_str;
    do
    {
        argc++;
        *tmp_str = malloc(sizeof(gaa_str_node));
        (*tmp_str)->str = NULL;
        (*tmp_str)->next = NULL;

        rval = gaa_internal_get_next_str(file, *tmp_str, argc);
        tmp_str = &((*tmp_str)->next);
    }
    while(rval == -1);
    
    if(rval == 1)
        return 0;
    
    argv = malloc((1 + argc) * sizeof(char*));
    tmp_str2 = first_str;
    argv[0] = "cfg";
    for(i = 1; i < argc; i++)
    {
        argv[i] = tmp_str2->str;
        tmp_str2 = tmp_str2->next;
    }

    rval = gaa(argc, argv, gaaval);
    gaa_processing_file = 0;
    return rval;
}
