/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DEFINES_H
# define DEFINES_H
# include <defines.h>
#endif
#include <keys.h>
#include <extra.h>
#include <lcrypt.h>
#include <hex.h>
#include <bzero.h>
#include <bits.h>
#include <xmalloc.h>
#define rol(x, y) ( (x << y) | (x >> (32 - y)) )

/* fixkey takes the input key (or NULL if it wasn't given) and converts
 * the key according to the needs (bit_flag)
 */

void* fixkey(char * key, unsigned int* len, int bit_flag, int hexflag,int algorithm, int quiet, int stream_flag, int enc_mode) {

char *tmp;
char* keyword;
char *tmpkey;
int keysize;

  if (hexflag==TRUE) {
   keysize=2*get_key_size(algorithm);
  }
  else {
   keysize=get_key_size(algorithm);
  }
 
  if (len!=0) {
    tmpkey=xmalloc((*len) + 1);
  }
  else {
    tmpkey=xmalloc(MAX_KEY_LEN);
  }

  keyword=xcalloc(1, get_key_size(algorithm));


  if (key==NULL) {
    tmp=get_password( keysize, bit_flag, enc_mode, algorithm , len);
    if (tmp==NULL) return NULL;

    /* If specified in hex and 8bit */
        if (hexflag==TRUE && bit_flag==BITS8) {
           *len=hexToChar(tmp, *len);
           if (*len==-1) {
             fprintf(stderr, _("Keyword not in proper hex format\n")); 
             exit(1);
           }
        }
        

        if (*len > keysize) *len=keysize;
        memmove(keyword, tmp, *len);
        Bzero(tmp, *len);
	}

    else { /* Key was given on the command line */

         memmove(tmpkey, key, *len);
         

  switch (bit_flag) {

    case BITS8:
            /* If specified in hex */
             if (hexflag==TRUE) {
               *len=hexToChar(tmpkey, *len);

               if (*len==-1) {
                 fprintf(stderr, _("Keyword not in proper hex format\n")); 
                 exit(1);
               }
             }

             if (*len>keysize) {
                fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                *len=keysize;
             }

             memmove(keyword, tmpkey, *len);
             Bzero(tmpkey, *len); /* key is not bzero'd because it may be used again */
             break;
         

         case BITS7:
               *len=strip8bit(tmpkey, *len);
               if (*len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  *len=keysize;
               }

               memmove(keyword, tmpkey, *len);
               Bzero(tmpkey, *len); /* key is not bzero'd because it may be used again */
               break;


         case BITS4:
               *len=strip4bits(tmpkey, *len);
               if (*len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  *len=keysize;
               }

               memmove(keyword, tmpkey, *len);
               Bzero(tmpkey, *len); /* key is not bzero'd because it may be used again */
               break;               
           
    }
  } 
return keyword;

}


