#include <config.h>

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
# include <stdio.h>
#endif

#include <time.h>
#include "getopt.h"

#ifndef FUNCTIONS_H
# define FUNCTIONS_H
# include "functions.h"
#endif

#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(String) gettext (String) /* NLS too */
#else
# define _(String) (String) /* NLS too */
#endif

#ifdef HAVE_UTIME_H
# include <utime.h>
#endif




/* for open */
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/* defines */
#define BITS7 1
#define BITS8 0

#define TRUE 1
#define FALSE 0

#define BLOWFISH 0
#define DES 1 
#define TripleDES 2
#define ThreeWAY 3
#define GOST 4
#define CRYPT 5
#define SAFER64 6
#define SAFER128 7

#define ENCRYPT 0
#define DECRYPT 1

#define CBC 0
#define ECB 1

#if SIZEOF_LONG_INT == 4
 typedef unsigned long word32;
#elif SIZEOF_INT == 4
 typedef unsigned int word32;
#else
# error "Cannot find a 32 bit integer in your system, sorry."
#endif

#if SIZEOF_INT == 2
 typedef unsigned int word16;
#elif SIZEOF_SHORT_INT == 2
 typedef unsigned short word16;
#else 
# error "Cannot find a 16 bit integer in your system, sorry."
#endif

#if SIZEOF_CHAR == 1
 typedef unsigned char word8; 
#else
# error "Cannot find an 8 bit char in your system, sorry."
#endif

/* originally was in 3way.c */
#define RAND32 (word32) ((word32)rand() << 17 ^ (word32)rand() << 9 ^ rand())

#ifndef HAVE_MEMMOVE
# ifdef HAVE_BCOPY
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# else
#  error "Neither memmove nor bcopy exists on your system."
# endif
#endif

extern char *getpass();
extern char *crypt(); /* libufc */
