#define end_mcrypt_ecb end_mcrypt
#define init_mcrypt_ecb init_mcrypt

int get_block_size(int algorithm);
int get_key_size(int algorithm); /* In bytes */

int init_mcrypt(const int algorithm, void * key,const int lenofkey);
int mcrypt(int thread, void *plaintext);
int mdecrypt(int thread, void *plaintext);
int end_mcrypt(int td);

/* ECB */
int mcrypt_ecb(int thread, void *plaintext,int len);
int mdecrypt_ecb(int thread, void *plaintext, int);

/* CBC */
int end_mcrypt_cbc(int td);
int mcrypt_cbc(int td, void *plaintext, int);
int mdecrypt_cbc(int td, void *ciphertext, int);
int init_mcrypt_cbc(const int algorithm, void * key,const int lenofkey);

/* CFB */
int end_mcrypt_cfb(int td);
int mcrypt_cfb(int td, void *plaintext,int len);
int mdecrypt_cfb(int td, void *ciphertext, int len);
int init_mcrypt_cfb(const int algorithm, void * key,const int lenofkey, void *IV);


#ifndef BLOWFISH
# define BLOWFISH 0
# define DES 1 
# define TripleDES 2
# define ThreeWAY 3
# define GOST 4
# define SAFER64 6
# define SAFER128 7
# define CAST128 8
# define TEAN 9
#endif
