/*  Mini-Crypt2 program. It encrypts text or binary files using
 *  keywords. The keyword is NOT included in the encrypted file so
 *  there is no way to decrypt it, if you forgot it. 
 *  For a brief description of the algorithms read the README file and
 *  the man page.
 *                                     Nikos Mavroyanopoulos
 *                                         nmav@i-net.paiko.gr
 *
 *    Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <mcrypt.h>
#include <swap.h>
#include <bzero.h>
#include <extra.h>
#include <bits.h>
#include <lcrypt.h>
#include <sunlink.h>
#include <crc32.h>
#include <locks.h>
#include <crypt.h>

 unsigned int bit7_flag=BITS7;
 unsigned int stream_flag=FALSE;
 unsigned int mode=CBC; /* 0:cbc 1:ecb */
 unsigned int type=BLOWFISH; /* default: blowfish */
 int quiet=TRUE; /* silent by default */
 int unlink_flag=FALSE;
 int bare_flag=FALSE;
 char *outfile=0;


void usage(char *name)
{

     fprintf(stderr,_("Usage: mcrypt FILE1 FILE2 ...\n"));
     fprintf(stderr,_("Usage: mcrypt -d FILE1 FILE2 ...\n\n"));

     fprintf(stderr,_("mini-crypt encrypts/decrypts files using several symmetric block algorithms.\n\
\n\
 -d --decrypt                 decrypts\n\
 -a --algorithm=ALGORITHM     specify the encryption and decryption algorithm.\n\
                              Legal parameters are: 3way, des, 3des, gost, tea,\n\
                              safer64, safer128, cast128, crypt and blowfish. \n\
                              (Default is blowfish)\n\
 -m --mode=MODE               specify the mode (cfb, ecb or cbc). (Default is cbc)\n\
 -k --key=KEYWORD             keyword to use.\n\
 -7 --7bit                    keyword in 7bit mode. (default)\n\
 -8 --8bit                    keyword in 8bit mode.\n\
 -u --unlink                  unlink (and destroy) the input file after\n\
                              encryption/decryption\n\
 -L --license                 displays license information.\n\
 -q --quiet                   suppress some non critical warnings.\n\
 -V --verbose                 some more information is displayed.\n\
 -b --bare                    Do not keep algorithm information in the encrypted file.\n\
 -f --force                   forces output to stdout.\n\
 \n\
 -h --help                    prints this help\n\
 -v --version                 prints the version number\n\
 \n\
Report bugs to nmav@i-net.paiko.gr.\n\n"));
}




/*				The main    */
int main(int argc,char **argv)
{
	short int ch,ein=0,din=0,kin=0,force=0,return_val=0;
	char *einfile=0 ,*dinfile=0, *keyword=0,*modet=0,*typet=0;
	char **file; 
	extern char *optarg;
	int x,y,i,file_count=0;


struct option longopts[] = {
	    { "version", 0, 0, 'v' },
	    { "help", 0, 0, 'h' },
	    { "bare", 0, 0, 'b' },	    
	    { "decrypt", 0, 0, 'd' },
	    { "mode", 1, 0, 'm' },
	    { "algorithm", 1, 0, 'a' },
	    { "key", 1, 0, 'k' },
	    { "force", 0, 0, 'f' },
	    { "7bit", 0, 0, '7' },	    
	    { "8bit", 0, 0, '8' },
	    { "quiet", 0, 0, 'q'},
	    { "verbose", 0, 0, 'V'},	    
	    { "license", 0, 0, 'L'},
	    { "unlink", 0, 0, 'u'},	    
	    { 0, 0, 0, 0 }
       	  };

#ifdef HAVE_SIGNAL_H
 Signal( SIGINT, shandler);
 Signal( SIGQUIT, shandler);
 Signal( SIGSEGV, shandler);
 Signal( SIGPIPE, shandler);   
 Signal( SIGTERM, shandler);   
 Signal( SIGHUP, shandler);   
 Signal( SIGUSR1, SIG_IGN);
 Signal( SIGUSR2, SIG_IGN);
 Signal( SIGALRM, SIG_IGN);
#endif 

#ifdef ENABLE_NLS
  setlocale (LC_MESSAGES, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
#endif

/* Examine how we were called */
   if (strstr(argv[0],"decrypt")!=NULL) {
     strcpy( argv[0], "mdecrypt");
     din=TRUE;
     ein=FALSE;
   }
   else {
     strcpy( argv[0], "mcrypt");
     din=FALSE;
     ein=TRUE; /* It will change by the arguments */
   }


            /* File pointers are as much as the file arguments */

        file=malloc((argc-optind)*sizeof(char*)); 

	while( (ch=getopt_long(argc,argv,"f78bLVuqda:m:k:hv",longopts, (int *)0 )) != EOF )

		switch(ch) {
	
		case 'v':
			printf (_("Mini-crypt v.%s\n"),VERSION);
			printf (_("Copyright (C) 1998,1999 Nikos Mavroyanopoulos (nmav@i-net.paiko.gr)\n"));
			return 0;
			break;

		case 'L':
			printf (_("\nCopyright (C) 1998,1999 Nikos Mavroyanopoulos\n\
This program is free software; you can redistribute it and/or modify \n\
it under the terms of the GNU General Public License as published by \n\
the Free Software Foundation; either version 2 of the License, or \n\
(at your option) any later version. \n\
\n\
This program is distributed in the hope that it will be useful, \n\
but WITHOUT ANY WARRANTY; without even the implied warranty of \n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \n\
GNU General Public License for more details. \n\
\n\
You should have received a copy of the GNU General Public License \n\
along with this program; if not, write to the Free Software \n\
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n\n"));
			                                                
			return 0;
			break;			

		case 'd':
			din=TRUE;
			ein=FALSE;
			break;

		case 'f':
			force=TRUE;
			break;

		case 'b':
			bare_flag=TRUE;
			break;

		case 'u':
			unlink_flag=TRUE;
			break;			

		case 'q':
			quiet=TRUE;
			break;			

		case 'V':
			quiet=FALSE;
			break;

		case '7':
			bit7_flag=BITS7;
			break;			

		case '8':
			bit7_flag=BITS8;
			break;			

		case 'k':
			kin=1;
			keyword= malloc(strlen(optarg)+10);
			strcpy(keyword,optarg);
			break;
		case 'm':
			modet= malloc(strlen(optarg)+1);
			strcpy(modet,optarg);
			if (strncasecmp(modet,"ECB",3)==0) {
			  mode=ECB;
			}
                        else {
                          if (strncasecmp(modet,"CBC",3)==0) {
                            mode=CBC;
			  }
			  else {
                            if (strncasecmp(modet,"CFB",3)==0) {
                              mode=CFB;
	  	            }			  
			  }
                        
                        }
			free(modet);
			break;
		case 'a':
			typet= malloc(strlen(optarg)+1);
			strcpy(typet,optarg);
			if (strncasecmp(typet,"DES",3)==0) {
			  type=DES;
			 }
			else {
			 if (strncasecmp(typet,"3DES",4)==0 || strncasecmp(typet,"3-DES",3)==0) {
                          type=TripleDES;
                         }
                         else {
                          if (strncasecmp(typet,"3WAY",4)==0 || strncasecmp(typet,"3-WAY",3)==0) {
                           type=ThreeWAY;
                          }
                          else {
                           if (strncasecmp(typet,"BLOWFISH",8)==0) {
                            type=BLOWFISH;
                           }
                           else {
                             if (strncasecmp(typet,"GOST",4)==0) {
                               type=GOST;
                             }
                             else {
                              if (strncasecmp(typet,"CRYPT",5)==0) {
                              type=CRYPT;
                              }
                              else {
                                if (strncasecmp(typet,"SAFER64",7)==0) {
                                  type=SAFER64;
                                }
                                else {
                                  if (strncasecmp(typet,"SAFER128",8)==0) {
                                    type=SAFER128;
                                  }
                                  else {
                                    if (strncasecmp(typet,"CAST128",7)==0) {
                                    type=CAST128;
                                    }
                                    else {
                                       if (strncasecmp(typet,"TEAN",4)==0 || strncasecmp(typet,"TEA",3)==0) {
                                       type=TEAN;
                                       }
                                    }
                                  }
                                }
                              }
                             }
                           }
                          }
                         }
                        }
			free(typet);
			break;


		case '?':
		case 'h':
		default:
		     usage(argv[0]);
		     return 1;
		     break;


		}

#ifdef HAVE_UMASK
  umask(066);
#endif

/* Normal startup */


/* ok now how many files were specified? */
    i=0;
    file_count+= (argc - optind);


    if (file_count==0) {
        stream_flag=TRUE;
    }  

    while (optind < argc) {
        file[i]=argv[optind++];
        i++;
    }

    
    if (stream_flag==TRUE) file_count++;


/* Do as many times as many files we got */
for(i=0;i<file_count;i++) {

    if(i!=0) { if (outfile!=NULL) free(outfile); }

#ifdef HAVE_STAT
    if ( is_normal_file( file[i]) == FALSE && stream_flag==FALSE ) {
      fprintf( stderr, _("%s: %s is not a regular file. Skipping...\n"), argv[0], file[i]);
      outfile=NULL;
      continue; /* next */
    }
#endif

    if (stream_flag==FALSE) {
      if (quiet==FALSE) fprintf(stderr, _("File: %s\n"),file[i]);
    }
    else {
      if (quiet==FALSE) fprintf(stderr, _("File: stdin\n"));    
    }
    
         /* Check how we were called */
	if (din==TRUE) {
            if (stream_flag!=TRUE) dinfile=file[i];
            if ( (isatty(fileno( (FILE *)(stdin) ) ) == 1) && (stream_flag==TRUE) && (force==0) ) { /* not a tty */        
              fprintf(stderr,_("%s: Encrypted data will not be read from a terminal.\n"),argv[0]);
              fprintf(stderr,_("Redirect the input instead.\nUse the --help parameter for more help.\n"));
               exit(-1);
            }
        } 
        else { /* called as mcrypt or something like that */
            if (stream_flag!=TRUE) einfile=file[i];
            if ( (isatty(fileno( (FILE *)(stdout) ) ) == 1) && (stream_flag==TRUE) && (force==0) ) { /* not a tty */        
              fprintf(stderr,_("%s: Encrypted data will not be written to a terminal.\n"),argv[0]);
              fprintf(stderr,_("Redirect the output instead.\nUse the --help parameter for more help.\n"));
              exit(-1);
            }            
        }


        /* If no streams make the extensions */
       if(stream_flag!=TRUE) {
	 if (din==TRUE) {

            y=strlen(dinfile);
            /* If the file finished in .enc remove it */
             
            if (dinfile[y-1]=='c' && dinfile[y-2]=='n' && dinfile[y-3]=='e' && dinfile[y-4]=='.') {

	      outfile= calloc(y-3,1);
  	      strncat(outfile,dinfile,y-4);
#ifdef HAVE_STAT
              /* But if it exists exit */
              if (check_file(outfile)!=0) {fprintf(stderr,_("%s: file %s exists... skipping...\n"), argv[0], outfile); continue;}
#endif  	      
            }
            else { /* append .dec */

	     outfile=calloc(y+5,1);
             strncpy(outfile,dinfile,y);
             strcat(outfile,".dec");
            }
         }
	 else { /* encryption- append .enc */
	    outfile= calloc(strlen(einfile)+5,1);
	    strcpy(outfile,einfile);
            /* if file has already the .enc ignore it */
            if (strstr( outfile, ".enc")!=NULL) {fprintf(stderr,_("%s: file %s has the .enc suffix... skipping...\n"), argv[0], outfile); continue;}

	    strcat(outfile,".enc");
#ifdef HAVE_STAT
              /* But if it exists exit */
              if (check_file(outfile)!=0) {fprintf(stderr,_("%s: file %s exists... skipping...\n"), argv[0], outfile); continue;}
#endif  	      

	 }
       }
       else { /* if streams */

         outfile=malloc(7);
         strcpy(outfile,"stdout");

       }

/* Decrypt */
	if (din==TRUE) {

           if (bare_flag==FALSE) {
             if (check_file_head(file[i],&type,&mode, &bit7_flag, stream_flag)!=FALSE) {
               fprintf(stderr,_("%s: no headers. Assuming encrypted file with Unix crypt.\n"),argv[0]); 
               type=CRYPT;
             }
           }

		      switch (type) {
		        case DES:
		        case TripleDES:
			case ThreeWAY:
			case BLOWFISH:
			case GOST:
			case SAFER64:
			case SAFER128:
                        case CAST128:
                        case TEAN:
			 x=decrypt_general(type,dinfile,outfile,keyword);
			 break;
			case CRYPT:
			 x=encrypt_ucrypt(dinfile,outfile,keyword);
			 break;			 
                        default:
                         fprintf(stderr,_("Algorithm unsupported in this version\n"));
                         x=1;
                         break;
                        }
                        
			if (x==0) {
        	            if (stream_flag==FALSE) {
        	              if (quiet==FALSE) fprintf (stderr,_("File %s was decrypted.\n"),dinfile);
        	            }
        	            else {
        	              if (quiet==FALSE) fprintf (stderr,_("Stdin was decrypted.\n"));
        	            }
#ifdef HAVE_STAT        	           
# ifdef HAVE_UTIME_H
                           if (stream_flag==FALSE) copyDate(dinfile,outfile);
# endif
        	           if (unlink_flag==TRUE && stream_flag==FALSE) remove(dinfile);
#endif        	           
        	        }
	        	else {
                          if (stream_flag==FALSE) {
        	           fprintf (stderr,_("File %s was NOT decrypted successfully.\n"),dinfile);
          	           remove(outfile);
        	          }
        	          else {
        	           fprintf (stderr,_("Stdin was NOT decrypted successfully.\n"));
        	          }
        	        }
        
                        return_val+=x;
	}		

/* Encrypt */
	if (ein==TRUE) {
		      switch (type) {
		        case DES:
		        case TripleDES:
	        	case ThreeWAY:
	        	case BLOWFISH:
	        	case GOST:
	        	case SAFER64:
	        	case SAFER128:
                        case CAST128:
                        case TEAN:
	        	 x=encrypt_general(type,einfile,outfile,keyword);
	        	 break;
	        	 
	        	case CRYPT:
	        	 x=encrypt_ucrypt(einfile,outfile,keyword);
	        	 break;
	        	 
	        	default:
	        	 x=1;
	        	 break;
                        }

	        	if (x==0) {
                          if (stream_flag==FALSE) {
	        	   if (quiet==FALSE) fprintf (stderr,_("File %s was successfully encrypted.\n"),einfile);
	        	  }
                          else {
	        	   if (quiet==FALSE) fprintf (stderr,_("Stdin was successfully encrypted.\n"));
	        	  }
#ifdef HAVE_STAT
# ifdef HAVE_UTIME_H
                           if (stream_flag==FALSE) copyDate(einfile,outfile);
# endif
#endif
	        	   if (unlink_flag==TRUE && stream_flag==FALSE) x=safe_unlink(einfile);
	        	   if (x!=0) perror("safe_unlink");
		       	}
	                else {
                         if (stream_flag==FALSE) {
	                  fprintf (stderr,_("File %s was NOT encrypted successfully.\n"),einfile);
                          remove(outfile);
	                 }
                         else {
	                  fprintf (stderr,_("Stdin was NOT encrypted successfully.\n"));
	                 }

	                }
	                
	                return_val+=x;
		}

   } /* the main loop */

return (return_val);

}




/* UNIX CRYPT Encryption */

int encrypt_ucrypt(char *fromfile,char *tofile,char *key)
{
word32 plaintext[2]; /* 64 bit */
int ch=0,how=8; /* how needs to be initialized to 8 */
char keyword[13]; 
char *tmp;
FILE *TOF;
FILE *FROMF;

/* Crypt does not care about these 
 * It's purpose is to be compatible with the unix crypt not safe.
 * It isn't a block algorithm after all.
 */
mode=2;
bit7_flag=BITS8;


/* open files */
if (stream_flag==TRUE) {
	FROMF=stdin;
	TOF=stdout;
}
else {

	FROMF=fopen(fromfile,"rb");
	if (FROMF==NULL) {perror("fopen");return 1;}
	read_lock( fileno((FILE*)FROMF));
	
	TOF=fopen(tofile,"wb");
	if (TOF==NULL) {perror("fopen");return 1;}
	write_lock( fileno((FILE*)TOF));
}

        Bzero(keyword,sizeof(keyword));

	if (key==NULL) 	{
          if (quiet==TRUE && stream_flag==FALSE) fprintf(stderr, _("File: %s\n"),fromfile);
          tmp=get_password(8,bit7_flag,DECRYPT,type);
          if (tmp==NULL) return 1;
          memmove(keyword, tmp, strlen(tmp));
          Bzero(tmp, strlen(tmp));

	}
	else {
           if (strlen(key) > 8) {key[8]='\0'; fprintf(stderr,_("Warning: Reducing the size of the key\n"));}
	   memmove(keyword, key, strlen(key)); /* Copy the 64 bits in key */
	}


if (quiet==FALSE) show_mode(ENCRYPT,type,mode,tofile,bit7_flag); 


if (unix_setup(keyword)==1) {fprintf(stderr,_("Cannot encrypt key\n"));return 1; }/* init the crypt */

do
{
/* else read the first 1 byte of the file and stores the to plaintext */
 
                how=fread(plaintext, 1, sizeof(plaintext), FROMF);
                if (how == 0 ) {
                 if (feof(FROMF)!=0) {
                  ch=1;
                 }
                 else {
                  perror("fread");
                  return 1;
                 }
                }
                   
		unix_crypt(keyword,plaintext,how,0);
                
                if (ch==0)
		 if (fwrite(plaintext,1,how,TOF)==0) {perror("fwrite"); return(1);}

}
while(ch==0);

/* close files */
 if (stream_flag==FALSE) {
   fflush(FROMF);
   fflush(TOF);
   unlock( fileno((FILE*)TOF));
   unlock( fileno((FILE*)FROMF));
 }
   fclose(TOF);
   fclose(FROMF);
   
   Bzero(keyword, sizeof(keyword));
   
return 0;
}













/* General Encryption */

int encrypt_general(int algorithm, char *fromfile,char *tofile,char *key)
{
unsigned char counter=0;
word32 fcrc32;
int i=0,j=0,ch=0,how=0;
char *tmp,*copychar;
unsigned int len=0;
FILE *RTOF;
FILE *FROMF;
int keysize=get_key_size(algorithm);
int blocksize=get_block_size(algorithm);
char tmpkey[128];
int td;

word32 *IV=0;
word32 *keyword=calloc(keysize,1); 
word32 *ciphertext=malloc(blocksize);
FILE * TOF; 

 TOF=tmpfile();
 write_lock( fileno((FILE*)TOF));
        

if (mode==CBC || mode==CFB) {
 IV=malloc(blocksize);
 /* Initialisation Vector */
 srand(time(0));

/* Random number generator */

 for (i=0;i<blocksize/sizeof(word32);i++) {
  IV[i] = RAND32 ;
 }
}

/* open files */
  if (stream_flag==TRUE) {
	FROMF=stdin;
	RTOF=stdout;
  }
  else {
	FROMF=fopen(fromfile,"rb");
	if (FROMF==NULL) {perror("fopen");return 1;}
        read_lock( fileno((FILE*)FROMF));
        
	RTOF=fopen(tofile,"wb");
	if (RTOF==NULL) {perror("fopen");return 1;}
        write_lock( fileno((FILE*)RTOF));
        
  }



  if (bare_flag==FALSE) {
    write_file_head( fileno((FILE*)TOF), type, mode, bit7_flag);
    write( fileno((FILE*)TOF), ciphertext, blocksize);
     /* Just leave space to put later the crc32 */
  }  


	if (key==NULL) 	{
          if (quiet==TRUE && stream_flag==FALSE) fprintf(stderr, _("File: %s\n"),fromfile);
          tmp=get_password( keysize, bit7_flag, ENCRYPT, algorithm );
          if (tmp==NULL) return 1;
          len=strlen(tmp);

          if (len > keysize) len=keysize;
          memmove(keyword, tmp, len);
          Bzero(tmp, len);
                
	}
	else {

           if (bit7_flag==BITS8) {
               len=strlen(key);

               if (len>keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memmove(keyword, key, len);
           }
           else { /* 7bit mode */
               len=strlen(key);
               memmove(tmpkey, key, len);
               strip8bit(tmpkey, len);
               len=strlen(tmpkey);
               if (len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memmove(keyword, tmpkey, len);
               Bzero(tmpkey, len); /* key is not bzero'd because it may be used again */
           }           
	}

 if (quiet==FALSE) show_mode(ENCRYPT,algorithm,mode,tofile,bit7_flag);


  if (algorithm != BLOWFISH) {
    len=keysize; /* Only Blowfish has non-fixed key */
  }
  else { /* blowfish */
    if (len<2) {
    fprintf(stderr, _("Too small key for this algorithm. Aborting.\n"));
    return 1;
    }
  }



  switch (mode) {
   case ECB:
    td = init_mcrypt_ecb(algorithm,keyword,len);
    break;
   case CBC:
    td = init_mcrypt_cbc(algorithm,keyword,len);
    break;
   case CFB:
    td = init_mcrypt_cfb(algorithm,keyword,len,IV);
    break;    
   default:
    return 1;
    break;
  }  

 if (bare_flag==FALSE) clear_crc32();


/* Encryption Starts here */

switch (mode) {

 case CBC:

  /* Put the IV into the file */
  mcrypt_cbc(td, IV, blocksize);
  if (fwrite(IV, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}

  do
  {
  /* read the first n bytes of the file and store to ciphertext */
 
                   how=fread(ciphertext,1,blocksize,FROMF);

  	           if (how < blocksize) {
                    if ( how ==0 && feof(FROMF)==0) {
                       perror("fread"); 
                       return 1;
                    }

		    counter=((unsigned char) how);
                    ch=1;
                   }



  /* crc32 */
   if (bare_flag==FALSE) crc32(ciphertext, how);

   mcrypt_cbc(td, ciphertext,blocksize);

         
    if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}
    if (ch==1) {
      if (fwrite(&counter, 1, sizeof(counter), TOF) == 0) {perror("fwrite"); return 1;}
    }

  }
  while(ch==0);
  break;

 case CFB:

  /* Put the IV into the file */
  if (fwrite(IV, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}

  do
  {
  /* read 1 byte of the file and store to ciphertext */
 
                   how=fread(ciphertext,1, sizeof(ciphertext),FROMF);

  	           if (how < 1) {
                    if ( how ==0 && feof(FROMF)==0) {
                       perror("fread"); 
                       return 1;
                    }

                    ch=1;
                   }



   /* crc32 */
    if (bare_flag==FALSE) crc32(ciphertext, how);
    mcrypt_cfb(td, ciphertext,how);
         
    if (ch==0) {
      if (fwrite(ciphertext, 1, how, TOF) == 0) {perror("fwrite"); return 1;}
    }

  }
  while(ch==0);
  break;


 case ECB:
  do
  {

  /* read the first n bytes of the file and store to ciphertext */
 
                   how=fread(ciphertext,1,blocksize,FROMF);

  	           if (how < blocksize) {
                    if ( how ==0 && feof(FROMF)==0) {
                       perror("fread"); 
                       return 1;
                    }

		    counter=((unsigned char) how);
                    ch=1;
                   }



  /* crc32 */
   if (bare_flag==FALSE) crc32(ciphertext, how);

   mcrypt_ecb(td, ciphertext, blocksize);

         
    if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}
    if (ch==1) {
      if (fwrite(&counter, 1, sizeof(counter), TOF) == 0) {perror("fwrite"); return 1;}
    }

  }
  while(ch==0);
  break;

} /*  switch */

 if (bare_flag==FALSE) {
    /* Put the crc32 in byte 6 */

#ifdef WORDS_BIGENDIAN
   fcrc32=get_crc32();
#else
   fcrc32=byteswap(get_crc32());
#endif   



/* encrypt the crc32, but first put some random data there 
 */
   for(j=0; j<blocksize/sizeof(word32); j++)
     ciphertext[j] = RAND32;
   memmove(ciphertext,&fcrc32,sizeof(fcrc32));
   mcrypt(td, ciphertext);
   fseek(TOF,6,SEEK_SET);
   if (fwrite(ciphertext, 1, blocksize, TOF) == 0) {perror("fwrite"); return 1;}

 }

/* Copy the temporary to RTOF */
   fseek(TOF,0,SEEK_SET);

 copychar=malloc(4096);

 do {
    how=fread(copychar, 1, 4096, TOF);
    fwrite(copychar, how, 1, RTOF);
 } while ( how!=0 );

 free(copychar);
/* End of copy */
   
/* close and unlock files*/

    fflush(TOF);
    unlock( fileno((FILE*)TOF) );
    
 if (stream_flag==FALSE) {
    fflush(FROMF);
    fflush(RTOF);    
    unlock( fileno((FILE*)FROMF) );
    unlock( fileno((FILE*)RTOF) );
 }
                
    fclose(TOF);
    fclose(RTOF);
    fclose(FROMF);
/* Ready */


  switch (mode) {
   case ECB:
     end_mcrypt_ecb(td);
     break;
   case CBC:
     end_mcrypt_cbc(td);
     free(IV);
     break;
   case CFB:
     end_mcrypt_cfb(td);
     free(IV);
     break;     
  }  

    Bzero(keyword, keysize);
    free(keyword); 
    free(ciphertext);


  return 0;
}





/* General Decryption */

int decrypt_general(int algorithm, char *fromfile,char *tofile,char *key)
{
word32 fcrc32, newcrc32;
unsigned char counter=0;
int i=0,ch=0,start=0;
char *tmp;
int keysize=get_key_size(algorithm);
int blocksize=get_block_size(algorithm);
char tmpkey[128];
int td;

word32 *ciphertext_old=malloc(blocksize);
word32 *buffer=malloc(blocksize);
word32 *ciphertext=malloc(blocksize);
word32 *ciphertext_orig=malloc(blocksize);
word32 *keyword=calloc(1,keysize);

unsigned int len=0;

FILE *RTOF;
FILE *FROMF;


/* open files */
if (stream_flag==TRUE) {
	FROMF=stdin;
	RTOF=stdout;
}
else {

	FROMF=fopen(fromfile,"rb");
	if (FROMF==NULL) {perror("fopen");return 1;}
        read_lock( fileno((FILE*)FROMF));
        
	RTOF=fopen(tofile,"wb");
	if (RTOF==NULL) {perror("fopen");return 1;}
        write_lock( fileno((FILE*)RTOF));

        if (bare_flag==FALSE) fseek( FROMF, 6, SEEK_CUR);
        /* In streams this has been done when checking for headers. */
}


  
	if (key==NULL) {
          if (quiet==TRUE && stream_flag==FALSE) fprintf(stderr, _("File: %s\n"),fromfile);
          tmp=get_password(keysize,bit7_flag,DECRYPT,algorithm);
          if (tmp==NULL) return 1;
          len=strlen(tmp);
                              
          if (len>keysize) len=keysize;
          memmove(keyword, tmp, len);
          Bzero(tmp, len);

	}
	else {
            if (bit7_flag==BITS8) {
              len=strlen(key);
              if (len>keysize) {
                 fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                 len=keysize;
              }
              memmove(keyword, key, len);
            }
            else { /* 7bit mode */
               len=strlen(key);
               memmove(tmpkey, key, len);
               strip8bit( tmpkey, len);
               len=strlen(tmpkey);
               if (len > keysize) {
                  fprintf(stderr,_("Warning: Reducing the size of the key\n"));
                  len=keysize;
               }
               memmove(keyword, tmpkey, len);
               Bzero(tmpkey, len);
            }          
        }

if (quiet==FALSE) show_mode(DECRYPT,algorithm,mode,tofile,bit7_flag);


 if (algorithm!=BLOWFISH) {
  len=keysize;
 }
 else { /* blowfish */
   if (len<2) {
    fprintf(stderr, _("Too small key for this algorithm. Aborting.\n"));
    return 1;
    }
 }
 
  switch (mode) {
    case CBC:
      td = init_mcrypt_cbc(algorithm,keyword,len);
      break;
    case ECB:
      td = init_mcrypt_ecb(algorithm,keyword,len);
      break;
    case CFB:
      td = init_mcrypt_ecb(algorithm,keyword,len);
      break;      
    default:
      return 1;
      break;
  }
    
/* Decrypt CRC32 stored in file */
 if (bare_flag==FALSE) {

   clear_crc32();
   
    /* Read CRC32 */
   fread(ciphertext, 1, blocksize, FROMF);
   mdecrypt(td, ciphertext);
   memmove(&fcrc32, ciphertext, sizeof(fcrc32));
#ifndef WORDS_BIGENDIAN
   fcrc32=byteswap(fcrc32);
#endif

 }

switch (mode) {

 case CBC:
  /* decryption starts here */
   fread( ciphertext, 1, blocksize, FROMF); /* Read the IV */
   mdecrypt_cbc( td, ciphertext, blocksize);
   
  /* decryption starts here */
   do
   {

    /* reads the first n bytes of the file and stores the to ciphertext */

           i=fread( ciphertext, 1, blocksize, FROMF);

           if (i < blocksize) {
             if (ferror(FROMF)!=0) {
               perror("fread"); 
               return 1;
             }
             else { /* eof */
               ch=1;
               if (i==0) {fprintf(stderr,_("Incorrect file type\n")); return 1;}
               memmove(&counter, ciphertext, sizeof(counter));
               if (counter >= blocksize) {fprintf(stderr,_("Incorrect file type\n")); return 1;}
             }
           }

         /* Decrypt the ciphertext */

        memmove(ciphertext_orig,ciphertext,blocksize); /* keep backup */


        mdecrypt_cbc(td, ciphertext, blocksize);
	
        memmove(ciphertext_old,ciphertext_orig,blocksize);


/* Buffer isn't immediately written here. It waits a round to do
 * so we can keep track of the end of file garbage and the IV at the begining
 */

		if (ch==1) {
                  if (counter==0) break;
		  if (fwrite(buffer,(int)counter,1,RTOF)==0) {perror("fwrite"); return 1;}
  		   /* CRC32 */
          	  if (bare_flag==FALSE) crc32(buffer, (int)counter);

		}
		else {
		    if (start!=0) {
   		      if (fwrite(buffer,blocksize,1,RTOF)==0) {perror("fwrite"); return 1;}
                       /* CRC32 */
                      if (bare_flag==FALSE) crc32(buffer, blocksize);

   		    }
                }

         start++;
         memmove(buffer,ciphertext,blocksize);  /* copy the plaintext to buffer */

   }
   while(ch==0);
   break;

 case ECB:
  /* decryption starts here */
   do
   {

    /* reads the first n bytes of the file and stores the to ciphertext */

           i=fread( ciphertext, 1, blocksize, FROMF);

           if (i < blocksize) {
             if (ferror(FROMF)!=0) {
               perror("fread"); 
               return 1;
             }
             else { /* eof */
               ch=1;
               if (i==0) {fprintf(stderr,_("Incorrect file type\n")); return 1;}
               memmove(&counter, ciphertext, sizeof(counter));
               if (counter >= blocksize) {fprintf(stderr,_("Incorrect file type\n")); return 1;}
             }
           }

         /* Decrypt the ciphertext */

        memmove(ciphertext_orig,ciphertext,blocksize); /* keep backup */


        mdecrypt_ecb(td, ciphertext,blocksize);
	
        memmove(ciphertext_old,ciphertext_orig,blocksize);


/* Buffer isn't immediately written here. It waits a round to do
 * so we can keep track of the end of file garbage and the IV at the begining
 */

		if (ch==1) {
                  if (counter!=0) {
		    if (fwrite(buffer,(int)counter,1,RTOF)==0) {perror("fwrite"); return 1;}
  		     /* CRC32 */
          	    if (bare_flag==FALSE) crc32(buffer, (int)counter);
          	  }

		}
		else {
		    if (start!=0) {
   		      if (fwrite(buffer,blocksize,1,RTOF)==0) {perror("fwrite"); return 1;}
                       /* CRC32 */
                      if (bare_flag==FALSE) crc32(buffer, blocksize);

   		    }
                }

         start++;
         memmove(buffer,ciphertext,blocksize);  /* copy the plaintext to buffer */

   }
   while(ch==0);
   break;
   
 case CFB:
   end_mcrypt_ecb(td);
   i=fread( ciphertext, 1, blocksize, FROMF); /* Read the IV */
   td=init_mcrypt_cfb(algorithm,keyword,len,ciphertext); 

  /* decryption starts here */

   do
   {

    /* reads 1 byte of the file and stores the to ciphertext */

           i=fread( ciphertext, 1, sizeof(ciphertext), FROMF);

           if (i < 1) {
             if (ferror(FROMF)!=0) {
               perror("fread"); 
               return 1;
             }
             ch=1;
           }

         /* Decrypt the ciphertext */

        mdecrypt_cfb(td, ciphertext, i);
	
            if (ch!=1) {
              if (fwrite(ciphertext,1, i,RTOF)==0) {perror("fwrite"); return 1;}
                /* CRC32 */
                if (bare_flag==FALSE) crc32(ciphertext, i);
            }

   }
   while(ch==0);
   break;   
} /* switch */


/* close and unlock files */

 if (stream_flag==FALSE) {
  fflush(FROMF);
  fflush(RTOF);
  unlock( fileno((FILE*)FROMF));
  unlock( fileno((FILE*)RTOF));
 }
 
  fclose(RTOF);
  fclose(FROMF);

/* ready */

  switch (mode) {
    case CBC:
      end_mcrypt_cbc(td);
      break;
    case ECB:
      end_mcrypt_ecb(td);
      break;
  }

  free(ciphertext_old);
  free(buffer);
  free(ciphertext);
  free(ciphertext_orig);

  Bzero(keyword, keysize);
  free(keyword);

 if (bare_flag==FALSE) {

    newcrc32=get_crc32();
    if (newcrc32==fcrc32) {
     return 0; /* crc check passed */
    }
    else {
     fprintf(stderr, _("CRC32 check failed\n"));
     return 1; /* CRC32s Do not match */
    }
 }
 else { /* no crc is stored here */
   return 0;
 }

}

