/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif
#include "bits.h"
#include <bzero.h>
#include <extra.h>		/* for MAX_KEY_LEN */

#define m_getbit(n, v)    (((unsigned int)(v) >> (unsigned)(n)) & 1)
#define i_setbit(n, v)    ((unsigned int)(v) | (1U << (unsigned)(n)))
#define i_unsetbit(n, v)    ((unsigned int)(v) & ~(1U << (unsigned)(n)))


unsigned int m_setbit(unsigned int which, unsigned int fullnum, unsigned int what)
{
	if (what == 1) {
		return i_setbit(which, fullnum);
	} else {
		return i_unsetbit(which, fullnum);
	}
}


/* Removes the first 4 bits of every byte in a string */
int strip4bits(char *chain, unsigned int sizeofchain)
{
	char tmpchain[MAX_KEY_LEN];
	int i, j;


	Bzero(tmpchain, sizeof(tmpchain));

	for (i = 0; i < sizeofchain + 1; i += 2) {

		for (j = 3; j >= 0; j--) {
/* puts the first last bits from chain[i] as the first four bits of tmpchain[i] */
			tmpchain[i / 2] = m_setbit(j + 4, tmpchain[i / 2], m_getbit(j, chain[i]));
		}

		if (chain[i + 1] == '\0')
			break;

		for (j = 3; j >= 0; j--) {
/* puts the first last bits from chain[i+1] as the last four bits of tmpchain[i] */
			tmpchain[i / 2] = m_setbit(j, tmpchain[i / 2], m_getbit(j, chain[i + 1]));
		}
	}

	Bzero(chain, sizeofchain);

	if (sizeofchain % 2 == 0) {
		memmove(chain, tmpchain, sizeofchain / 2);
		chain[sizeofchain / 2] = '\0';
		return (sizeofchain / 2);

	} else {
		memmove(chain, tmpchain, (sizeofchain / 2) + 1);
		chain[(sizeofchain / 2) + 1] = '\0';
		return ((sizeofchain / 2) + 1);
	}


}
