/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif
#include <keys.h>
#include <extra.h>
#include <lcrypt.h>
#include <hex.h>
#include <bzero.h>
#include <bits.h>
#include <xmalloc.h>
#include <sha1.h>

/* fixkey takes the input key (or NULL if it wasn't given) and converts
 * the key according to the needs (bit_flag)
 */

void *
 fixkey(char *key, unsigned int *len, int bit_flag, int hexflag,
     int algorithm, int quiet, int stream_flag, void *salt, int enc_mode)
{
#ifdef DEBUG
	int i;
#endif
	char *tmp;
	char *keyword;
	char tmpkey[MAX_KEY_LEN];
	int keysize;

	if (hexflag == TRUE) {
		keysize = 2 * get_key_size(algorithm);
	} else {
		keysize = get_key_size(algorithm);
	}

	Bzero(tmpkey, sizeof(tmpkey));
	keyword = xcalloc(1, get_key_size(algorithm));


	if (key == NULL) {	/* key was not specified in the command line */
		tmp = get_password(keysize, bit_flag, enc_mode, algorithm, len, salt);
		if (tmp == NULL)
			return NULL;

		if (*len > keysize)
			*len = keysize;
		memmove(tmpkey, tmp, *len);
		Bzero(tmp, *len);
	} else {		/* Key was given on the command line */
		memmove(tmpkey, key, *len);
	}


	switch (bit_flag) {
	case BITS8:
		/* If specified in hex */
		if (hexflag == TRUE) {
			*len = hexToChar(tmpkey, *len);

			if (*len == -1) {
				fprintf(stderr, _("Keyword not in proper hex format\n"));
				exit(1);
			}
		}
		if (*len > keysize) {
			fprintf(stderr, _("Warning: Reducing the size of the key\n"));
			*len = keysize;
		}
		memmove(keyword, tmpkey, *len);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		break;

	case HASH:

		/* Generate key by hashing the passphrase */
		gen_key(keyword, salt, SALT_SIZE, keysize, (void *) tmpkey, keysize);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		*len = keysize;
		break;


	case BITS4:
		*len = strip4bits(tmpkey, *len);
		if (*len > keysize) {
			fprintf(stderr, _("Warning: Reducing the size of the key\n"));
			*len = keysize;
		}
		memmove(keyword, tmpkey, *len);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		break;

	}


/* Do not ever define it */
/* It prints the key in the plain */

#ifdef DEBUG
	fprintf(stderr, "key: ");
	for (i = 0; i < *len; i++) {
		fprintf(stderr, "%.2x.", (unsigned char) keyword[i]);
	}
	fprintf(stderr, "\n");
#endif
	return keyword;

}


void gen_key(void *keyword, void *salt, size_t salt_size, size_t key_size,
	     unsigned char *password, int pass_size)
{
	unsigned char key[MAX_KEY_LEN];
	SHA1_CTX ctx;
	unsigned char *digest;
	int plen = pass_size;
	size_t size = key_size;
	unsigned char *cp = key, *cp0 = key;
	int salt_z = 0;

#ifdef DEBUG
	int i;

	fprintf(stderr, "passphrase: ");
	for (i = 0; i < pass_size; i++) {
		fprintf(stderr, "%.2x.", (unsigned char) password[i]);
	}
	fprintf(stderr, "\n");
#endif

	if (salt == NULL) {
		salt_z = 1;
	}			/* remember? no headers there */
	while (1) {
		SHA1Init(&ctx);
		if (salt_z == 0)
			SHA1Update(&ctx, salt, salt_size);
		SHA1Update(&ctx, password, plen);
		if (cp - cp0 > 0)
			SHA1Update(&ctx, cp0, cp - cp0);
		digest = SHA1Final(&ctx);
		if (size > 20) {
			memmove(cp, digest, 20);
			free(digest);
			size -= 20;
			cp += 20;
		} else {
			memmove(cp, digest, size);
			free(digest);
			break;
		}
	}
	memmove(keyword, key, key_size);
}
