/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 * Encryption/decryption library. This library is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt.h,v 1.7 1999/10/18 13:44:12 nmav Exp $ */

#define MCRYPT_API_VERSION 19991015

#ifdef __cplusplus
extern "C" {
#endif
 

#ifdef MCRYPT_BACKWARDS_COMPATIBLE
# define BLOWFISH448 0
# define DES 1 
# define TripleDES 2
# define ThreeWAY 3
# define GOST 4
# define SAFER64 6
# define SAFER128 7
# define CAST128 8
# define TEAN 9
# define RC2_1024 11
# define TWOFISH128 10
# define TWOFISH192 12
# define TWOFISH256 13
# define BLOWFISH128 14
# define BLOWFISH192 15
# define BLOWFISH256 16
# define CAST256 17
# define SAFERPLUS 18
# define LOKI97 19
# define SERPENT128 20
# define SERPENT192 21
# define SERPENT256 22
# define RIJNDAEL128 23
# define RIJNDAEL192 24
# define RIJNDAEL256 25
# define RC2_256 26
# define RC2_128 27
# define RC6_256 100
# define IDEA 101
# define RC6_128 102
# define RC6_192 103
# define CBC 0
# define ECB 1
# define CFB 2
# define OFB 3
# define nOFB 4
#endif

#define MCRYPT_BLOWFISH_448 0
#define MCRYPT_DES 1 
#define MCRYPT_3DES 2
#define MCRYPT_3WAY 3
#define MCRYPT_GOST 4
#define MCRYPT_SAFER_64 6
#define MCRYPT_SAFER_128 7
#define MCRYPT_CAST_128 8
#define MCRYPT_XTEA 9
#define MCRYPT_RC2_1024 11
#define MCRYPT_TWOFISH_128 10
#define MCRYPT_TWOFISH_192 12
#define MCRYPT_TWOFISH_256 13
#define MCRYPT_BLOWFISH_128 14
#define MCRYPT_BLOWFISH_192 15
#define MCRYPT_BLOWFISH_256 16
#define MCRYPT_CAST_256 17
#define MCRYPT_SAFERPLUS 18
#define MCRYPT_LOKI97 19
#define MCRYPT_SERPENT_128 20
#define MCRYPT_SERPENT_192 21
#define MCRYPT_SERPENT_256 22
#define MCRYPT_RIJNDAEL_128 23
#define MCRYPT_RIJNDAEL_192 24
#define MCRYPT_RIJNDAEL_256 25
#define MCRYPT_RC2_256 26
#define MCRYPT_RC2_128 27

#define MCRYPT_RC6_256 100
#define MCRYPT_IDEA 101
#define MCRYPT_RC6_128 102
#define MCRYPT_RC6_192 103
#define MCRYPT_RC4 104

#define MCRYPT_CBC 0
#define MCRYPT_ECB 1
#define MCRYPT_CFB 2
#define MCRYPT_OFB 3
#define MCRYPT_nOFB 4

#define MCRYPT_STREAM 5
#define MCRYPT_UNLIMITED_KEY 128

typedef struct mcrypt_algorithm_entry mcrypt_algorithm_entry;
typedef struct mcrypt_mode_entry mcrypt_mode_entry;

#define end_mcrypt_ecb end_mcrypt
#define end_mcrypt_stream end_mcrypt

/* generic - high level functions. These are a bit slower because
 * they perform a switch before each call but they have the advantage
 * of being able to check at run-time which modes are in the library
 * and use them
 */

int mcrypt_generic_init(const int mode,
                    const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_generic_end(const int td);
int mdecrypt_generic(int td, void *plaintext, int len);
int mcrypt_generic(int td, void *plaintext, int len);
void mcrypt_generic_term();

/* extra functions */

int mcrypt_get_block_size(int algorithm);
int mcrypt_get_key_size(int algorithm);

int is_ok_algorithm(int algorithm); /* if this algorithm exists returns 0 */
int is_ok_mode(int mode); /* if this mode exists returns 0 */
int is_block_algorithm(int algorithm); /* If this is a block algorithm returns 1 */
int is_block_mode(int mode);


char* mcrypt_get_algorithms_name(int algorithm);
char *mcrypt_get_modes_name(int mode);

void gen_key_sha1(void *keyword, void *salt, int salt_size, int key_size,
             unsigned char *password, int plen);
void gen_key_md5(void *keyword, void *salt, int salt_size, int key_size,
             unsigned char *password, int plen);



/* Functions used internally and in mcrypt (the program) */
int init_mcrypt ( const int mode, const int algorithm, int thread, void * key, int lenofkey);
int mcrypt(int thread, void *plaintext);
int mdecrypt(int thread, void *plaintext);
int end_mcrypt(int td);

/* ECB */
int init_mcrypt_ecb( const int algorithm, void * key, int lenofkey);
int mcrypt_ecb(int thread, void *plaintext,int len);
int mdecrypt_ecb(int thread, void *plaintext, int);

/* CBC */
int end_mcrypt_cbc(int td);
int mcrypt_cbc(int td, void *plaintext, int);
int mdecrypt_cbc(int td, void *ciphertext, int);
int init_mcrypt_cbc( const int algorithm, void * key, int lenofkey);
int init_mcrypt_cbc_iv( const int algorithm, void * key, int lenofkey, void *IV);

/* CFB */
int end_mcrypt_cfb(int td);
int mcrypt_cfb(int td, void *plaintext,int len);
int mdecrypt_cfb(int td, void *ciphertext, int len);
int init_mcrypt_cfb( const int algorithm, void * key, int lenofkey, void *IV);

/* OFB */
int end_mcrypt_ofb(int td);
int mcrypt_ofb(int td, void *plaintext,int len);
int mdecrypt_ofb(int td, void *ciphertext, int len);
int init_mcrypt_ofb( const int algorithm, void * key, int lenofkey, void *IV);

/* nbit OFB */
int init_mcrypt_nofb(const int algorithm, void *key, int lenofkey, void *IV);
int mcrypt_nofb(int td, void *plaintext, int len);
int mdecrypt_nofb(int td, void *plaintext, int len);
int end_mcrypt_nofb(int td);

/* STREAM */
int init_mcrypt_stream(const int algorithm, void *key, int lenofkey);
int mcrypt_stream(int td, void *plaintext, int len);
int mdecrypt_stream(int td, void *ciphertext, int len);

#ifdef __cplusplus
}
#endif
