/* Copyright (C) 1998,1999 Nikos Mavroyanopoulos This library is free
 * software; you can redistribute it and/or modify it under the terms of the
 * GNU Library General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* $Id: mcrypt_extra.c,v 1.7 1999/10/20 03:38:11 nmav Exp $ */

#ifndef LIBDEFS_H
#define LIBDEFS_H
#include <libdefs.h>
#endif
#include <bzero.h>
#include <swap.h>
#include <mcrypt.h>
#include <blowfish.h>
#include <3-way.h>
#include <gost.h>
#include <des.h>
#include <safer.h>
#include <tean.h>
#include <xmemory.h>
#include <rc2.h>
#include <rc6.h>
#include <idea.h>
#include <sha1.h>
#include <md5.h>
#include <loki97.h>
#include <rijndael.h>

#define MCRYPT_ENTRY(name, blksize, keysize, block) \
        { #name, name, blksize, keysize, block }

struct mcrypt_algorithm_entry {
	char *name;
	int id;
	size_t blocksize;
	size_t keysize;
	int block;
};

static mcrypt_algorithm_entry algorithms[] = {
	MCRYPT_ENTRY(MCRYPT_BLOWFISH_448, 8, 56, 1),
	MCRYPT_ENTRY(MCRYPT_DES, 8, 8, 1),
	MCRYPT_ENTRY(MCRYPT_3DES, 8, 24, 1),
	MCRYPT_ENTRY(MCRYPT_3WAY, 12, 12, 1),
	MCRYPT_ENTRY(MCRYPT_GOST, 8, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SAFER_64, 8, 8, 1),
	MCRYPT_ENTRY(MCRYPT_SAFER_128, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_CAST_128, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_XTEA, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_RC2_1024, 8, 128, 1),
	MCRYPT_ENTRY(MCRYPT_TWOFISH_128, 16, 16, 1),
	MCRYPT_ENTRY(MCRYPT_TWOFISH_192, 16, 24, 1),
	MCRYPT_ENTRY(MCRYPT_TWOFISH_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_BLOWFISH_128, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_BLOWFISH_192, 8, 24, 1),
	MCRYPT_ENTRY(MCRYPT_BLOWFISH_256, 8, 32, 1),
	MCRYPT_ENTRY(MCRYPT_CAST_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SAFERPLUS, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_LOKI97, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_SERPENT_128, 16, 16, 1),
	MCRYPT_ENTRY(MCRYPT_SERPENT_192, 16, 24, 1),
	MCRYPT_ENTRY(MCRYPT_SERPENT_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_RIJNDAEL_128, 16, 16, 1),
	MCRYPT_ENTRY(MCRYPT_RIJNDAEL_192, 16, 24, 1),
	MCRYPT_ENTRY(MCRYPT_RIJNDAEL_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_RC2_256, 8, 32, 1),
	MCRYPT_ENTRY(MCRYPT_RC2_128, 8, 16, 1),
	
#ifdef NON_FREE
	MCRYPT_ENTRY(MCRYPT_RC6_256, 16, 32, 1),
	MCRYPT_ENTRY(MCRYPT_IDEA, 8, 16, 1),
	MCRYPT_ENTRY(MCRYPT_RC6_128, 16, 16, 1),
	MCRYPT_ENTRY(MCRYPT_RC6_192, 16, 24, 1),
	MCRYPT_ENTRY(MCRYPT_RC4, 1, MCRYPT_UNLIMITED_KEY, 0),
#endif
	{0}
};


#define MCRYPT_LOOP(b) \
        mcrypt_algorithm_entry *p; \
                for(p = algorithms; p->name != NULL; p++) { b ; }

#define MCRYPT_ALG_LOOP(a) \
                        MCRYPT_LOOP( if(p->id == algorithm) { a; break; } )



#define MCRYPT_MODE_ENTRY(name, block) \
        { #name, name, block }

struct mcrypt_mode_entry {
	char *name;
	int id;
	int block;
};

static mcrypt_mode_entry modes[] = {
	MCRYPT_MODE_ENTRY(MCRYPT_ECB, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_CBC, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_CFB, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_OFB, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_nOFB, 1),
	MCRYPT_MODE_ENTRY(MCRYPT_STREAM, 0),
	{0}
};


#define MCRYPT_MODE_LOOP(b) \
        mcrypt_mode_entry *p; \
                for(p = modes; p->name != NULL; p++) { b ; }

#define MCRYPT_MLOOP(a) \
                        MCRYPT_MODE_LOOP( if(p->id == mode) { a; break; } )





int mcrypt_get_block_size(int algorithm)
{
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->blocksize);
	return ret;

}

int is_block_algorithm(int algorithm)
{
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->block);
	return ret;

}

int is_block_mode(int mode)
{
	int ret = 0;

	MCRYPT_MLOOP(ret = p->block);
	return ret;

}

int mcrypt_get_key_size(int algorithm)
{				/* In bytes */
	size_t ret = 0;

	MCRYPT_ALG_LOOP(ret = p->keysize);
	return ret;

}



char *mcrypt_get_algorithms_name(int algorithm)
{
	char *ret = NULL;
	char *pointerTo_;

	/* avoid prefix */
	MCRYPT_ALG_LOOP(ret = strdup(p->name + sizeof("MCRYPT_") - 1));

	if (ret != NULL) {
		pointerTo_ = strchr(ret, '_');

		while (pointerTo_ != NULL) {
			*pointerTo_ = '-';
			pointerTo_ = strchr(ret, '_');
		}
	}
	return ret;
}



int is_ok_algorithm(int algorithm)
{
	char *y = mcrypt_get_algorithms_name(algorithm);

	if (y != NULL) {
		free(y);
		return 0;
	} else {
		return 1;
	}

}

int is_ok_mode(int mode)
{				/* if this mode exists returns 0 */
	char *y = mcrypt_get_modes_name(mode);

	if (y != NULL) {
		free(y);
		return 0;
	} else {
		return 1;
	}

}




char *mcrypt_get_modes_name(int mode)
{
	char *ret = NULL;

	/* avoid prefix */
	MCRYPT_MLOOP(ret = strdup(p->name + sizeof("MCRYPT_") - 1));
	return ret;
}


/* Key generation using sha1 */
void gen_key_sha1(void *keyword, void *salt, int salt_size, int key_size,
		  unsigned char *password, int plen)
{
	word8* key=mxmalloc(MAX_KEY_LEN);
	SHA1_CTX* ctx;
	word8 *digest;
	int size = key_size;
	word8 *cp = key, *cp0 = key;
	int salt_z = 0;		/* flag to be used when freeing salt[] */

	ctx=mxmalloc(sizeof(SHA1_CTX));


	if (salt == NULL) {
		salt_z = 1;
	}
	while (1) {
		SHA1Init(ctx);
		if (salt_z == 0)
			SHA1Update(ctx, salt, salt_size);
		SHA1Update(ctx, password, plen);
		if (cp - cp0 > 0)
			SHA1Update(ctx, cp0, cp - cp0);
		digest=SHA1Final(ctx);

		if (size > 20) {
			memmove(cp, digest, 20);
			mxfree(digest, 20);
			size -= 20;
			cp += 20;
		} else {
			memmove(cp, digest, size);
			mxfree(digest, 20);
			break;
		}
	}
	memmove(keyword, key, key_size);
	mxfree( ctx, sizeof(SHA1_CTX));
	mxfree( key, MAX_KEY_LEN);
}


void gen_key_md5(void *keyword, void *salt, int salt_size, int key_size,
		 unsigned char *password, int plen)
{
	word8* key=mxmalloc(MAX_KEY_LEN);
	MD5_CTX ctx;
	word8 *digest;
	int size = key_size;
	word8 *cp = key, *cp0 = key;
	int salt_z = 0;

	if (salt == NULL) {
		salt_z = 1;
	}
	while (1) {
		MD5Init(&ctx);
		if (salt_z == 0)
			MD5Update(&ctx, salt, salt_size);
		MD5Update(&ctx, password, plen);
		if (cp - cp0 > 0)
			MD5Update(&ctx, cp0, cp - cp0);
		digest = MD5Final(&ctx);
		if (size > 16) {
			memmove(cp, digest, 16);
			free(digest);
			size -= 16;
			cp += 16;
		} else {
			memmove(cp, digest, size);
			free(digest);
			break;
		}
	}
	memmove(keyword, key, key_size);
	mxfree(key, MAX_KEY_LEN);
}
