#include "libdefs.h"
#include "rc4.h"


#define swap_byte(x,y) t = *(x); *(x) = *(y); *(y) = t

void _mcrypt_rc4_prepare_key(word8 *key_data_ptr, int key_data_len, rc4_key *key)
{
  word8 t;
  word8 index1;
  word8 index2;
  word8* state;
  short counter;

  state = &key->state[0];
  for(counter = 0; counter < 256; counter++)
  state[counter] = counter;
  key->x = 0;
  key->y = 0;
  index1 = 0;
  index2 = 0;
  for(counter = 0; counter < 256; counter++)
  {
    index2 = (key_data_ptr[index1] + state[counter] + index2) % 256;
    swap_byte(&state[counter], &state[index2]);
    index1 = (index1 + 1) % key_data_len;
  }
}

void _mcrypt_rc4(word8 *buffer_ptr, int buffer_len, rc4_key *key)
{
  word8 t;
  word8 x;
  word8 y;
  word8* state;
  word8 xorIndex;
  short counter;

  x = key->x;
  y = key->y;
  state = &key->state[0];
  for(counter = 0; counter < buffer_len; counter++)
  {
    x = (x + 1) % 256;
    y = (state[x] + y) % 256;
    swap_byte(&state[x], &state[y]);
    xorIndex = (state[x] + state[y]) % 256;
    buffer_ptr[counter] ^= state[xorIndex];
  }
  key->x = x;
  key->y = y;
}

