#include "../lib/mcrypt.h"
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

/* Prints plaintext and ciphertext in hex for all the algorithms */

/* $Id: cipher_test.c,v 1.6 1999/10/20 09:14:20 nmav Exp $ */

/* #define DEBUG */

char test0[200][200];

int main()
{

	int td, td2, i;
	int j, x = 0;
	unsigned char *keyword=NULL, *password;
	unsigned char *plaintext;
	unsigned char *ciphertext;
	unsigned char cipher_tmp[200];
	char *name;
	int blocksize;


	printf
	    ("Checking whether the algorithm's encryption/decryption work normally\n");

/* Test vectors */

strcpy(test0[MCRYPT_BLOWFISH_448], "fcd49a4067d3cd69");
strcpy(test0[MCRYPT_DES], "5e7a5743b3225f06");
strcpy(test0[MCRYPT_3DES], "16b8fcf6f4c3db32");
strcpy(test0[MCRYPT_3WAY], "b5abb66a64ac290d82643341");
strcpy(test0[MCRYPT_GOST], "83d2e50c88756c4f");
strcpy(test0[MCRYPT_SAFER_64], "159dc8215305639d");
strcpy(test0[MCRYPT_SAFER_128], "315b71216c2a290b");
strcpy(test0[MCRYPT_CAST_128], "c462f3a796f8f7db");
strcpy(test0[MCRYPT_XTEA], "0b2c71a63431d4f9");
strcpy(test0[MCRYPT_TWOFISH_128], "ef7971875d00ac002f34413b29c492f3");
strcpy(test0[MCRYPT_RC2_1024], "168a040b703fb3db");
strcpy(test0[MCRYPT_TWOFISH_192], "973cb2b8462f8c8813df142f5c366767");
strcpy(test0[MCRYPT_TWOFISH_256], "0d3bd9c48c67cf1fe53d9044e7e0fd73");
strcpy(test0[MCRYPT_BLOWFISH_128], "c068d0b9f501c2b9");
strcpy(test0[MCRYPT_BLOWFISH_192], "558f047dd7b14d48");
strcpy(test0[MCRYPT_BLOWFISH_256], "3642a34b3e573ac4");
strcpy(test0[MCRYPT_CAST_256], "e094185a0eb806b4189d996c4065df01");
strcpy(test0[MCRYPT_SAFERPLUS], "2ee31a99ada3f0a74b9b04e932bd2259");
strcpy(test0[MCRYPT_LOKI97], "952a98578ddd984c6eb4f4b5eaa175ef");
strcpy(test0[MCRYPT_SERPENT_128], "936f3ebee70380fc3639460e1df8d4f8");
strcpy(test0[MCRYPT_SERPENT_192], "296bb581916bdc4e73f9a971ec8bd59f");
strcpy(test0[MCRYPT_SERPENT_256], "6e7dab18771224762ff83ada5650d32e");
strcpy(test0[MCRYPT_RIJNDAEL_128], "619f521df0153016c221bf104ea142a9");
strcpy(test0[MCRYPT_RIJNDAEL_192], "5aaa4e8c4dc7258c3dd78103e6d1539d");
strcpy(test0[MCRYPT_RIJNDAEL_256], "3b4d203b48b41c28c5e0cf68884c9aa5");
strcpy(test0[MCRYPT_RC2_256], "3e98b3f11c95deba");
strcpy(test0[MCRYPT_RC2_128], "ffbd28e19d68e1b9");
strcpy(test0[MCRYPT_RC6_256], "1f420c8b722c5ecee2464d48bbf1ecc6");
strcpy(test0[MCRYPT_IDEA], "662348e601e28b6e");
strcpy(test0[MCRYPT_RC6_128], "acf607434006739344d8a77e6a57abd5");
strcpy(test0[MCRYPT_RC6_192], "838c9663a3802ea09b161876b299daf1");
strcpy(test0[MCRYPT_RC4], "a84f03859140d991966ebffc89ce4926d7f05ee7215c66e954cc13253b8b0057fc3db20ed7d98728eae6349bbae2a19f21d8");

	for (i = 0; i <= 150; i++) {

		if (is_ok_algorithm(i) != 0)
			continue;

		password = malloc(mcrypt_get_key_size(i));
		keyword = calloc(1, mcrypt_get_key_size(i));
		memset(password, '\2', mcrypt_get_key_size(i));
		memset(password, '\3', mcrypt_get_key_size(i) / 2);
		memset(password, '\5', mcrypt_get_key_size(i) / 4);
		gen_key_sha1(keyword, NULL, 0, mcrypt_get_key_size(i),
			     password, mcrypt_get_key_size(i));


if (is_block_algorithm(i)!=0) {
		bzero(cipher_tmp, sizeof(cipher_tmp));
		td =
		    mcrypt_generic_init(MCRYPT_ECB, i, keyword,
					mcrypt_get_key_size(i), NULL);
		td2 =
		    mcrypt_generic_init(MCRYPT_ECB, i, keyword,
					mcrypt_get_key_size(i), NULL);
} else {
		bzero(cipher_tmp, sizeof(cipher_tmp));
		td =
		    mcrypt_generic_init(MCRYPT_STREAM, i, keyword,
					mcrypt_get_key_size(i), NULL);
		td2 =
		    mcrypt_generic_init(MCRYPT_STREAM, i, keyword,
					mcrypt_get_key_size(i), NULL);
}

/*   if (td<0) {continue;} */

		name = mcrypt_get_algorithms_name(i);
		if (name == NULL)
			continue;

		printf("Algorithm: %s... ", name);
		
		blocksize = mcrypt_get_block_size(i);
		if (blocksize==1) { /* stream */
			blocksize=50;
		}
		
		ciphertext = malloc(blocksize);
		plaintext = malloc(blocksize);
		bzero(plaintext, blocksize);

		for (j=0; j< blocksize; j++) {
			plaintext[j]=j%256;
		}
		memcpy(ciphertext, plaintext, blocksize);

#ifdef DEBUG
		printf("plaintext:  ");
		for (j = 0; j < blocksize; j++) {
			printf("%.2x", ciphertext[j]);
		}
#endif

#ifdef DEBUG
		printf("\nkeyword:    ");
		for (j = 0; j < mcrypt_get_key_size(i); j++) {
			printf("%.2x", keyword[j]);
		}
#endif

		mcrypt_generic(td, ciphertext, blocksize);

#ifdef DEBUG
		printf("\nciphertext: ");
#endif
		for (j = 0; j < blocksize; j++) {
			sprintf(&((char *) cipher_tmp)[2 * j], "%.2x",
				ciphertext[j]);
		}

#ifdef DEBUG
		printf("%s\n", cipher_tmp);
#endif


#ifndef DEBUG
		if (strcmp( (char*)cipher_tmp, test0[i]) != 0) {
			printf("failed compatibility\n");
			x = 1;
			mcrypt_generic_end(td);
			mcrypt_generic_end(td2);
			free(name);
			free(keyword);
			free(ciphertext);
			free(plaintext);
			free(password);
			continue;
		}
#endif

#ifdef DEBUG
		printf("\n");
#endif

#ifndef DEBUG
		mdecrypt_generic(td2, ciphertext, blocksize);
		if (memcmp(ciphertext, plaintext, blocksize)
		    != 0) {
			printf("failed internally\n");
			x = 1;
			mcrypt_generic_end(td);
			mcrypt_generic_end(td2);
			free(name);
			free(keyword);
			free(ciphertext);
			free(plaintext);
			free(password);
			continue;
		}

		printf("ok\n");
#endif

		mcrypt_generic_end(td);
		mcrypt_generic_end(td2);
		free(name);
		free(keyword);
		free(ciphertext);
		free(plaintext);
		free(password);
	}

	return x;

}
