/*
 * UFC-crypt: ultra fast crypt(3) implementation
 *
 * Copyright (C) 1991, 1992, Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * @(#)ufc-crypt.h	1.13 2/22/92
 *
 * Definitions of datatypes 
 * 
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
/* 
 * Requirements for datatypes:
 * 
 * A datatype 'ufc_long' of at least 32 bit
 * *and*
 *   A type 'long32' of exactly 32 bits (_UFC_32_)
 *   *or*
 *   A type 'long64' of exactly 64 bits (_UFC_64_)
 *
 * 'int' is assumed to be at least 8 bit
 */

/*
 * #ifdef's for various architectures
 */

/* Changed to fit the needs in mcrypt */

#if SIZEOF_UNSIGNED_LONG_INT == 8
# define _UFC_64_
typedef unsigned long int     long64;
typedef unsigned long int     ufc_long;
#endif

#ifndef _UFC_64_
# if SIZEOF_UNSIGNED_LONG_INT == 4
#  define _UFC_32_
typedef unsigned long int     long32;
typedef unsigned long int     ufc_long;
# endif
#endif

#ifndef _UFC_64_
# ifndef _UFC_32_
#  if SIZEOF_UNSIGNED_INT == 4
#   define _UFC_32_
typedef unsigned int     long32;
typedef unsigned int     ufc_long;
#  endif
# endif
#endif

/*
 * Catch all for 99.95% of all UNIX machines
 */

#ifndef _UFC_64_
# ifndef _UFC_32_
#  define _UFC_32_
typedef unsigned      ufc_long;
typedef unsigned long long32;
# endif
#endif
