/*    Copyright (C) 1998,1999 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: des-compat.c,v 1.1 1999/10/17 12:38:03 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif

#include <mcrypt.h>
#include <xmalloc.h>
#include <bzero.h>
#include <extra.h>
#include <bits.h>
#include "../libmcrypt/lib/mcrypt.h"
#include <unlink.h>
#include <crc32.h>
#include <locks.h>
#include <enigma.h>
#include <hex.h>
#include <random.h>
#include <errors.h>
#include <swap.h>
#include "../libmcrypt/lib/xmemory.h"
#include <des-compat.h>


extern int bit_flag;
extern int stream_flag;
extern int gzipflag;
extern int bzipflag;
extern char tmperr[128];
extern int type;
extern int quiet;
extern int hexflag;
extern int flush;
extern int mode;

/* Solaris DES Encryption */

int encrypt_desc(char *fromfile, char *tofile, char *key)
{
	unsigned int len;
	char *keyword=mxmalloc(8);
	char *tmp;
	FILE *TOF;
	FILE *FROMF;
	char *command = NULL;
	int cnt, c, i, td;
	char work[8];
	char iv[8];

/* Crypt does not care about these 
 * It's purpose is to be compatible with the unix crypt which is not safe.
 * It isn't a block algorithm after all.
 */
	bit_flag = BITS8;


/* open files */
	if (stream_flag == TRUE) {
		FROMF = stdin;
		TOF = stdout;
	} else {
#ifdef ZIP
		if (gzipflag == FALSE && bzipflag == FALSE) {
#endif
			FROMF = fopen(fromfile, "rb");
			if (FROMF == NULL) {
				perror("fopen");
				return 1;
			}
			if (read_lock(fileno((FILE *) FROMF)) == -1)
				return 1;

			TOF = fopen(tofile, "wb");
			if (TOF == NULL) {
				perror("fopen");
				return -1;
			}
			if (write_lock(fileno((FILE *) TOF)) == -1)
				return -1;
#ifdef ZIP
		} else {
			/* command if using gzip */
			if (gzipflag == TRUE) {
				command = malloc(strlen(GZIP) + strlen(fromfile) + 5);
				strcpy(command, GZIP);
			}
			if (bzipflag == TRUE) {
				command = malloc(strlen(BZIP2) + strlen(fromfile) + 5);
				strcpy(command, BZIP2);
			}
			strcat(command, " -c ");
			strcat(command, fromfile);

			FROMF = popen(command, "r");

			if (FROMF == NULL) {
				perror("popen");
				return 1;
			}
			TOF = fopen(tofile, "wb");
			if (TOF == NULL) {
				perror("fopen");
				return -1;
			}
			if (write_lock(fileno((FILE *) TOF)) == -1)
				return -1;

		}
#endif				/* ZIP */
	}

	Bzero(keyword, 8);

	if (key == NULL) {
		if (stream_flag == FALSE) {
			sprintf(tmperr, _("File: %s\n"), fromfile);
			err_warn(tmperr);
		}
		tmp = get_password(8, bit_flag, DECRYPT, type, &len, NULL);
		if (tmp == NULL)
			return 1;
		memmove(keyword, tmp, len);
		Bzero(tmp, strlen(tmp));
	} else {
		if (strlen(key) > 8) {
			key[8] = '\0';
			err_warn(_("Warning: Reducing the size of the key\n"));
		}
		memmove(keyword, key, strlen(key));	/* Copy the 64 bits in key */
	}

	if (quiet == FALSE)
		show_mode(ENCRYPT, type, mode, tofile, bit_flag);

	if (hexflag == FALSE) {
		for (cnt = 0; cnt < 8; cnt++) {
			c = 0;
			for (i = 0; i < 7; i++)
				if (keyword[cnt] & (1 << i))
					c++;
			if ((c & 1) == 0)
				keyword[cnt] |= 0x80;
			else
				keyword[cnt] &= ~0x80;
		}
	}
	switch (mode) {
	case MCRYPT_ECB:

		td = init_mcrypt_ecb(MCRYPT_DES, keyword, mcrypt_get_key_size(MCRYPT_DES));

		for (;;) {
			if ((cnt = fread(work, 1, 8, FROMF)) != 8) {
				/* Put residual byte count in the last block.
				 * Note that garbage is left in the other bytes,
				 * if any; this is a feature, not a bug, since it'll
				 * be stripped out at decrypt time.
				 */
				work[7] = cnt;
			}
			mcrypt_ecb(td, work, 8);	/* Encrypt block */

			if (fwrite(work, 1, 8, TOF) < 8) {
				perror("fwrite");
				return -1;
			}
						if (flush==TRUE) fflush(TOF);
			if (cnt != 8)
				break;
		}
		end_mcrypt_ecb(td);
		break;


	case MCRYPT_CBC:
		td = init_mcrypt_cbc(MCRYPT_DES, keyword, mcrypt_get_key_size(MCRYPT_DES));
		Bzero(iv, 8);

		for (;;) {

			if ((cnt = fread(work, 1, 8, FROMF)) != 8) {
				/* Put residual byte count in the last block.
				 * Note that garbage is left in the other bytes,
				 * if any; this is a feature, not a bug, since it'll
				 * be stripped out at decrypt time.
				 */
				work[7] = cnt;
			}
			mcrypt_cbc(td, work, 8);	/* Encrypt block */

			memcpy(iv, work, 8);
			if (fwrite(work, 1, 8, TOF)<8) {
				perror("fwrite");
				return -1;
			}
						if (flush==TRUE) fflush(TOF);
			if (cnt != 8)
				break;
		}
		end_mcrypt_cbc(td);

		break;
	default:
		return 1;
	}


	fclose(FROMF);
	fclose(TOF);

	mxfree(keyword, 8);
	return 0;
}



/* Solaris DES Decryption */

int decrypt_desc(char *fromfile, char *tofile, char *key)
{
	unsigned int len;
	char *keyword=mxmalloc(8);
	char *tmp;
	FILE *TOF;
	FILE *FROMF;
	char *command = NULL;
	int cnt, c, i, td;
	char work[8], nwork[8];
	char iv[8];

/* Crypt does not care about these 
 * It's purpose is to be compatible with the unix crypt which is not safe.
 * It isn't a block algorithm after all.
 */
	bit_flag = BITS8;


/* open files */
	if (stream_flag == TRUE) {
		FROMF = stdin;
		TOF = stdout;
	} else {
#ifdef ZIP
		if (gzipflag == FALSE && bzipflag == FALSE) {
#endif
			FROMF = fopen(fromfile, "rb");
			if (FROMF == NULL) {
				perror("fopen");
				return 1;
			}
			if (read_lock(fileno((FILE *) FROMF)) == -1)
				return 1;

			TOF = fopen(tofile, "wb");
			if (TOF == NULL) {
				perror("fopen");
				return -1;
			}
			if (write_lock(fileno((FILE *) TOF)) == -1)
				return -1;
#ifdef ZIP
		} else {
			/* command if using gzip */
			if (gzipflag == TRUE) {
				command = malloc(strlen(GZIP) + strlen(fromfile) + 5);
				strcpy(command, GZIP);
			}
			if (bzipflag == TRUE) {
				command = malloc(strlen(BZIP2) + strlen(fromfile) + 5);
				strcpy(command, BZIP2);
			}
			strcat(command, " -c ");
			strcat(command, fromfile);

			FROMF = popen(command, "r");

			if (FROMF == NULL) {
				perror("popen");
				return 1;
			}
			TOF = fopen(tofile, "wb");
			if (TOF == NULL) {
				perror("fopen");
				return -1;
			}
			if (write_lock(fileno((FILE *) TOF)) == -1)
				return -1;

		}
#endif
	}

	Bzero(keyword, 8);

	if (key == NULL) {
		if (stream_flag == FALSE) {
			sprintf(tmperr, _("File: %s\n"), fromfile);
			err_warn(tmperr);
		}
		tmp = get_password(8, bit_flag, DECRYPT, type, &len, NULL);
		if (tmp == NULL)
			return 1;
		memmove(keyword, tmp, len);
		Bzero(tmp, strlen(tmp));
	} else {
		if (strlen(key) > 8) {
			key[8] = '\0';
			err_warn(_("Warning: Reducing the size of the key\n"));
		}
		memmove(keyword, key, strlen(key));	/* Copy the 64 bits in key */
	}


	if (quiet == FALSE)
		show_mode(ENCRYPT, type, mode, tofile, bit_flag);

	if (hexflag == FALSE) {
		for (cnt = 0; cnt < 8; cnt++) {
			c = 0;
			for (i = 0; i < 7; i++) {
				if (keyword[cnt] & (1 << i))
					c++;
			}
			if ((c & 1) == 0)
				keyword[cnt] |= 0x80;
			else
				keyword[cnt] &= ~0x80;
		}
	}
	switch (mode) {
	case MCRYPT_ECB:
		td = init_mcrypt_ecb(MCRYPT_DES, keyword, mcrypt_get_key_size(MCRYPT_DES));

		cnt = fread(work, 1, 8, FROMF);		/* Prime the pump */
		for (;;) {
			mdecrypt_ecb(td, work, 8);

			/* Save buffer pending next read */
			memcpy(nwork, work, 8);

			/* Try to read next block */
			cnt = fread(work, 1, 8, FROMF);
			if (cnt != 8) {		/* Can "only" be 0 if not 8 */
				/* Prev block was last one, write appropriate number
				 * of bytes
				 */
				cnt = nwork[7];
				if (cnt < 0 || cnt > 7) {
					fprintf(stderr, _("Corrupted file or wrong key\n"));
					return 1;
				} else if (cnt != 0)
					if (fwrite(nwork, 1, cnt, TOF)<cnt) {
						perror("fwrite");
						return -1;
					}
								if (flush==TRUE) fflush(TOF);
				return 0;
			} else {
				/* Now okay to write previous buffer */
				if (fwrite(nwork, 1, 8, TOF)<8) {
					perror("fwrite");
					return -1;
				}
							if (flush==TRUE) fflush(TOF);
			}

		}
		end_mcrypt_ecb(td);
		break;
		
	case MCRYPT_CBC:

		td = init_mcrypt_cbc(MCRYPT_DES, keyword, mcrypt_get_key_size(MCRYPT_DES));
		Bzero(iv, 8);
		cnt = fread(work, 1, 8, FROMF);		/* Prime the pump */
		for (;;) {
			mdecrypt_cbc(td, work, 8);

			/* Save buffer pending next read */
			memmove(nwork, work, 8);
			/* Try to read next block */
			cnt = fread(work, 1, 8, FROMF);
			if (cnt != 8) {		/* Can "only" be 0 if not 8 */
				/* Prev block was last one, write appropriate number
				 * of bytes
				 */
				cnt = nwork[7];
				if (cnt < 0 || cnt > 7) {
					fprintf(stderr, _("Corrupted file or wrong key\n"));
					return 1;
				} else if (cnt != 0)
					if (fwrite(nwork, 1, cnt, TOF)<cnt) {
						perror("fwrite");
						return -1;
					}
								if (flush==TRUE) fflush(TOF);
				exit(0);
			} else {
				/* Now okay to write previous buffer */
				if (fwrite(nwork, 1, 8, TOF)<8) {
					perror("fwrite");
					return -1;
				}				
							if (flush==TRUE) fflush(TOF);
			}
		}
		end_mcrypt_cbc(td);
		break;
	}

	fclose(FROMF);
	fclose(TOF);

	mxfree(keyword, 8);
	return 0;

}
