/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: keys.c,v 1.2 1999/10/17 09:29:00 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif
#include "../libmcrypt/lib/mcrypt.h"
#include "../libmcrypt/lib/xmemory.h"
#include <extra.h>
#include <mcrypt.h>
#include <hex.h>
#include <bzero.h>
#include <bits.h>
#include <xmalloc.h>

static char rcsid[] = "$Id: keys.c,v 1.2 1999/10/17 09:29:00 nmav Exp $";

/* fixkey takes the input key (or NULL if it wasn't given) and converts
 * the key according to the needs (bit_flag)
 */

void *
 fixkey(char *key, unsigned int *len, int bit_flag, int hexflag,
     int algorithm, int quiet, int stream_flag, void *salt, int enc_mode)
{
#ifdef DEBUG
	int i;
#endif
	char *tmp;
	char *keyword;
	char *tmpkey;
	int keysize;

	if (hexflag == TRUE) {
		keysize = 2 * mcrypt_get_key_size(algorithm);
	} else {
		keysize = mcrypt_get_key_size(algorithm);
	}

        tmpkey=xcalloc(1, MAX_KEY_LEN);
	keyword = xcalloc(1, mcrypt_get_key_size(algorithm));


	if (key == NULL) {	/* key was not specified in the command line */
		tmp = get_password(keysize, bit_flag, enc_mode, algorithm, len, salt);
		if (tmp == NULL)
			return NULL;

		if (*len > MAX_KEY_LEN)
			*len = MAX_KEY_LEN;
		memmove(tmpkey, tmp, *len);
		mxfree(tmp, *len);
	} else {		/* Key was given on the command line */
		if (*len > MAX_KEY_LEN)
			*len = MAX_KEY_LEN;
		memmove(tmpkey, key, *len);
	}


	switch (bit_flag) {
	case BITS8:
		/* If specified in hex */
		if (hexflag == TRUE) {
			*len = hexToChar(tmpkey, *len);

			if (*len == -1) {
				fprintf(stderr, _("Keyword not in proper hex format\n"));
				exit(1);
			}
		}

		if (*len > keysize) {
			fprintf(stderr, _("Warning: Reducing the size of the key\n"));
			*len = keysize;
		}
		memmove(keyword, tmpkey, *len);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		break;

	case SHA1HASH:

		/* Generate key by hashing the passphrase */
		gen_key_sha1(keyword, salt, SALT_SIZE, keysize, (void *) tmpkey, keysize);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		*len = keysize;
		break;

	case MD5HASH:

		/* Generate key by hashing the passphrase */
		gen_key_md5(keyword, salt, SALT_SIZE, keysize, (void *) tmpkey, keysize);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		*len = keysize;
		break;


	case BITS4:
		*len = strip4bits(tmpkey, *len);
		if (*len > keysize) {
			fprintf(stderr, _("Warning: Reducing the size of the key\n"));
			*len = keysize;
		}
		memmove(keyword, tmpkey, *len);
		break;

	}


/* Do not ever define it */
/* It prints the key in the plain */

#ifdef DEBUG
	fprintf(stderr, "keylen: %d\n", keysize);
	fprintf(stderr, "key: ");
	for (i = 0; i < *len; i++) {
		fprintf(stderr, "%.2x.", (unsigned char) keyword[i]);
	}
	fprintf(stderr, "\n");
#endif

	mxfree(tmpkey, *len);
	return keyword;

}


