/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: locks.c,v 1.1.1.1 1999/10/15 22:49:23 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif

#ifndef HAVE_FCNTL
#ifndef NO_FCNTL_LOCK
#define NO_FCNTL_LOCK
#endif
#endif

#ifndef HAVE_UNISTD_H
#ifndef NO_FCNTL_LOCK
#define NO_FCNTL_LOCK
#endif
#endif

#include "locks.h"
#include "functions.h"
/* Derived from Unix faq */

#define LOCK_TIMEOUT 5
/* Five seconds lock timeout */

extern int nolock; /* Perform locks? */

#ifndef NO_FCNTL_LOCK
struct flock *
 file_lock(short type, short whence)
{
	static struct flock ret;
	ret.l_type = type;
	ret.l_start = 0;
	ret.l_whence = whence;
	ret.l_len = 0;
	ret.l_pid = getpid();
	return &ret;
}

int read_lock(int fd)
{				/* a shared lock on an entire file */
	int x;

    if (nolock==FALSE) {
	Sigfunc *old = Signal(SIGALRM, time_out);
	alarm(LOCK_TIMEOUT);

	x = fcntl(fd, F_SETLKW, file_lock(F_RDLCK, SEEK_SET));

	alarm(0);
	Signal(SIGALRM, old);
	return x;
    } else {
        return 0;
    }
}

int write_lock(int fd)
{				/* an exclusive lock on an entire file */
	int x;

    if (nolock==FALSE) {
	Sigfunc *old = Signal(SIGALRM, time_out);
	alarm(LOCK_TIMEOUT);

	x = fcntl(fd, F_SETLKW, file_lock(F_WRLCK, SEEK_SET));
	alarm(0);
	Signal(SIGALRM, old);
	return x;
    } else {
        return 0;
    }	
}

int append_lock(int fd)
 /* a lock on the _end_ of a file -- other
  * processes may access existing records 
  */
{
	int x;

    if (nolock==FALSE) {
	Sigfunc *old = Signal(SIGALRM, time_out);
	alarm(LOCK_TIMEOUT);

	x = fcntl(fd, F_SETLKW, file_lock(F_WRLCK, SEEK_END));
	alarm(0);
	Signal(SIGALRM, old);
	return x;
    } else {
        return 0;
    }
}

void unlock(int fd)
{				/* unlock */
    if (nolock==FALSE) {
	fcntl(fd, F_SETLK, file_lock(F_UNLCK, SEEK_END));
    }
}

#else				/* no fcntl, so do nothing */
void file_lock(short type, short whence)
{
}

int read_lock(int fd)
{
	return 0;
}

int write_lock(int fd)
{
	return 0;
}

int append_lock(int fd)
{
	return 0;
}

void unlock(int fd)
{				/* unlock */
}

#endif

void time_out(int signo)
{

	fprintf(stderr, _("Timeout while waiting for file lock.\n"));
	/*exit(-1); */
}
