/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: keys.c,v 1.11 2000/03/07 05:37:00 nikos Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif
#include <extra.h>
#include <xmalloc.h>

static char rcsid[] = "$Id: keys.c,v 1.11 2000/03/07 05:37:00 nikos Exp $";


int mcrypt_gen_key ( char* keymode, void* keyword, int keysize, 
	void* salt, int saltsize, word8* password, int plen) {

	keygenid id=0;
	hashid algo=0;

	if (strcasecmp(keymode, "asis")==0) id=KEYGEN_ASIS;
	if (strcasecmp(keymode, "hex")==0) id=KEYGEN_HEX;
	if (strcasecmp(keymode, "pkdes")==0) id=KEYGEN_PKDES;
	if (strcasecmp(keymode, "mcrypt-sha1")==0) {id=KEYGEN_MCRYPT; algo=MHASH_SHA1;}
	if (strcasecmp(keymode, "mcrypt-md5")==0) {id=KEYGEN_ASIS; algo=MHASH_MD5;}
	if (strcasecmp(keymode, "s2k-simple-md5")==0) {id=KEYGEN_S2K_SIMPLE; algo=MHASH_MD5;}
	if (strcasecmp(keymode, "s2k-simple-sha1")==0) {id=KEYGEN_S2K_SIMPLE; algo=MHASH_SHA1;}
	if (strcasecmp(keymode, "s2k-salted-md5")==0) {id=KEYGEN_S2K_SALTED; algo=MHASH_MD5;}
	if (strcasecmp(keymode, "s2k-salted-sha1")==0) {id=KEYGEN_S2K_SALTED; algo=MHASH_SHA1;}
	if (strcasecmp(keymode, "s2k-isalted-md5")==0) {id=KEYGEN_S2K_ISALTED; algo=MHASH_MD5;}
	if (strcasecmp(keymode, "s2k-isalted-sha1")==0) {id=KEYGEN_S2K_ISALTED; algo=MHASH_SHA1;}
	
	return mhash_keygen( id, algo, 0,keyword, keysize, salt, saltsize, password, plen);
}



/* fixkey takes the input key (or NULL if it wasn't given) and converts it
 */

void *
 fixkey(char *key, unsigned int *len, char* keymode, int keysize,
     int quiet, int stream_flag, void *salt, int salt_size, int enc_mode)
{
#ifdef DEBUG
	int i;
	unsigned char* psalt=salt;
#endif
	char *tmp;
	char *keyword;
	char *tmpkey;

        tmpkey=xcalloc(1, MAX_KEY_LEN);
	keyword = xcalloc(1, keysize);


	if (key == NULL) {	/* key was not specified in the command line */
		tmp = get_password(keysize, enc_mode, len, salt);
		if (tmp == NULL)
			return NULL;

		if (*len > MAX_KEY_LEN)
			*len = MAX_KEY_LEN;
		memmove(tmpkey, tmp, *len);
#ifndef NO_GETPASS
		mxfree(tmp, *len);
#else
		Bzero(tmp, strlen(tmp));
#endif
	} else {		/* Key was given on the command line */
		if (*len > MAX_KEY_LEN)
			*len = MAX_KEY_LEN;
		memmove(tmpkey, key, *len);
	}


		/* Generate key by hashing the passphrase */
		if (salt_size==0) salt=NULL;
		mcrypt_gen_key( keymode, keyword, keysize, salt, salt_size, 
					(void *) tmpkey, *len);
		Bzero(tmpkey, *len);	/* key is not bzero'd because it may be used again */
		*len = keysize;

/* Do not ever define it */
/* It prints the key in the plain */

#ifdef DEBUG
	fprintf(stderr, "keylen: %d\n", keysize);

	fprintf(stderr, "key: ");
	for (i = 0; i < *len; i++) {
		fprintf(stderr, "%.2x.", (unsigned char) keyword[i]);
	}
	fprintf(stderr, "\n");
	fprintf(stderr, "salt: ");
	if (salt!=NULL) {
	for (i = 0; i < salt_size; i++) {
		fprintf(stderr, "%.2x.", psalt[i]);
	}
	fprintf(stderr, "\n");
	}
#endif

	mxfree(tmpkey, *len);
	return keyword;

}


keygenid _which_algo ( char* keymode) {

	if (strcasecmp(keymode, "asis")==0) return KEYGEN_ASIS;
	if (strcasecmp(keymode, "hex")==0) return KEYGEN_HEX;
	if (strcasecmp(keymode, "pkdes")==0) return KEYGEN_PKDES;
	if (strcasecmp(keymode, "mcrypt-sha1")==0) return KEYGEN_MCRYPT;
	if (strcasecmp(keymode, "mcrypt-md5")==0) return KEYGEN_ASIS;
	if (strcasecmp(keymode, "s2k-simple-md5")==0) return KEYGEN_S2K_SIMPLE;
	if (strcasecmp(keymode, "s2k-simple-sha1")==0) return KEYGEN_S2K_SIMPLE;
	if (strcasecmp(keymode, "s2k-salted-md5")==0) return KEYGEN_S2K_SALTED;
	if (strcasecmp(keymode, "s2k-salted-sha1")==0) return KEYGEN_S2K_SALTED;
	if (strcasecmp(keymode, "s2k-isalted-md5")==0) return KEYGEN_S2K_ISALTED;
	if (strcasecmp(keymode, "s2k-isalted-sha1")==0) return KEYGEN_S2K_ISALTED;

	return -1;
}
