#define rotl(x,n)   (((x) << ((word32)(n))) | ((x) >> (32 - (word32)(n))))
#define rotr(x,n)   (((x) >> ((word32)(n))) | ((x) << (32 - (word32)(n))))
#define rotl16(x,n)   (((x) << ((word16)(n))) | ((x) >> (16 - (word16)(n))))
#define rotr16(x,n)   (((x) >> ((word16)(n))) | ((x) << (16 - (word16)(n))))
#define byteswap(x)	((rotl(x, 8) & 0x00ff00ff) | (rotr(x, 8) & 0xff00ff00))
#define byteswap_16(x)	((rotl16(x, 8) & 0x00ff) | (rotr16(x, 8) & 0xff00))

void Bzero( void *s, size_t n); 

int mcrypt_get_block_size(int thread);
int mcrypt_get_algo_iv_size(int thread);

void internal_end_mcrypt(int thread);
int internal_init_mcrypt(int thread, void* key, int len, void* IV);
void mcrypt_block_encrypt(int thread, void* block);
void mcrypt_block_decrypt(int thread, void* block);
void mcrypt_stream_encrypt(int thread, void* data, int len);
void mcrypt_stream_decrypt(int thread, void* data, int len);
int __mcrypt_get_block_size(int thread);

void *mxmalloc(size_t size);
void *mxcalloc(size_t nmemb, size_t size);
void *mxrealloc(void *ptr, size_t size);
void mxfree( void *ptr, size_t size);
