/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LIBDEFS_H
# define LIBDEFS_H
# include <libdefs.h>
#endif

#include <bzero.h>
#include <xmemory.h>

/* memory allocation */

void *mxmalloc(size_t size) {
char *x;

 x=malloc(size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(1);
  x=malloc(size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory\n"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;
}

void *mxcalloc(size_t nmemb, size_t size) {
char *x;

 x=calloc(nmemb, size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(1);
  x=calloc(nmemb, size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory\n"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;

}

void *mxrealloc(void *ptr, size_t size) {
char *x;

 x=realloc(ptr, size);
 if (x!=NULL) {
  return x;
 }
 else {
  sleep(1);
  x=realloc(ptr, size);
  if (x!=NULL) {
   return x;
  }
  else {
   fprintf(stderr, ("Cannot allocate memory\n"));
   exit(-1);
  }
 }
/* Not really needed */
 return x;

}


