#define end_mcrypt_ecb end_mcrypt

int get_block_size(int algorithm);
int get_key_size(int algorithm); /* returns key in bytes */

int is_ok_algorithm(int algorithm); /* if this algorithm exists returns 0 */
int is_ok_mode(int mode); /* if this mode exists returns 0 */

char* get_algorithms_name(int algorithm);

int init_mcrypt ( const int algorithm, int thread, void * key, int lenofkey);
int mcrypt(int thread, void *plaintext);
int mdecrypt(int thread, void *plaintext);
int end_mcrypt(int td);

/* ECB */
int init_mcrypt_ecb( const int algorithm, void * key, int lenofkey);
int mcrypt_ecb(int thread, void *plaintext,int len);
int mdecrypt_ecb(int thread, void *plaintext, int);

/* CBC */
int end_mcrypt_cbc(int td);
int mcrypt_cbc(int td, void *plaintext, int);
int mdecrypt_cbc(int td, void *ciphertext, int);
int init_mcrypt_cbc( const int algorithm, void * key, int lenofkey);

/* CFB */
int end_mcrypt_cfb(int td);
int mcrypt_cfb(int td, void *plaintext,int len);
int mdecrypt_cfb(int td, void *ciphertext, int len);
int init_mcrypt_cfb( const int algorithm, void * key, int lenofkey, void *IV);

/* OFB */
int end_mcrypt_ofb(int td);
int mcrypt_ofb(int td, void *plaintext,int len);
int mdecrypt_ofb(int td, void *ciphertext, int len);
int init_mcrypt_ofb( const int algorithm, void * key, int lenofkey, void *IV);


# define BLOWFISH 0
# define DES 1 
# define TripleDES 2
# define ThreeWAY 3
# define GOST 4

#ifdef MCRYPT2
# define CRYPT 50
# define DES_COMPAT 51
#endif

# define SAFER64 6
# define SAFER128 7
# define CAST128 8
# define TEAN 9
# define RC2 11
# define TWOFISH128 10
# define TWOFISH192 12
# define TWOFISH256 13

#ifdef NON_FREE
# define RC6 100
# define IDEA 101
#endif

/* Only needed in mcrypt */

#define CBC 0
#define ECB 1
#define CFB 2
#define OFB 3
