/* This is an independent implementation of the encryption algorithm:   */
/*                                                                      */
/*         RC6 by Ron Rivest and RSA Labs                               */
/*                                                                      */
/* which is a candidate algorithm in the Advanced Encryption Standard   */
/* programme of the US National Institute of Standards and Technology.  */
/*                                                                      */
/* Copyright in this implementation is held by Dr B R Gladman but I     */
/* hereby give permission for its free direct or derivative use subject */
/* to acknowledgment of its origin and compliance with any conditions   */
/* that the originators of the algorithm place on its exploitation.     */
/*                                                                      */
/* Dr Brian Gladman (gladman@seven77.demon.co.uk) 14th January 1999     */

/* modified for mcrypt */

/* Timing data for RC6 (rc6.c)

128 bit key:
Key Setup:    1632 cycles
Encrypt:       270 cycles =    94.8 mbits/sec
Decrypt:       226 cycles =   113.3 mbits/sec
Mean:          248 cycles =   103.2 mbits/sec

192 bit key:
Key Setup:    1885 cycles
Encrypt:       267 cycles =    95.9 mbits/sec
Decrypt:       235 cycles =   108.9 mbits/sec
Mean:          251 cycles =   102.0 mbits/sec

256 bit key:
Key Setup:    1877 cycles
Encrypt:       270 cycles =    94.8 mbits/sec
Decrypt:       227 cycles =   112.8 mbits/sec
Mean:          249 cycles =   103.0 mbits/sec

*/

#include "libdefs.h"
#include "rc6.h"
#include "swap.h"

#define f_rnd(i,a,b,c,d)                    \
        u = rotl(d * (d + d + 1), 5);       \
        t = rotl(b * (b + b + 1), 5);       \
        a = rotl(a ^ t, u) + l_key[i];      \
        c = rotl(c ^ u, t) + l_key[i + 1]

#define i_rnd(i,a,b,c,d)                    \
        u = rotl(d * (d + d + 1), 5);       \
        t = rotl(b * (b + b + 1), 5);       \
        c = rotr(c - l_key[i + 1], t) ^ u;  \
        a = rotr(a - l_key[i], u) ^ t

/* word32  l_key[44];   storage for the key schedule         */

/* initialise the key schedule from the user supplied key   */

void _mcrypt_rc6_set_key(word32 * l_key, const word32 in_key[],
			 const word32 key_len)
{
	word32 i, j, k, a, b, l[8], t;

	l_key[0] = 0xb7e15163;

	for (k = 1; k < 44; ++k) {
		l_key[k] = l_key[k - 1] + 0x9e3779b9;
	}

	for (k = 0; k < key_len / sizeof(word32); ++k) {
#ifdef WORDS_BIGENDIAN
		l[k] = byteswap(in_key[k]);
#else
		l[k] = in_key[k];
#endif
	}

	t = (key_len / sizeof(word32)) - 1;
/*     t = (key_len / sizeof(word32)); */

	a = b = i = j = 0;

	for (k = 0; k < 132; ++k) {
		a = rotl(l_key[i] + a + b, 3);
		b += a;
		b = rotl(l[j] + b, b);
		l_key[i] = a;
		l[j] = b;

		i = (i == 43 ? 0 : i + 1);
		j = (j == t ? 0 : j + 1);

/*        i = (i + 1) % 44;
 *        j = (j + 1) % t;
 */
	}

}

/* encrypt a block of text  */

void _mcrypt_rc6_encrypt(word32 * l_key, word32 * _blk)
{
	word32 a, b, c, d, t, u;

#ifdef WORDS_BIGENDIAN
	a = byteswap(_blk[0]);
	b = byteswap(_blk[1]) + l_key[0];
	c = byteswap(_blk[2]);
	d = byteswap(_blk[3]) + l_key[1];
#else
	a = _blk[0];
	b = _blk[1] + l_key[0];
	c = _blk[2];
	d = _blk[3] + l_key[1];
#endif

	f_rnd(2, a, b, c, d);
	f_rnd(4, b, c, d, a);
	f_rnd(6, c, d, a, b);
	f_rnd(8, d, a, b, c);
	f_rnd(10, a, b, c, d);
	f_rnd(12, b, c, d, a);
	f_rnd(14, c, d, a, b);
	f_rnd(16, d, a, b, c);
	f_rnd(18, a, b, c, d);
	f_rnd(20, b, c, d, a);
	f_rnd(22, c, d, a, b);
	f_rnd(24, d, a, b, c);
	f_rnd(26, a, b, c, d);
	f_rnd(28, b, c, d, a);
	f_rnd(30, c, d, a, b);
	f_rnd(32, d, a, b, c);
	f_rnd(34, a, b, c, d);
	f_rnd(36, b, c, d, a);
	f_rnd(38, c, d, a, b);
	f_rnd(40, d, a, b, c);

#ifndef WORDS_BIGENDIAN
	_blk[0] = a + l_key[42];
	_blk[1] = b;
	_blk[2] = c + l_key[43];
	_blk[3] = d;
#else
	_blk[0] = byteswap(a + l_key[42]);
	_blk[1] = byteswap(b);
	_blk[2] = byteswap(c + l_key[43]);
	_blk[3] = byteswap(d);
#endif

}

/* decrypt a block of text  */

void _mcrypt_rc6_decrypt(word32 * l_key, word32 * _blk)
{
	word32 a, b, c, d, t, u;

#ifndef WORDS_BIGENDIAN
	d = _blk[3];
	c = _blk[2] - l_key[43];
	b = _blk[1];
	a = _blk[0] - l_key[42];
#else
	d = byteswap(_blk[3]);
	c = byteswap(_blk[2]) - l_key[43];
	b = byteswap(_blk[1]);
	a = byteswap(_blk[0]) - l_key[42];
#endif

	i_rnd(40, d, a, b, c);
	i_rnd(38, c, d, a, b);
	i_rnd(36, b, c, d, a);
	i_rnd(34, a, b, c, d);
	i_rnd(32, d, a, b, c);
	i_rnd(30, c, d, a, b);
	i_rnd(28, b, c, d, a);
	i_rnd(26, a, b, c, d);
	i_rnd(24, d, a, b, c);
	i_rnd(22, c, d, a, b);
	i_rnd(20, b, c, d, a);
	i_rnd(18, a, b, c, d);
	i_rnd(16, d, a, b, c);
	i_rnd(14, c, d, a, b);
	i_rnd(12, b, c, d, a);
	i_rnd(10, a, b, c, d);
	i_rnd(8, d, a, b, c);
	i_rnd(6, c, d, a, b);
	i_rnd(4, b, c, d, a);
	i_rnd(2, a, b, c, d);

#ifndef WORDS_BIGENDIAN
	_blk[3] = d - l_key[1];
	_blk[2] = c;
	_blk[1] = b - l_key[0];
	_blk[0] = a;
#else
	_blk[3] = byteswap(d - l_key[1]);
	_blk[2] = byteswap(c);
	_blk[1] = byteswap(b - l_key[0]);
	_blk[0] = byteswap(a);
#endif
}
