#include "../lib/mcrypt.h"
#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

char test0[2][500];

int main()
{

	int i;
	int j, x = 0;
	unsigned char *keyword, *password;
	unsigned char cipher_tmp[500];

	printf("Checking whether the key generation work normally\n");

/* Test vectors with key and plaintext == zero */
	strcpy(test0[0], "85405b7844b25b2a");
	strcpy(test0[1], "08b55826cbad398e");
	bzero(cipher_tmp, sizeof(cipher_tmp));

	i = DES;		/* Not really needed */

	password = malloc(mcrypt_get_key_size(i));
	keyword = malloc(mcrypt_get_key_size(i));

	memset(password, '\2', mcrypt_get_key_size(i));
	memset(password, '\3', mcrypt_get_key_size(i) / 2);
	memset(password, '\5', mcrypt_get_key_size(i) / 4);
	gen_key_sha1(keyword, NULL, 0, mcrypt_get_key_size(i), password,
		     mcrypt_get_key_size(i));

	printf("SHA-1: ");
#ifdef DEBUG
	printf("\npassword:    ");
	for (j = 0; j < mcrypt_get_key_size(i); j++)
		printf("%.2x", password[j]);
	printf("\n");
#endif


	for (j = 0; j < mcrypt_get_key_size(i); j++) {
		sprintf(&((char *) cipher_tmp)[2 * j], "%.2x", keyword[j]);
	}

#ifdef DEBUG
	printf("HASH: ");
	printf("%s\n", cipher_tmp);
#endif

	if (strcmp((void *) cipher_tmp, (void *) test0[0]) != 0) {
		printf("failed compatibility\n");
		x = 1;
	} else {
		printf("ok\n");
	}

	gen_key_md5(keyword, NULL, 0, mcrypt_get_key_size(i), password,
		    mcrypt_get_key_size(i));

	printf("MD5: ");
#ifdef DEBUG
	printf("\npassword:    ");
	for (j = 0; j < mcrypt_get_key_size(i); j++) {
		printf("%.2x", password[j]);
	}
	printf("\n");
#endif


	for (j = 0; j < mcrypt_get_key_size(i); j++) {
		sprintf(&((char *) cipher_tmp)[2 * j], "%.2x", keyword[j]);
	}

#ifdef DEBUG
	printf("HASH: ");
	printf("%s\n", cipher_tmp);
#endif

	if (strcmp((void *) cipher_tmp, (void *) test0[1]) != 0) {
		printf("failed compatibility\n");
		x = 1;
	} else {
		printf("ok\n");
	}


	free(keyword);
	free(password);

	return x;

}
