/*
 *    "enigma.c" is in file cbw.tar from
 *      anonymous FTP host watmsg.waterloo.edu: pub/crypt/cbw.tar.Z
 *
 *      A one-rotor machine designed along the lines of Enigma
 *      but considerably trivialized.
 *
 *      A public-domain replacement for the UNIX "crypt" command.
 *      Changed to fit in mcrypt by nmav@i-net.paiko.gr
 */

/* $Id: enigma.c,v 1.9 2000/02/26 21:46:46 nikos Exp $ */

#include "libdefs.h"
#include "enigma.h"
#include <bzero.h>

extern char *__crypt();

/* it needs to be linked against libufc or libcrypt */


void _mcrypt_set_key_crypt(CRYPT_KEY *ckey, char* password, int plen)
{
	int ic, i, k, temp, len;
	unsigned random;
	sword32 seed;
	char key[9], csalt[3], *enciph;
	char *pw = password;

	if (plen>8) plen=8;

/* Just because they're static */
	ckey->n1 = ckey->n2 = ckey->nr1 = ckey->nr2 = 0;

	Bzero(ckey, sizeof(CRYPT_KEY));
	strncpy(ckey->cbuf, pw, plen);
	Bzero(csalt, sizeof(csalt));

	strncpy(csalt, ckey->cbuf, 2);
	strcpy(key, ckey->cbuf);
	enciph = __crypt(key, csalt);
	len = strlen(enciph);
	if (len != 13) {	/* cannot crypt key */
		fprintf(stderr, "Cannot encrypt key\n");
		return;
	}
	memmove(ckey->cbuf, enciph, 13);

	seed = 123;
	for (i = 0; i < 13; i++)
		seed = seed * ckey->cbuf[i] + i;
	for (i = 0; i < ROTORSZ; i++) {
		ckey->t1[i] = i;
		ckey->deck[i] = i;
	}
	for (i = 0; i < ROTORSZ; i++) {
		seed = 5 * seed + ckey->cbuf[i % 13];
		random = seed % 65521;
		k = ROTORSZ - 1 - i;
		ic = (random & MASK) % (k + 1);
		random >>= 8;

		temp = ckey->t1[k];
		ckey->t1[k] = ckey->t1[ic];
		ckey->t1[ic] = temp;
		if (ckey->t3[k] != 0)
			continue;

		ic = (random & MASK) % k;
		while (ckey->t3[ic] != 0)
			ic = (ic + 1) % k;
		ckey->t3[k] = ic;
		ckey->t3[ic] = k;
	}

	for (i = 0; i < ROTORSZ; i++)
		ckey->t2[ckey->t1[i] & MASK] = i;

	return;
}


int shuffle(CRYPT_KEY* ckey)
{
	int i, ic, k, temp;
	unsigned random;
	static sword32 seed = 123;

	for (i = 0; i < ROTORSZ; i++) {
		seed = 5 * seed + ckey->cbuf[i % 13];
		random = seed % 65521;
		k = ROTORSZ - 1 - i;
		ic = (random & MASK) % (k + 1);
		temp = ckey->deck[k];
		ckey->deck[k] = ckey->deck[ic];
		ckey->deck[ic] = temp;
	}
	return 0;
}

void _mcrypt_encrypt_crypt(CRYPT_KEY *ckey, void *gtext, int textlen)
{				/* 0 or 1 */
	int i, j;
	int secureflg=0;
	char *text = gtext;

	for (j = 0; j < textlen; j++) {

		i = text[j];
		if (secureflg) {
			ckey->nr1 = ckey->deck[ckey->n1] & MASK;
			ckey->nr2 = ckey->deck[ckey->nr1] & MASK;
		} else {
			ckey->nr1 = ckey->n1;
		}
		i = ckey->t2[(ckey->t3[(ckey->t1[(i + ckey->nr1) & MASK] + ckey->nr2) & MASK] - ckey->nr2) & MASK] - ckey->nr1;
		text[j] = i;
		ckey->n1++;
		if (ckey->n1 == ROTORSZ) {
			ckey->n1 = 0;
			ckey->n2++;
			if (ckey->n2 == ROTORSZ)
				ckey->n2 = 0;
			if (secureflg) {
				shuffle(ckey);
			} else {
				ckey->nr2 = ckey->n2;
			}
		}
	}

	return;
}

void _mcrypt_decrypt_crypt(CRYPT_KEY *ckey, void *gtext, int textlen)
{				/* 0 or 1 */
	int i, j;
	int secureflg=0;
	char *text = gtext;


	for (j = 0; j < textlen; j++) {

		i = text[j];
		if (secureflg) {
			ckey->nr1 = ckey->deck[ckey->n1] & MASK;
			ckey->nr2 = ckey->deck[ckey->nr1] & MASK;
		} else {
			ckey->nr1 = ckey->n1;
		}
		i = ckey->t2[(ckey->t3[(ckey->t1[(i + ckey->nr1) & MASK] + ckey->nr2) & MASK] - ckey->nr2) & MASK] - ckey->nr1;
		text[j] = i;
		ckey->n1++;
		if (ckey->n1 == ROTORSZ) {
			ckey->n1 = 0;
			ckey->n2++;
			if (ckey->n2 == ROTORSZ)
				ckey->n2 = 0;
			if (secureflg) {
				shuffle(ckey);
			} else {
				ckey->nr2 = ckey->n2;
			}
		}
	}

	return;
}


